/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.genenetwork.model.FollowTheLeaderMotionStrategy;
import edu.colorado.phet.genenetwork.model.Glucose;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.LinearThenRandomMotionStrategy;
import edu.colorado.phet.genenetwork.model.SimpleSugar;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;

public class Galactose
extends SimpleSugar {
    private static final Dimension2D GLUCOSE_ATTACHMENT_OFFSET = new PDimension(-Galactose.getWidth() / 2.0, 0.0);
    private Glucose glucoseAttachmentPartner;

    public Galactose(IGeneNetworkModelControl iGeneNetworkModelControl, Point2D point2D) {
        super(iGeneNetworkModelControl, point2D, Color.ORANGE);
    }

    public Galactose(IGeneNetworkModelControl iGeneNetworkModelControl) {
        this(iGeneNetworkModelControl, new Point2D.Double());
    }

    public Galactose() {
        this(null);
    }

    public void attach(Glucose glucose) {
        assert (this.glucoseAttachmentPartner == null);
        this.glucoseAttachmentPartner = glucose;
        Dimension2D dimension2D = Glucose.getGalactoseAttachmentPointOffset();
        dimension2D.setSize(dimension2D.getWidth() - GLUCOSE_ATTACHMENT_OFFSET.getWidth(), dimension2D.getHeight() - GLUCOSE_ATTACHMENT_OFFSET.getHeight());
        Point2D.Double double_ = new Point2D.Double(glucose.getPositionRef().getX() + dimension2D.getWidth(), glucose.getPositionRef().getY() + dimension2D.getHeight());
        this.setPosition(double_);
        this.setMotionStrategy(new FollowTheLeaderMotionStrategy(this, this.glucoseAttachmentPartner, dimension2D));
        this.setDragBounds(this.glucoseAttachmentPartner.getDragBounds());
    }

    public void detach(Glucose glucose) {
        assert (glucose == this.glucoseAttachmentPartner);
        this.glucoseAttachmentPartner = null;
        this.setMotionStrategy(new LinearThenRandomMotionStrategy(this.getModel().getInteriorMotionBounds(), this.getPositionRef(), new Vector2D(3.0, -8.0), 1.0));
        this.setExistenceTime(0.5);
    }

    public void setDragging(boolean bl) {
        super.setDragging(bl);
        if (this.glucoseAttachmentPartner != null) {
            this.glucoseAttachmentPartner.setDragging(bl);
        }
    }

    public void setPosition(double d, double d2) {
        super.setPosition(d, d2);
        if (this.isUserControlled() && this.glucoseAttachmentPartner != null) {
            assert (this.glucoseAttachmentPartner.isUserControlled());
            this.glucoseAttachmentPartner.setPosition(d + GLUCOSE_ATTACHMENT_OFFSET.getWidth() * 2.0, d2 + GLUCOSE_ATTACHMENT_OFFSET.getHeight());
        }
    }
}

