/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.genenetwork.model.DnaStrand;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.LacYGene;
import edu.colorado.phet.genenetwork.model.LacZGene;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class DnaStrandWithLacY
extends DnaStrand {
    protected DnaStrand.DnaSegmentSpace lacYGeneSpace;

    public DnaStrandWithLacY(IGeneNetworkModelControl iGeneNetworkModelControl, Dimension2D dimension2D, Point2D point2D) {
        super(iGeneNetworkModelControl, dimension2D, point2D);
        double d = this.getLacZGeneLocation().getX() + new LacZGene().getShape().getBounds2D().getMaxX() + new LacYGene().getShape().getBounds2D().getWidth() / 2.0 + 1.0;
        this.lacYGeneSpace = new DnaStrand.DnaSegmentSpace(this, new LacYGene().getShape(), new Point2D.Double(d, 0.0));
        this.shapeList.add(this.lacYGeneSpace);
    }

    protected void handleModelElementAdded(SimpleModelElement simpleModelElement) {
        super.handleModelElementAdded(simpleModelElement);
        if (simpleModelElement instanceof LacYGene) {
            this.lacYGeneSpace.setEyeCatching(true);
            this.lacYGeneSpace.setModelElement(simpleModelElement);
        }
    }

    public Point2D getLacYGeneLocation() {
        return new Point2D.Double(this.getPositionRef().getX() + this.lacYGeneSpace.getOffsetFromDnaStrandPosRef().getX(), this.getPositionRef().getY() + this.lacYGeneSpace.getOffsetFromDnaStrandPosRef().getY());
    }

    public boolean isOnLacYGeneSpace(Point2D point2D) {
        Rectangle2D rectangle2D = this.lacYGeneSpace.getBounds2D();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + this.lacYGeneSpace.getOffsetFromDnaStrandPosRef().getX() + this.getPositionRef().getX(), rectangle2D.getY() + this.lacYGeneSpace.getOffsetFromDnaStrandPosRef().getY() + this.getPositionRef().getY(), rectangle2D.getWidth(), rectangle2D.getHeight() + 3.0);
        return double_.contains(point2D);
    }

    public boolean isLacYGeneInPlace() {
        LacYGene lacYGene = this.model.getLacYGene();
        boolean bl = false;
        if (lacYGene != null) {
            double d = this.lacYGeneSpace.getOffsetFromDnaStrandPosRef().getX() + this.getPositionRef().getX();
            double d2 = this.lacYGeneSpace.getOffsetFromDnaStrandPosRef().getY() + this.getPositionRef().getY();
            if (lacYGene.getPositionRef().getX() + 0.01 > d && lacYGene.getPositionRef().getX() - 0.01 < d && lacYGene.getPositionRef().getY() + 0.01 > d2 && lacYGene.getPositionRef().getY() - 0.01 < d2) {
                bl = true;
            }
        }
        return bl;
    }
}

