/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.genenetwork.model.AbstractMotionStrategy;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public class DirectedRandomWalkMotionStrategy
extends AbstractMotionStrategy {
    private static final Random RAND = new Random();
    protected static double DIRECT_MOVEMENT_RANGE = 13.0;
    private double updateCountdownTimer = 0.0;

    public DirectedRandomWalkMotionStrategy(Rectangle2D rectangle2D, Point2D point2D) {
        super(rectangle2D);
        if (point2D != null) {
            this.setDestination(point2D.getX(), point2D.getY());
        }
        this.updateCountdownTimer = RAND.nextDouble() * 0.8;
    }

    public DirectedRandomWalkMotionStrategy(Rectangle2D rectangle2D) {
        this(rectangle2D, null);
    }

    public void updatePositionAndMotion(double d, SimpleModelElement simpleModelElement) {
        Point2D point2D = simpleModelElement.getPositionRef();
        Vector2D vector2D = simpleModelElement.getVelocityRef();
        if (point2D.getX() > this.getBounds().getMaxX() && vector2D.getX() > 0.0 || point2D.getX() < this.getBounds().getMinX() && vector2D.getX() < 0.0) {
            simpleModelElement.setVelocity(-vector2D.getX(), vector2D.getY());
        }
        if (point2D.getY() > this.getBounds().getMaxY() && vector2D.getY() > 0.0 || point2D.getY() < this.getBounds().getMinY() && vector2D.getY() < 0.0) {
            simpleModelElement.setVelocity(vector2D.getX(), -vector2D.getY());
        }
        if (!simpleModelElement.isUserControlled()) {
            simpleModelElement.setPosition(simpleModelElement.getPositionRef().getX() + simpleModelElement.getVelocityRef().getX() * d, simpleModelElement.getPositionRef().getY() + simpleModelElement.getVelocityRef().getY() * d);
        }
        this.updateCountdownTimer -= d;
        if (this.updateCountdownTimer <= 0.0) {
            double d2 = 0.0;
            double d3 = this.getDestinationRef() != null ? 5.0 + 10.0 * RAND.nextDouble() : 3.0 + 5.0 * RAND.nextDouble();
            d2 = this.getDestinationRef() != null && (this.getDestinationRef().distance(simpleModelElement.getPositionRef()) < DIRECT_MOVEMENT_RANGE || RAND.nextDouble() < 0.9) ? Math.atan2(this.getDestinationRef().getY() - simpleModelElement.getPositionRef().getY(), this.getDestinationRef().getX() - simpleModelElement.getPositionRef().getX()) : Math.PI * 2 * RAND.nextDouble();
            simpleModelElement.setVelocity(d3 * Math.cos(d2), d3 * Math.sin(d2));
            this.updateCountdownTimer = 0.8;
        }
    }
}

