/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.common.phetcommon.view.menu.OptionsMenu;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.genenetwork.GeneNetworkConstants;
import edu.colorado.phet.genenetwork.module.LacOperonModule;
import edu.colorado.phet.genenetwork.module.LactoseTransportModule;

public class LacOperonApplication
extends PiccoloPhetApplication {
    public LacOperonApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar(phetApplicationConfig.getCommandLineArgs());
    }

    private void initModules() {
        PhetFrame phetFrame = this.getPhetFrame();
        LacOperonModule lacOperonModule = new LacOperonModule(phetFrame);
        this.addModule(lacOperonModule);
        LactoseTransportModule lactoseTransportModule = new LactoseTransportModule(phetFrame);
        this.addModule(lactoseTransportModule);
    }

    private void initMenubar(String[] stringArray) {
        PhetFrame phetFrame = this.getPhetFrame();
        OptionsMenu optionsMenu = new OptionsMenu();
        if (optionsMenu.getMenuComponentCount() > 0) {
            phetFrame.addMenu(optionsMenu);
        }
    }

    public static void main(String[] stringArray) throws ClassNotFoundException {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new LacOperonApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "gene-network", "gene-machine-lac-operon");
        PhetLookAndFeel phetLookAndFeel = new PhetLookAndFeel();
        phetLookAndFeel.setBackgroundColor(GeneNetworkConstants.LAC_OPERON_CONTROL_PANEL_COLOR);
        phetApplicationConfig.setLookAndFeel(phetLookAndFeel);
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

