/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.F2;
import fj.Function;
import fj.Monoid;
import fj.Ord;
import fj.Ordering;
import fj.P;
import fj.P3;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Booleans;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Set<A>
implements Iterable<A> {
    private final Ord<A> ord;

    private Set(Ord<A> ord) {
        this.ord = ord;
    }

    public final boolean isEmpty() {
        return this instanceof Empty;
    }

    abstract Color color();

    abstract Set<A> l();

    abstract A head();

    abstract Set<A> r();

    public static <A> Set<A> empty(Ord<A> ord) {
        return new Empty(ord);
    }

    public final boolean member(A a) {
        return !this.isEmpty() && (this.ord.isLessThan(a, this.head()) && this.l().member(a) || this.ord.eq(this.head(), a) || this.r().member(a));
    }

    public static <A> F<Set<A>, F<A, Boolean>> member() {
        return Function.curry(new F2<Set<A>, A, Boolean>(){

            @Override
            public Boolean f(Set<A> set, A a) {
                return set.member(a);
            }
        });
    }

    public final Set<A> insert(A a) {
        return super.makeBlack();
    }

    private Set<A> ins(A a) {
        return this.isEmpty() ? new Tree(this.ord, Color.R, Set.empty(this.ord), a, Set.empty(this.ord)) : (this.ord.isLessThan(a, this.head()) ? Set.balance(this.ord, this.color(), super.ins(a), this.head(), this.r()) : (this.ord.eq(a, this.head()) ? new Tree(this.ord, this.color(), this.l(), a, this.r()) : Set.balance(this.ord, this.color(), this.l(), this.head(), super.ins(a))));
    }

    private Set<A> makeBlack() {
        return new Tree(this.ord, Color.B, this.l(), this.head(), this.r());
    }

    private static <A> Tree<A> tr(Ord<A> ord, Set<A> set, A a, Set<A> set2, A a2, Set<A> set3, A a3, Set<A> set4) {
        return new Tree(ord, Color.R, new Tree(ord, Color.B, set, a, set2), a2, new Tree(ord, Color.B, set3, a3, set4));
    }

    private static <A> Set<A> balance(Ord<A> ord, Color color, Set<A> set, A a, Set<A> set2) {
        return color == Color.B && super.isTR() && super.isTR() ? Set.tr(ord, set.l().l(), set.l().head(), set.l().r(), set.head(), set.r(), a, set2) : (color == Color.B && super.isTR() && super.isTR() ? Set.tr(ord, set.l(), set.head(), set.r().l(), set.r().head(), set.r().r(), a, set2) : (color == Color.B && super.isTR() && super.isTR() ? Set.tr(ord, set, a, set2.l().l(), set2.l().head(), set2.l().r(), set2.head(), set2.r()) : (color == Color.B && super.isTR() && super.isTR() ? Set.tr(ord, set, a, set2.l(), set2.head(), set2.r().l(), set2.r().head(), set2.r().r()) : new Tree(ord, color, set, a, set2))));
    }

    private boolean isTR() {
        return !this.isEmpty() && this.color() == Color.R;
    }

    @Override
    public final Iterator<A> iterator() {
        return this.toStream().iterator();
    }

    public static <A> Set<A> single(Ord<A> ord, A a) {
        return Set.empty(ord).insert(a);
    }

    public final <B> B foldMap(F<A, B> f, Monoid<B> monoid) {
        return this.isEmpty() ? monoid.zero() : monoid.sum(monoid.sum(this.r().foldMap(f, monoid), f.f(this.head())), this.l().foldMap(f, monoid));
    }

    public final List<A> toList() {
        return this.foldMap(List.cons(List.nil()), Monoid.listMonoid());
    }

    public final Stream<A> toStream() {
        return this.foldMap(Stream.single(), Monoid.streamMonoid());
    }

    public final Set<A> union(Set<A> set) {
        return Set.iterableSet(this.ord, set.toStream().append(this.toStream()));
    }

    public final Set<A> filter(F<A, Boolean> f) {
        return Set.iterableSet(this.ord, this.toStream().filter(f));
    }

    public final Set<A> delete(A a) {
        return this.minus(Set.single(this.ord, a));
    }

    public final Set<A> minus(Set<A> set) {
        return this.filter(Function.compose(Booleans.not, Set.member().f(set)));
    }

    public final P3<Set<A>, Option<A>, Set<A>> split(A a) {
        if (this.isEmpty()) {
            return P.p(Set.empty(this.ord), Option.none(), Set.empty(this.ord));
        }
        A a2 = this.head();
        Ordering ordering = this.ord.compare(a, a2);
        if (ordering == Ordering.LT) {
            P3<Set<A>, Option<A>, Set<A>> p3 = this.l().split(a);
            return P.p(p3._1(), p3._2(), p3._3().insert(a2).union(this.r()));
        }
        if (ordering == Ordering.GT) {
            P3<Set<A>, Option<A>, Set<A>> p3 = this.r().split(a);
            return P.p(p3._1().insert(a2).union(this.l()), p3._2(), p3._3());
        }
        return P.p(this.l(), Option.some(a2), this.r());
    }

    public static <A> Set<A> iterableSet(Ord<A> ord, Iterable<A> iterable) {
        Set<A> set = Set.empty(ord);
        for (A a : iterable) {
            set = set.insert(a);
        }
        return set;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Color
    extends Enum<Color> {
        public static final /* enum */ Color R = new Color();
        public static final /* enum */ Color B = new Color();
        private static final /* synthetic */ Color[] $VALUES;

        public static Color[] values() {
            return (Color[])$VALUES.clone();
        }

        static {
            $VALUES = new Color[]{R, B};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Empty<A>
    extends Set<A> {
        private Empty(Ord<A> ord) {
            super(ord);
        }

        @Override
        public Color color() {
            return Color.B;
        }

        @Override
        public Set<A> l() {
            throw new Error("Left on empty set.");
        }

        @Override
        public Set<A> r() {
            throw new Error("Right on empty set.");
        }

        @Override
        public A head() {
            throw new Error("Head on empty set.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Tree<A>
    extends Set<A> {
        private final Color c;
        private final Set<A> a;
        private final A x;
        private final Set<A> b;

        private Tree(Ord<A> ord, Color color, Set<A> set, A a, Set<A> set2) {
            super(ord);
            this.c = color;
            this.a = set;
            this.x = a;
            this.b = set2;
        }

        @Override
        public Color color() {
            return this.c;
        }

        @Override
        public Set<A> l() {
            return this.a;
        }

        @Override
        public A head() {
            return this.x;
        }

        @Override
        public Set<A> r() {
            return this.b;
        }
    }
}

