/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.F;
import fj.Show;
import fj.data.List;
import fj.data.Validation;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Option<A>
implements Iterable<A> {
    public static final F<String, Option<Byte>> parseByte = new F<String, Option<Byte>>(){

        @Override
        public Option<Byte> f(String string) {
            return Validation.parseByte(string).toOption();
        }
    };
    public static final F<String, Option<Double>> parseDouble = new F<String, Option<Double>>(){

        @Override
        public Option<Double> f(String string) {
            return Validation.parseDouble(string).toOption();
        }
    };
    public static final F<String, Option<Float>> parseFloat = new F<String, Option<Float>>(){

        @Override
        public Option<Float> f(String string) {
            return Validation.parseFloat(string).toOption();
        }
    };
    public static final F<String, Option<Integer>> parseInt = new F<String, Option<Integer>>(){

        @Override
        public Option<Integer> f(String string) {
            return Validation.parseInt(string).toOption();
        }
    };
    public static final F<String, Option<Long>> parseLong = new F<String, Option<Long>>(){

        @Override
        public Option<Long> f(String string) {
            return Validation.parseLong(string).toOption();
        }
    };
    public static final F<String, Option<Short>> parseShort = new F<String, Option<Short>>(){

        @Override
        public Option<Short> f(String string) {
            return Validation.parseShort(string).toOption();
        }
    };

    private Option() {
    }

    public String toString() {
        Show show = Show.anyShow();
        return Show.optionShow(show).showS(this);
    }

    @Override
    public final Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public abstract A some();

    public final boolean isSome() {
        return this instanceof Some;
    }

    public final boolean isNone() {
        return this instanceof None;
    }

    public final <B> B option(B b, F<A, B> f) {
        return this.isSome() ? f.f(this.some()) : b;
    }

    public final A orSome(A a) {
        return this.isSome() ? this.some() : a;
    }

    public final <B> Option<B> map(F<A, B> f) {
        return this.isSome() ? Option.some(f.f(this.some())) : Option.none();
    }

    public final <B> Option<B> bind(F<A, Option<B>> f) {
        return this.isSome() ? f.f(this.some()) : Option.none();
    }

    public final List<A> toList() {
        return this.isSome() ? List.cons(this.some(), List.nil()) : List.nil();
    }

    public final Collection<A> toCollection() {
        return this.toList().toCollection();
    }

    public static <T> Option<T> some(T t) {
        return new Some<T>(t);
    }

    public static <T> Option<T> none() {
        return new None();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class None<A>
    extends Option<A> {
        private None() {
        }

        @Override
        public A some() {
            throw Bottom.error("some on None");
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Some<A>
    extends Option<A> {
        private final A a;

        Some(A a) {
            this.a = a;
        }

        @Override
        public A some() {
            return this.a;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.a == null ? 0 : this.a.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Some some = (Some)object;
            return !(this.a == null ? some.a != null : !this.a.equals(some.a));
        }
    }
}

