/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.F;
import fj.Function;
import fj.P;
import fj.data.LazyString;
import fj.data.List;
import fj.data.Natural;
import fj.data.Option;
import fj.data.Stream;
import fj.data.hlist.HList;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Show<A> {
    private final F<A, Stream<Character>> f;
    public static final Show<Boolean> booleanShow = Show.anyShow();
    public static final Show<Byte> byteShow = Show.anyShow();
    public static final Show<Character> charShow = Show.anyShow();
    public static final Show<Double> doubleShow = Show.anyShow();
    public static final Show<Float> floatShow = Show.anyShow();
    public static final Show<Integer> intShow = Show.anyShow();
    public static final Show<BigInteger> bigintShow = Show.anyShow();
    public static final Show<BigDecimal> bigdecimalShow = Show.anyShow();
    public static final Show<Long> longShow = Show.anyShow();
    public static final Show<Short> shortShow = Show.anyShow();
    public static final Show<String> stringShow = Show.anyShow();
    public static final Show<StringBuffer> stringBufferShow = Show.anyShow();
    public static final Show<StringBuilder> stringBuilderShow = Show.anyShow();
    public static final Show<Natural> naturalShow = bigintShow.comap(new F<Natural, BigInteger>(){

        @Override
        public BigInteger f(Natural natural) {
            return natural.bigIntegerValue();
        }
    });
    public static final Show<LazyString> lazyStringShow = Show.show(new F<LazyString, Stream<Character>>(){

        @Override
        public Stream<Character> f(LazyString lazyString) {
            return lazyString.toStream();
        }
    });
    public static final Show<HList.HNil> HListShow = Show.showS(Function.constant("Nil"));

    private Show(F<A, Stream<Character>> f) {
        this.f = f;
    }

    public <B> Show<B> comap(F<B, A> f) {
        return Show.show(Function.compose(this.f, f));
    }

    public Stream<Character> show(A a) {
        return this.f.f(a);
    }

    public String showS(A a) {
        return Stream.asString(this.show(a));
    }

    public F<A, Stream<Character>> show_() {
        return this.f;
    }

    public static <A> Show<A> show(F<A, Stream<Character>> f) {
        return new Show<A>(f);
    }

    public static <A> Show<A> showS(final F<A, String> f) {
        return new Show<A>(new F<A, Stream<Character>>(){

            @Override
            public Stream<Character> f(A a) {
                return Stream.fromString((String)f.f(a));
            }
        });
    }

    public static <A> Show<A> anyShow() {
        return new Show<A>(new F<A, Stream<Character>>(){

            @Override
            public Stream<Character> f(A a) {
                return Stream.fromString(a.toString());
            }
        });
    }

    public static <A> Show<Option<A>> optionShow(final Show<A> show) {
        return new Show<Option<A>>(new F<Option<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Option<A> option) {
                return option.isNone() ? Stream.fromString("None") : Stream.fromString("Some(").append((Stream)show.f.f(option.some())).append(Stream.single(Character.valueOf(')')));
            }
        });
    }

    public static <A> Show<List<A>> listShow(final Show<A> show) {
        return new Show<List<A>>(new F<List<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(List<A> list) {
                return Show.streamShow(show).show(list.toStream());
            }
        });
    }

    public static <A> Show<Stream<A>> streamShow(final Show<A> show) {
        return new Show<Stream<A>>(new F<Stream<A>, Stream<Character>>(){

            @Override
            public Stream<Character> f(Stream<A> stream) {
                return Stream.join(stream.map(show.show_()).intersperse(Stream.fromString(",")).cons(Stream.fromString("<")).snoc(P.p(Stream.fromString(">"))));
            }
        });
    }
}

