/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.F;
import fj.data.LazyString;
import fj.data.List;
import fj.data.Stream;
import fj.data.hlist.HList;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Equal<A> {
    private final F<A, F<A, Boolean>> f;
    public static final Equal<Boolean> booleanEqual = Equal.anyEqual();
    public static final Equal<Byte> byteEqual = Equal.anyEqual();
    public static final Equal<Character> charEqual = Equal.anyEqual();
    public static final Equal<Double> doubleEqual = Equal.anyEqual();
    public static final Equal<Float> floatEqual = Equal.anyEqual();
    public static final Equal<Integer> intEqual = Equal.anyEqual();
    public static final Equal<BigInteger> bigintEqual = Equal.anyEqual();
    public static final Equal<BigDecimal> bigdecimalEqual = Equal.anyEqual();
    public static final Equal<Long> longEqual = Equal.anyEqual();
    public static final Equal<Short> shortEqual = Equal.anyEqual();
    public static final Equal<String> stringEqual = Equal.anyEqual();
    public static final Equal<StringBuffer> stringBufferEqual = new Equal<StringBuffer>(new F<StringBuffer, F<StringBuffer, Boolean>>(){

        @Override
        public F<StringBuffer, Boolean> f(final StringBuffer stringBuffer) {
            return new F<StringBuffer, Boolean>(){

                @Override
                public Boolean f(StringBuffer stringBuffer2) {
                    if (stringBuffer.length() == stringBuffer2.length()) {
                        for (int i = 0; i < stringBuffer.length(); ++i) {
                            if (stringBuffer.charAt(i) == stringBuffer2.charAt(i)) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
    });
    public static final Equal<StringBuilder> stringBuilderEqual = new Equal<StringBuilder>(new F<StringBuilder, F<StringBuilder, Boolean>>(){

        @Override
        public F<StringBuilder, Boolean> f(final StringBuilder stringBuilder) {
            return new F<StringBuilder, Boolean>(){

                @Override
                public Boolean f(StringBuilder stringBuilder2) {
                    if (stringBuilder.length() == stringBuilder2.length()) {
                        for (int i = 0; i < stringBuilder.length(); ++i) {
                            if (stringBuilder.charAt(i) == stringBuilder2.charAt(i)) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
    });
    public static final Equal<LazyString> eq = Equal.streamEqual(charEqual).comap(LazyString.toStream);
    public static final Equal<HList.HNil> hListEqual = Equal.anyEqual();

    private Equal(F<A, F<A, Boolean>> f) {
        this.f = f;
    }

    public boolean eq(A a, A a2) {
        return this.f.f(a).f(a2);
    }

    public F<A, Boolean> eq(final A a) {
        return new F<A, Boolean>(){

            @Override
            public Boolean f(A a2) {
                return Equal.this.eq(a, a2);
            }
        };
    }

    public <B> Equal<B> comap(F<B, A> f) {
        return Equal.equal(f.andThen().o(this.f).o(f));
    }

    public static <A> Equal<A> equal(F<A, F<A, Boolean>> f) {
        return new Equal<A>(f);
    }

    public static <A> Equal<A> anyEqual() {
        return new Equal<A>(new F<A, F<A, Boolean>>(){

            @Override
            public F<A, Boolean> f(final A a) {
                return new F<A, Boolean>(){

                    @Override
                    public Boolean f(A a2) {
                        return a.equals(a2);
                    }
                };
            }
        });
    }

    public static <A> Equal<List<A>> listEqual(final Equal<A> equal) {
        return new Equal<List<A>>(new F<List<A>, F<List<A>, Boolean>>(){

            @Override
            public F<List<A>, Boolean> f(final List<A> list) {
                return new F<List<A>, Boolean>(){

                    @Override
                    public Boolean f(List<A> list4) {
                        List list2 = list;
                        List list3 = list4;
                        while (list2.isNotEmpty() && list3.isNotEmpty()) {
                            if (!equal.eq(list2.head(), list3.head())) {
                                return false;
                            }
                            list2 = list2.tail();
                            list3 = list3.tail();
                        }
                        return list2.isEmpty() && list3.isEmpty();
                    }
                };
            }
        });
    }

    public static <A> Equal<Stream<A>> streamEqual(final Equal<A> equal) {
        return new Equal<Stream<A>>(new F<Stream<A>, F<Stream<A>, Boolean>>(){

            @Override
            public F<Stream<A>, Boolean> f(final Stream<A> stream) {
                return new F<Stream<A>, Boolean>(){

                    @Override
                    public Boolean f(Stream<A> stream4) {
                        Stream stream2 = stream;
                        Stream stream3 = stream4;
                        while (stream2.isNotEmpty() && stream3.isNotEmpty()) {
                            if (!equal.eq(stream2.head(), stream3.head())) {
                                return false;
                            }
                            stream2 = stream2.tail()._1();
                            stream3 = stream3.tail()._1();
                        }
                        return stream2.isEmpty() && stream3.isEmpty();
                    }
                };
            }
        });
    }
}

