/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import edu.umd.cs.piccolo.activities.PActivityScheduler;

public class PActivity {
    private PActivityScheduler scheduler;
    private long startTime;
    private long duration;
    private long stepRate;
    private PActivityDelegate delegate;
    private boolean stepping;
    private long nextStepTime;

    public PActivity(long l, long l2) {
        this(l, l2, System.currentTimeMillis());
    }

    public PActivity(long l, long l2, long l3) {
        this.duration = l;
        this.stepRate = l2;
        this.startTime = l3;
        this.nextStepTime = l3;
        this.stepping = false;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public long getStepRate() {
        return this.stepRate;
    }

    public long getDuration() {
        return this.duration;
    }

    public PActivityScheduler getActivityScheduler() {
        return this.scheduler;
    }

    public void setActivityScheduler(PActivityScheduler pActivityScheduler) {
        this.scheduler = pActivityScheduler;
    }

    public boolean isStepping() {
        return this.stepping;
    }

    protected boolean isAnimation() {
        return false;
    }

    protected void activityStarted() {
        if (this.delegate != null) {
            this.delegate.activityStarted(this);
        }
    }

    protected void activityStep(long l) {
        if (this.delegate != null) {
            this.delegate.activityStepped(this);
        }
    }

    protected void activityFinished() {
        if (this.delegate != null) {
            this.delegate.activityFinished(this);
        }
    }

    public void setDelegate(PActivityDelegate pActivityDelegate) {
        this.delegate = pActivityDelegate;
    }

    public void terminate() {
        this.terminate(2);
    }

    public void terminate(int n) {
        if (this.scheduler != null) {
            this.scheduler.removeActivity(this);
        }
        switch (n) {
            case 0: {
                this.stepping = false;
                break;
            }
            case 1: {
                if (this.stepping) {
                    this.stepping = false;
                    this.activityFinished();
                    break;
                }
                this.activityStarted();
                this.activityFinished();
                break;
            }
            case 2: {
                if (!this.stepping) break;
                this.stepping = false;
                this.activityFinished();
                break;
            }
            default: {
                throw new RuntimeException("Invalid termination behaviour provided to PActivity.terminate");
            }
        }
    }

    public long processStep(long l) {
        if (l < this.startTime) {
            return this.startTime - l;
        }
        if (l > this.getStopTime()) {
            if (this.stepping) {
                this.stepping = false;
                this.scheduler.removeActivity(this);
                this.activityFinished();
            } else {
                this.activityStarted();
                this.scheduler.removeActivity(this);
                this.activityFinished();
            }
            return -1L;
        }
        if (!this.stepping) {
            this.activityStarted();
            this.stepping = true;
        }
        if (l >= this.nextStepTime) {
            this.activityStep(l - this.startTime);
            this.nextStepTime = l + this.stepRate;
        }
        return this.stepRate;
    }

    public long getStopTime() {
        if (this.duration == -1L) {
            return Long.MAX_VALUE;
        }
        return this.startTime + this.duration;
    }

    public static interface PActivityDelegate {
        public void activityStarted(PActivity var1);

        public void activityStepped(PActivity var1);

        public void activityFinished(PActivity var1);
    }
}

