/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.view.beaker;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.fractions.fractionsintro.intro.view.beaker.Solution;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class SolutionNode
extends PComposite {
    private final PDimension cylinderSize;
    private final double cylinderEndHeight;
    private final Solution solution;
    private final Function.LinearFunction volumeFunction;
    private final PPath cylinderNode;
    private final PPath surfaceNode;

    public SolutionNode(PDimension pDimension, double d, Solution solution, DoubleRange doubleRange) {
        this.cylinderSize = pDimension;
        this.cylinderEndHeight = d;
        this.solution = solution;
        this.volumeFunction = new Function.LinearFunction(doubleRange.getMin(), doubleRange.getMax(), doubleRange.getMin() / doubleRange.getMax() * pDimension.getHeight(), pDimension.getHeight());
        this.cylinderNode = new PPath(){
            {
                this.setStroke(null);
            }
        };
        this.surfaceNode = new PPath(){
            {
                this.setStroke(new BasicStroke(0.9f));
                this.setStrokePaint(Color.black);
            }
        };
        this.addChild(this.cylinderNode);
        this.addChild(this.surfaceNode);
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                SolutionNode.this.updateNode();
            }
        };
        solution.addConcentrationObserver(simpleObserver);
        solution.addPrecipitateAmountObserver(simpleObserver);
        solution.solute.addObserver(simpleObserver);
        solution.volume.addObserver(simpleObserver);
    }

    private void updateNode() {
        Color color = this.getColor();
        this.cylinderNode.setPaint(color);
        this.surfaceNode.setPaint(color);
        double d = this.volumeFunction.evaluate(this.solution.volume.get());
        this.cylinderNode.setPathTo(this.createCylinderShape(d));
        this.surfaceNode.setPathTo(this.createSurfaceShape(d));
    }

    protected Color getColor() {
        Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, this.solution.getSaturatedConcentration(), 0.0, 1.0);
        double d = linearFunction.evaluate(this.solution.getConcentration());
        Color color = new Color(0xE0FFFF);
        return ColorUtils.interpolateRBGA(color, this.solution.solute.get().solutionColor, d);
    }

    private Shape createCylinderShape(double d) {
        Shape shape;
        if (d == 0.0) {
            shape = new GeneralPath();
        } else {
            Area area = new Area(new Rectangle2D.Double(0.0, this.cylinderSize.getHeight() - d, this.cylinderSize.getWidth(), d));
            area.add(new Area(new Ellipse2D.Double(0.0, this.cylinderSize.getHeight() - d - this.cylinderEndHeight / 2.0, this.cylinderSize.getWidth(), this.cylinderEndHeight)));
            area.add(new Area(new Ellipse2D.Double(0.0, this.cylinderSize.getHeight() - this.cylinderEndHeight / 2.0, this.cylinderSize.getWidth(), this.cylinderEndHeight)));
            shape = area;
        }
        return shape;
    }

    private Shape createSurfaceShape(double d) {
        Shape shape;
        if (d == 0.0) {
            shape = new GeneralPath();
        } else {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, this.cylinderSize.getHeight() - d - this.cylinderEndHeight / 2.0, this.cylinderSize.getWidth(), this.cylinderEndHeight);
            shape = new Arc2D.Double(double_.x, double_.y, double_.width, double_.height, 0.0, -180.0, 0);
        }
        return shape;
    }
}

