/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.view.beaker;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.fractions.fractionsintro.intro.view.beaker.Solute;

public class Solution
implements Resettable {
    public final Property<Solute> solute;
    private final Property<Double> soluteAmount;
    public final Property<Double> volume;
    private final Property<Double> concentration;
    private final Property<Double> precipitateAmount;

    public Solution(Solute solute, double d, double d2) {
        this.solute = new Property<Solute>(solute);
        this.soluteAmount = new Property<Double>(d);
        this.volume = new Property<Double>(d2);
        this.concentration = new Property<Double>(0.0);
        this.precipitateAmount = new Property<Double>(0.0);
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                if (Solution.this.getVolume() > 0.0) {
                    Solution.this.concentration.set(Math.min(Solution.this.getSaturatedConcentration(), Solution.this.getSoluteAmount() / Solution.this.getVolume()));
                } else {
                    Solution.this.concentration.set(0.0);
                }
                Solution.this.precipitateAmount.set(Math.max(0.0, Solution.this.getVolume() * (Solution.this.getSoluteAmount() / Solution.this.getVolume() - Solution.this.getSaturatedConcentration())));
            }
        };
        richSimpleObserver.observe(this.solute, this.soluteAmount, this.volume);
    }

    private double getSoluteAmount() {
        return this.soluteAmount.get();
    }

    private double getVolume() {
        return this.volume.get();
    }

    public double getSaturatedConcentration() {
        return this.solute.get().saturatedConcentration;
    }

    public double getConcentration() {
        return this.concentration.get();
    }

    public void addConcentrationObserver(SimpleObserver simpleObserver) {
        this.concentration.addObserver(simpleObserver);
    }

    public void addPrecipitateAmountObserver(SimpleObserver simpleObserver) {
        this.precipitateAmount.addObserver(simpleObserver);
    }

    public void reset() {
        this.solute.reset();
        this.soluteAmount.reset();
        this.volume.reset();
    }
}

