/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.view;

import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Pie;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.PieSet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import edu.colorado.phet.fractions.fractionsintro.intro.view.WaterGlassNode;
import edu.colorado.phet.fractions.fractionsintro.intro.view.WaterGlassNodeFactory;
import edu.colorado.phet.fractions.fractionsintro.intro.view.pieset.PieSetNode;
import edu.colorado.phet.fractions.fractionsintro.intro.view.pieset.SliceNodeArgs;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import fj.F;
import fj.Ord;
import fj.data.List;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaterGlassSetNode
extends PieSetNode {
    public WaterGlassSetNode(SettableProperty<PieSet> settableProperty, PNode pNode, Color color, double d, double d2, boolean bl) {
        super(settableProperty, pNode, new WaterGlassNodeFactory(), WaterGlassSetNode.createEmptyCellsNode(color, d, d2), new F<PieSet, PNode>(){

            @Override
            public PNode f(PieSet pieSet) {
                return WaterGlassSetNode.createIcon(pieSet, new WaterGlassNodeFactory());
            }
        }, bl);
    }

    private static PNode createIcon(final PieSet pieSet, final F<SliceNodeArgs, PNode> f) {
        return new PNode(){
            {
                Slice slice = pieSet.sliceFactory.createBucketSlice(pieSet.denominator, 0L);
                PNode pNode = (PNode)f.f(new SliceNodeArgs(slice, pieSet.denominator, false));
                pNode.setPickable(false);
                pNode.setChildPaintInvalid(false);
                this.addChild(pNode);
                this.scale(0.28);
            }
        };
    }

    public static F<PieSet, PNode> createEmptyCellsNode(final Color color, final double d, final double d2) {
        return new F<PieSet, PNode>(){

            @Override
            public PNode f(PieSet pieSet) {
                PNode pNode = new PNode();
                for (final Pie pie : pieSet.pies) {
                    final List<Double> list = pie.cells.map(new F<Slice, Double>(){

                        @Override
                        public Double f(Slice slice) {
                            return slice.getShape().getBounds2D().getMinY();
                        }
                    });
                    pNode.addChild(new PImage(WaterGlassNode.cachedWaterGlassNode(pieSet.countFilledCells(pie), pieSet.denominator, color, d, d2)){
                        {
                            super(image);
                            this.setOffset(pie.cells.index(0).getShape().getBounds2D().getX(), list.minimum(Ord.doubleOrd));
                        }
                    });
                }
                return pNode;
            }
        };
    }
}

