/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.view;

import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.RichPNode;
import edu.colorado.phet.fractions.FractionsResources;
import edu.colorado.phet.fractions.common.util.Cache;
import edu.colorado.phet.fractions.fractionsintro.intro.view.beaker.BeakerNode;
import edu.colorado.phet.fractions.fractionsintro.intro.view.beaker.Solute;
import edu.colorado.phet.fractions.fractionsintro.intro.view.beaker.Solution;
import edu.colorado.phet.fractions.fractionsintro.intro.view.beaker.SolutionNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import fj.F;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.beans.ConstructorProperties;

public class WaterGlassNode
extends RichPNode {
    private static final PhetFont BEAKER_LABEL_FONT = new PhetFont(1, 16);
    private static final PDimension BEAKER_LABEL_SIZE = new PDimension(100.0, 50.0);
    private static final DoubleRange SOLUTE_AMOUNT_RANGE = new DoubleRange(0.0, 0.2, 0.05);
    private static final DoubleRange DILUTION_VOLUME_RANGE = new DoubleRange(0.2, 1.0, 0.5);
    private static final DoubleRange CONCENTRATION_RANGE = new DoubleRange(SOLUTE_AMOUNT_RANGE.getMin() / DILUTION_VOLUME_RANGE.getMax(), SOLUTE_AMOUNT_RANGE.getMax() / DILUTION_VOLUME_RANGE.getMin());
    private static final F<Args, BufferedImage> images = new Cache<Args, BufferedImage>(new F<Args, BufferedImage>(){

        @Override
        public BufferedImage f(Args args) {
            return BufferedImageUtils.toBufferedImage(new WaterGlassNode(args.numerator, args.denominator, args.color, args.width, args.height).toImage());
        }
    });

    public static BufferedImage cachedWaterGlassNode(Integer n, Integer n2, Color color, double d, double d2) {
        return images.f(new Args(n, n2, color, d, d2));
    }

    private WaterGlassNode(Integer n, Integer n2, final Color color, double d, double d2) {
        super(new PNode[0]);
        double d3 = d / (double)FractionsResources.Images.WATER_GLASS_FRONT.getWidth();
        double d4 = d2 / (double)FractionsResources.Images.WATER_GLASS_FRONT.getHeight();
        BeakerNode beakerNode = new BeakerNode(1.0, d3, d4, null, BEAKER_LABEL_SIZE, BEAKER_LABEL_FONT, 1.0 / (double)n2.intValue(), 2, FractionsResources.Images.WATER_GLASS_FRONT);
        beakerNode.setLabelVisible();
        PDimension pDimension = beakerNode.getCylinderSize();
        Solute solute = new Solute(CONCENTRATION_RANGE.getMax(), new Color(0xE0FFFF));
        Solution solution = new Solution(solute, SOLUTE_AMOUNT_RANGE.getDefault(), (double)n.intValue() / (double)n2.intValue());
        SolutionNode solutionNode = new SolutionNode(pDimension, beakerNode.getCylinderEndHeight(), solution, new DoubleRange(0.0, 1.0)){

            protected Color getColor() {
                return color;
            }
        };
        BeakerNode beakerNode2 = new BeakerNode(1.0, d3, d4, null, BEAKER_LABEL_SIZE, BEAKER_LABEL_FONT, 1.0 / (double)n2.intValue(), 2, FractionsResources.Images.WATER_GLASS_BACK);
        beakerNode2.setLabelVisible();
        this.addChild(beakerNode2);
        this.addChild(solutionNode);
        this.addChild(beakerNode);
        beakerNode.setPickable(false);
        beakerNode.setChildrenPickable(false);
        beakerNode2.setPickable(true);
        beakerNode2.setChildrenPickable(true);
    }

    private static class Args {
        public final int numerator;
        public final int denominator;
        public final Color color;
        public final double width;
        public final double height;

        @ConstructorProperties(value={"numerator", "denominator", "color", "width", "height"})
        public Args(int n, int n2, Color color, double d, double d2) {
            this.numerator = n;
            this.denominator = n2;
            this.color = color;
            this.width = d;
            this.height = d2;
        }

        public int getNumerator() {
            return this.numerator;
        }

        public int getDenominator() {
            return this.denominator;
        }

        public Color getColor() {
            return this.color;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Args)) {
                return false;
            }
            Args args = (Args)object;
            if (!args.canEqual(this)) {
                return false;
            }
            if (this.getNumerator() != args.getNumerator()) {
                return false;
            }
            if (this.getDenominator() != args.getDenominator()) {
                return false;
            }
            if (this.getColor() == null ? args.getColor() != null : !this.getColor().equals(args.getColor())) {
                return false;
            }
            if (Double.compare(this.getWidth(), args.getWidth()) != 0) {
                return false;
            }
            return Double.compare(this.getHeight(), args.getHeight()) == 0;
        }

        public boolean canEqual(Object object) {
            return object instanceof Args;
        }

        public int hashCode() {
            int n = 1;
            long l = Double.doubleToLongBits(this.getWidth());
            long l2 = Double.doubleToLongBits(this.getHeight());
            n = n * 31 + this.getNumerator();
            n = n * 31 + this.getDenominator();
            n = n * 31 + (this.getColor() == null ? 0 : this.getColor().hashCode());
            n = n * 31 + (int)(l >>> 32 ^ l);
            n = n * 31 + (int)(l2 >>> 32 ^ l2);
            return n;
        }

        public String toString() {
            return "WaterGlassNode.Args(numerator=" + this.getNumerator() + ", denominator=" + this.getDenominator() + ", color=" + this.getColor() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
        }
    }
}

