/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.model.property.ValueEquals;
import edu.colorado.phet.common.phetcommon.model.property.integerproperty.IntegerProperty;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.Pair;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.util.functionaljava.FJUtils;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import edu.colorado.phet.fractions.fractionsintro.intro.view.Representation;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import fj.F;
import fj.Ord;
import fj.data.List;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberLineNode
extends PNode {
    private ArrayList<Pair<Double, Integer>> tickLocations;
    private final PhetPPath circle;
    private final SettableProperty<Integer> settableNumerator;
    private final ObservableProperty<Integer> denominator;
    private final IntegerProperty max;
    private final Orientation orientation;
    private final PhetPPath arrowPath;

    public NumberLineNode(final ObservableProperty<Integer> observableProperty, SettableProperty<Integer> settableProperty, final ObservableProperty<Integer> observableProperty2, ValueEquals<Representation> valueEquals, final IntegerProperty integerProperty, final Orientation orientation, final double d, Color color, final boolean bl) {
        this.settableNumerator = settableProperty;
        this.denominator = observableProperty2;
        this.max = integerProperty;
        this.orientation = orientation;
        this.scale(5.0);
        valueEquals.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                NumberLineNode.this.setVisible(bl);
            }
        });
        final RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                NumberLineNode.this.removeAllChildren();
                if (!NumberLineNode.this.getVisible()) {
                    return;
                }
                ArrayList<PhetPPath> arrayList = new ArrayList<PhetPPath>();
                int n = (Integer)observableProperty2.get();
                double d3 = d / (double)n;
                NumberLineNode.this.addChild(new PhetPPath(orientation.line(0.0, 0.0, d3 * (double)((Integer)integerProperty.get()).intValue() * (double)n, 0.0)));
                NumberLineNode.this.tickLocations = new ArrayList();
                for (int i = 0; i <= n * (Integer)integerProperty.get(); ++i) {
                    int n2;
                    BasicStroke object = new BasicStroke(4.0f);
                    if (i % n == 0) {
                        n2 = i / n;
                        int n3 = n2 % 2;
                        double d2 = n3 == 0 ? 8.0 : 8.0;
                        BasicStroke basicStroke = n3 == 0 ? new BasicStroke(1.0f) : new BasicStroke(0.5f);
                        final PhetPPath phetPPath = new PhetPPath(orientation.line((double)i * d3, -d2, (double)i * d3, d2), (Stroke)basicStroke, (Paint)Color.black);
                        boolean bl2 = ((Integer)observableProperty.get()).equals(i);
                        if (bl2) {
                            PhetPPath phetPPath2 = new PhetPPath(orientation.line((double)i * d3, -d2, (double)i * d3, d2), (Stroke)object, (Paint)Color.yellow);
                            phetPPath2.setVisible(bl2);
                            phetPPath2.setPickable(bl2);
                            NumberLineNode.this.addChild(phetPPath2);
                            arrayList.add(phetPPath2);
                        }
                        NumberLineNode.this.addChild(phetPPath);
                        NumberLineNode.this.addChild(new PhetPText(n2 + "", new PhetFont(8)){
                            {
                                super(string, font);
                                this.setOffset(orientation.getPositionForPText(phetPPath, this));
                            }
                        });
                        NumberLineNode.this.tickLocations.add(new Pair<Double, Integer>((double)i * d3, i));
                        continue;
                    }
                    n2 = ((Integer)observableProperty.get()).equals(i) ? 1 : 0;
                    if (n2 != 0) {
                        PhetPPath phetPPath = new PhetPPath(orientation.line((double)i * d3, -4.0, (double)i * d3, 4.0), (Stroke)object, (Paint)Color.yellow);
                        arrayList.add(phetPPath);
                        NumberLineNode.this.addChild(phetPPath);
                    }
                    NumberLineNode.this.addChild(new PhetPPath(orientation.line((double)i * d3, -4.0, (double)i * d3, 4.0), (Stroke)new BasicStroke(0.25f), (Paint)Color.black));
                    NumberLineNode.this.tickLocations.add(new Pair<Double, Integer>((double)i * d3, i));
                }
                for (PNode pNode : arrayList) {
                    pNode.moveToBack();
                }
                PBounds pBounds = NumberLineNode.this.getFullBounds();
                pBounds.setOrigin(pBounds.getX() - NumberLineNode.this.getOffset().getX(), pBounds.getY() - NumberLineNode.this.getOffset().getY());
                NumberLineNode.this.addChild(new PhetPPath(AffineTransform.getScaleInstance(0.2, 0.2).createTransformedShape(pBounds), new Color(0, 0, 0, 0), new BasicStroke(1.0f), new Color(0, 0, 0, 0)){
                    {
                        this.addInputEventListener(new CursorHandler());
                        this.addInputEventListener(new PBasicInputEventHandler(){

                            public void mousePressed(PInputEvent pInputEvent) {
                                NumberLineNode.this.handleMousePress(pInputEvent);
                            }
                        });
                    }
                });
                if (NumberLineNode.this.circle != null) {
                    NumberLineNode.this.circle.setOffset(orientation.get((double)((Integer)observableProperty.get()).intValue() / (double)((Integer)observableProperty2.get()).intValue() * d, 0.0).toPoint2D());
                    NumberLineNode.this.addChild(NumberLineNode.this.circle);
                }
                if (NumberLineNode.this.arrowPath != null && arrayList.size() > 0) {
                    NumberLineNode.this.arrowPath.setPathTo(NumberLineNode.createArrowShape(5.0, arrayList));
                    NumberLineNode.this.arrowPath.setVisible(bl);
                    NumberLineNode.this.addChild(NumberLineNode.this.arrowPath);
                }
            }
        };
        richSimpleObserver.observe(observableProperty, observableProperty2, integerProperty);
        this.addPropertyChangeListener("visible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                richSimpleObserver.update();
            }
        });
        BasicStroke basicStroke = new BasicStroke(0.6f);
        this.circle = new PhetPPath(new Area(new Ellipse2D.Double(-2.5, -2.5, 5.0, 5.0)){
            {
                this.subtract(new Area(new Ellipse2D.Double(-0.0, -0.0, 0.0, 0.0)));
            }
        }, color, basicStroke, Color.black){
            {
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new SimSharingDragHandler(FractionsIntroSimSharing.Components.numberLineKnob, UserComponentTypes.sprite, true){

                    protected void startDrag(PInputEvent pInputEvent) {
                        super.startDrag(pInputEvent);
                        NumberLineNode.this.handleMousePress(pInputEvent);
                    }

                    protected void drag(PInputEvent pInputEvent) {
                        super.drag(pInputEvent);
                        NumberLineNode.this.handleMousePress(pInputEvent);
                    }

                    protected void endDrag(PInputEvent pInputEvent) {
                        super.endDrag(pInputEvent);
                        NumberLineNode.this.handleMousePress(pInputEvent);
                    }
                });
            }
        };
        this.addChild(this.circle);
        this.arrowPath = new PhetPPath((Paint)color, (Stroke)new BasicStroke(basicStroke.getLineWidth() / 2.0f), (Paint)Color.black){
            {
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new SimSharingDragHandler(FractionsIntroSimSharing.Components.numberLineArrow, UserComponentTypes.sprite, true){

                    protected void startDrag(PInputEvent pInputEvent) {
                        super.startDrag(pInputEvent);
                        NumberLineNode.this.handleMousePress(pInputEvent);
                    }

                    protected void drag(PInputEvent pInputEvent) {
                        super.drag(pInputEvent);
                        NumberLineNode.this.handleMousePress(pInputEvent);
                    }

                    protected void endDrag(PInputEvent pInputEvent) {
                        super.endDrag(pInputEvent);
                        NumberLineNode.this.handleMousePress(pInputEvent);
                    }
                });
            }
        };
        this.addChild(this.arrowPath);
        richSimpleObserver.update();
    }

    private static GeneralPath createArrowShape(double d, ArrayList<PNode> arrayList) {
        PBounds pBounds = arrayList.get(0).getFullBounds();
        Vector2D vector2D = new Vector2D(pBounds.getX() + 1.0, pBounds.getCenterY());
        double d2 = 10.0 / d;
        return new Arrow(vector2D.plus(-5.0, 0.0).toPoint2D(), vector2D.toPoint2D(), d2, d2, d2 / 2.0).getShape();
    }

    void handleMousePress(PInputEvent pInputEvent) {
        Point2D point2D = pInputEvent.getPositionRelativeTo(pInputEvent.getPickedNode().getParent());
        final Vector2D vector2D = this.orientation.fromUserSpace(point2D.getX(), point2D.getY());
        Ord<Pair<Double, Integer>> ord = FJUtils.ord(new F<Pair<Double, Integer>, Double>(){

            @Override
            public Double f(Pair<Double, Integer> pair) {
                return Math.abs((Double)pair._1 - vector2D.getX());
            }
        });
        List<Pair<Double, Integer>> list = List.iterableList(this.tickLocations).filter(new F<Pair<Double, Integer>, Boolean>(){

            @Override
            public Boolean f(Pair<Double, Integer> pair) {
                return (Integer)pair._2 <= (Integer)NumberLineNode.this.max.get() * (Integer)NumberLineNode.this.denominator.get();
            }
        }).sort(ord);
        if (this.settableNumerator != null) {
            this.settableNumerator.set((Integer)list.head()._2);
        }
    }

    public static class Horizontal
    extends Orientation {
        public Vector2D get(double d, double d2) {
            return new Vector2D(d, d2);
        }

        public Vector2D fromUserSpace(double d, double d2) {
            return new Vector2D(d, d2);
        }

        public Point2D getPositionForPText(PNode pNode, PNode pNode2) {
            return new Point2D.Double(pNode.getFullBounds().getCenterX() - pNode2.getFullBounds().getWidth() / 2.0, pNode.getFullBounds().getMaxY());
        }
    }

    public static abstract class Orientation {
        public abstract Vector2D get(double var1, double var3);

        public Line2D.Double line(double d, double d2, double d3, double d4) {
            return this.get(d, d2).lineTo(this.get(d3, d4));
        }

        public abstract Vector2D fromUserSpace(double var1, double var3);

        public abstract Point2D getPositionForPText(PNode var1, PNode var2);
    }
}

