/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.model.property.ValueEquals;
import edu.colorado.phet.common.phetcommon.model.property.integerproperty.IntegerProperty;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.Pair;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.util.functionaljava.FJUtils;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import edu.colorado.phet.fractions.fractionsintro.intro.view.Representation;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import fj.F;
import fj.Ord;
import fj.data.List;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicNumberLineNode
extends PNode {
    private ArrayList<Pair<Double, Integer>> tickLocations;
    private final PhetPPath circle;
    private final SettableProperty<Integer> settableNumerator;
    private final ObservableProperty<Integer> denominator;
    private final IntegerProperty max;
    private final PhetPPath arrowPath;
    private final Vertical orientation;

    public DynamicNumberLineNode(final ObservableProperty<Integer> observableProperty, SettableProperty<Integer> settableProperty, final ObservableProperty<Integer> observableProperty2, ValueEquals<Representation> valueEquals, final IntegerProperty integerProperty, final double d, Color color, final boolean bl, final ObservableProperty<Integer> observableProperty3) {
        this.settableNumerator = settableProperty;
        this.denominator = observableProperty2;
        this.max = integerProperty;
        this.orientation = new Vertical();
        this.scale(5.0);
        valueEquals.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                DynamicNumberLineNode.this.setVisible(bl);
            }
        });
        final RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                PhetPPath phetPPath;
                double d5;
                int n2;
                DynamicNumberLineNode.this.removeAllChildren();
                if (!DynamicNumberLineNode.this.getVisible()) {
                    return;
                }
                ArrayList<PhetPPath> arrayList = new ArrayList<PhetPPath>();
                int n3 = (Integer)observableProperty2.get();
                int n4 = (Integer)observableProperty3.get();
                double d2 = d / (double)n3;
                double d3 = d / (double)n4;
                DynamicNumberLineNode.this.addChild(new PhetPPath(DynamicNumberLineNode.this.orientation.line(0.0, 0.0, d2 * (double)((Integer)integerProperty.get()).intValue() * (double)n3, 0.0)));
                DynamicNumberLineNode.this.tickLocations = new ArrayList();
                BasicStroke basicStroke = new BasicStroke(4.0f);
                for (n2 = 0; n2 <= n3 * (Integer)integerProperty.get(); ++n2) {
                    if (n2 % n3 != 0) continue;
                    int n = n2 / n3;
                    int phetPPath3 = n % 2;
                    d5 = phetPPath3 == 0 ? 8.0 : 8.0;
                    BasicStroke bl4 = phetPPath3 == 0 ? new BasicStroke(1.0f) : new BasicStroke(0.5f);
                    phetPPath = new PhetPPath(DynamicNumberLineNode.this.orientation.line((double)n2 * d2, -d5, (double)n2 * d2, d5), (Stroke)bl4, (Paint)Color.black);
                    boolean bl2 = ((Integer)observableProperty.get()).equals(n2);
                    if (bl2) {
                        PhetPPath phetPPath2 = new PhetPPath(DynamicNumberLineNode.this.orientation.line((double)n2 * d2, -d5, (double)n2 * d2, d5), (Stroke)basicStroke, (Paint)Color.yellow);
                        phetPPath2.setVisible(bl2);
                        phetPPath2.setPickable(bl2);
                        DynamicNumberLineNode.this.addChild(phetPPath2);
                        arrayList.add(phetPPath2);
                    }
                    DynamicNumberLineNode.this.addChild(phetPPath);
                    DynamicNumberLineNode.this.addChild(new PhetPText(n + "", new PhetFont(8)){
                        {
                            super(string, font);
                            this.setOffset(DynamicNumberLineNode.this.orientation.getPositionForPText(phetPPath, this));
                        }
                    });
                    DynamicNumberLineNode.this.tickLocations.add(new Pair<Double, Integer>((double)n2 * d2, n2));
                }
                for (n2 = 0; n2 <= n3 * (Integer)integerProperty.get(); ++n2) {
                    if (n2 % n3 == 0) continue;
                    boolean d4 = ((Integer)observableProperty.get()).equals(n2);
                    if (d4) {
                        PhetPPath phetPPath3 = new PhetPPath(DynamicNumberLineNode.this.orientation.line((double)n2 * d2, 0.0, (double)n2 * d2, 4.0), (Stroke)basicStroke, (Paint)Color.yellow);
                        arrayList.add(phetPPath3);
                        DynamicNumberLineNode.this.addChild(phetPPath3);
                    }
                    DynamicNumberLineNode.this.addChild(new PhetPPath(DynamicNumberLineNode.this.orientation.line((double)n2 * d2, 0.0, (double)n2 * d2, 4.0), (Stroke)new BasicStroke(0.25f), (Paint)Color.black));
                    DynamicNumberLineNode.this.tickLocations.add(new Pair<Double, Integer>((double)n2 * d2, n2));
                }
                for (n2 = 0; n2 <= n4 * (Integer)integerProperty.get(); ++n2) {
                    boolean bl5;
                    if (n2 % n4 == 0) continue;
                    double pNode = (double)n2 / (double)n4;
                    d5 = (double)((Integer)observableProperty.get()).intValue() / (double)((Integer)observableProperty2.get()).intValue();
                    boolean bl3 = bl5 = Math.abs(d5 - pNode) < 1.0E-6;
                    if (bl5) {
                        phetPPath = new PhetPPath(DynamicNumberLineNode.this.orientation.line((double)n2 * d3, -4.0, (double)n2 * d3, 0.0), (Stroke)basicStroke, (Paint)Color.yellow);
                        arrayList.add(phetPPath);
                        DynamicNumberLineNode.this.addChild(phetPPath);
                    }
                    DynamicNumberLineNode.this.addChild(new PhetPPath(DynamicNumberLineNode.this.orientation.line((double)n2 * d3, -4.0, (double)n2 * d3, 0.0), (Stroke)new BasicStroke(0.25f), (Paint)Color.black));
                    DynamicNumberLineNode.this.tickLocations.add(new Pair<Double, Integer>((double)n2 * d3, n2));
                }
                for (PNode pNode : arrayList) {
                    pNode.moveToBack();
                }
                PBounds pBounds = DynamicNumberLineNode.this.getFullBounds();
                pBounds.setOrigin(pBounds.getX() - DynamicNumberLineNode.this.getOffset().getX(), pBounds.getY() - DynamicNumberLineNode.this.getOffset().getY());
                DynamicNumberLineNode.this.addChild(new PhetPPath(AffineTransform.getScaleInstance(0.2, 0.2).createTransformedShape(pBounds), new Color(0, 0, 0, 0), new BasicStroke(1.0f), new Color(0, 0, 0, 0)){
                    {
                        this.addInputEventListener(new CursorHandler());
                        this.addInputEventListener(new PBasicInputEventHandler(){

                            public void mousePressed(PInputEvent pInputEvent) {
                                DynamicNumberLineNode.this.handleMousePress(pInputEvent);
                            }
                        });
                    }
                });
                if (DynamicNumberLineNode.this.circle != null) {
                    DynamicNumberLineNode.this.circle.setOffset(DynamicNumberLineNode.this.orientation.get((double)((Integer)observableProperty.get()).intValue() / (double)((Integer)observableProperty2.get()).intValue() * d, 0.0).toPoint2D());
                    DynamicNumberLineNode.this.addChild(DynamicNumberLineNode.this.circle);
                }
                if (DynamicNumberLineNode.this.arrowPath != null && arrayList.size() > 0) {
                    DynamicNumberLineNode.this.arrowPath.setPathTo(DynamicNumberLineNode.createArrowShape(5.0, arrayList));
                    DynamicNumberLineNode.this.arrowPath.setVisible(bl);
                    DynamicNumberLineNode.this.addChild(DynamicNumberLineNode.this.arrowPath);
                }
            }
        };
        richSimpleObserver.observe(observableProperty, observableProperty2, integerProperty);
        this.addPropertyChangeListener("visible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                richSimpleObserver.update();
            }
        });
        BasicStroke basicStroke = new BasicStroke(0.6f);
        this.circle = new PhetPPath(new Area(new Ellipse2D.Double(-2.5, -2.5, 5.0, 5.0)){
            {
                this.subtract(new Area(new Ellipse2D.Double(-0.0, -0.0, 0.0, 0.0)));
            }
        }, color, basicStroke, Color.black){
            {
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new SimSharingDragHandler(FractionsIntroSimSharing.Components.numberLineKnob, UserComponentTypes.sprite, true){

                    protected void startDrag(PInputEvent pInputEvent) {
                        super.startDrag(pInputEvent);
                        DynamicNumberLineNode.this.handleMousePress(pInputEvent);
                    }

                    protected void drag(PInputEvent pInputEvent) {
                        super.drag(pInputEvent);
                        DynamicNumberLineNode.this.handleMousePress(pInputEvent);
                    }

                    protected void endDrag(PInputEvent pInputEvent) {
                        super.endDrag(pInputEvent);
                        DynamicNumberLineNode.this.handleMousePress(pInputEvent);
                    }
                });
            }
        };
        this.addChild(this.circle);
        this.arrowPath = new PhetPPath((Paint)color, (Stroke)new BasicStroke(basicStroke.getLineWidth() / 2.0f), (Paint)Color.black){
            {
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new SimSharingDragHandler(FractionsIntroSimSharing.Components.numberLineArrow, UserComponentTypes.sprite, true){

                    protected void startDrag(PInputEvent pInputEvent) {
                        super.startDrag(pInputEvent);
                        DynamicNumberLineNode.this.handleMousePress(pInputEvent);
                    }

                    protected void drag(PInputEvent pInputEvent) {
                        super.drag(pInputEvent);
                        DynamicNumberLineNode.this.handleMousePress(pInputEvent);
                    }

                    protected void endDrag(PInputEvent pInputEvent) {
                        super.endDrag(pInputEvent);
                        DynamicNumberLineNode.this.handleMousePress(pInputEvent);
                    }
                });
            }
        };
        this.addChild(this.arrowPath);
        richSimpleObserver.update();
    }

    private static GeneralPath createArrowShape(double d, ArrayList<PNode> arrayList) {
        Rectangle2D rectangle2D = arrayList.get(0).getFullBounds();
        for (PNode pNode : List.iterableList(arrayList).tail()) {
            rectangle2D = ((Rectangle2D)rectangle2D).createUnion(pNode.getFullBounds());
        }
        Vector2D vector2D = new Vector2D(((RectangularShape)rectangle2D).getX() + 1.0, rectangle2D.getCenterY());
        double d2 = 10.0 / d;
        return new Arrow(vector2D.plus(-5.0, 0.0).toPoint2D(), vector2D.toPoint2D(), d2, d2, d2 / 2.0).getShape();
    }

    void handleMousePress(PInputEvent pInputEvent) {
        Point2D point2D = pInputEvent.getPositionRelativeTo(pInputEvent.getPickedNode().getParent());
        final Vector2D vector2D = this.orientation.fromUserSpace(point2D.getX(), point2D.getY());
        Ord<Pair<Double, Integer>> ord = FJUtils.ord(new F<Pair<Double, Integer>, Double>(){

            @Override
            public Double f(Pair<Double, Integer> pair) {
                return Math.abs((Double)pair._1 - vector2D.getX());
            }
        });
        List<Pair<Double, Integer>> list = List.iterableList(this.tickLocations).filter(new F<Pair<Double, Integer>, Boolean>(){

            @Override
            public Boolean f(Pair<Double, Integer> pair) {
                return (Integer)pair._2 <= (Integer)DynamicNumberLineNode.this.max.get() * (Integer)DynamicNumberLineNode.this.denominator.get();
            }
        }).sort(ord);
        if (this.settableNumerator != null) {
            this.settableNumerator.set((Integer)list.head()._2);
        }
    }

    public static class Vertical {
        public Line2D.Double line(double d, double d2, double d3, double d4) {
            return this.get(d, d2).lineTo(this.get(d3, d4));
        }

        public Vector2D get(double d, double d2) {
            return new Vector2D(d2, -d);
        }

        public Vector2D fromUserSpace(double d, double d2) {
            return new Vector2D(-d2, d);
        }

        public Point2D getPositionForPText(PNode pNode, PNode pNode2) {
            return new Point2D.Double(pNode.getFullBounds().getMaxX(), pNode.getFullBounds().getCenterY() - pNode2.getFullBounds().getHeight() / 2.0);
        }
    }
}

