/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.fractions.FractionsResources;
import edu.colorado.phet.fractions.common.util.Cache;
import edu.colorado.phet.fractions.common.view.FNode;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.PieSet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import edu.colorado.phet.fractions.fractionsintro.intro.view.pieset.PieSetNode;
import edu.colorado.phet.fractions.fractionsintro.intro.view.pieset.SliceNodeArgs;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import fj.F;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.ConstructorProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CakeSetNode
extends PieSetNode {
    private static final Cache<Arg, BufferedImage> cakeImages = new Cache<Arg, BufferedImage>(new F<Arg, BufferedImage>(){

        @Override
        public BufferedImage f(Arg arg) {
            return CakeSetNode.cropAndTrim(FractionsResources.RESOURCES.getImage("cake/cake_" + arg.denominator + "_" + (arg.cell + 1) + ".png"));
        }
    });
    private static final F<SliceNodeArgs, PNode> createSliceNode = new F<SliceNodeArgs, PNode>(){

        @Override
        public PNode f(SliceNodeArgs sliceNodeArgs) {
            return new SliceImage(sliceNodeArgs.slice.cell(sliceNodeArgs.denominator), sliceNodeArgs);
        }
    };
    private static final F<PieSet, PNode> CreateEmptyCellsNode = new F<PieSet, PNode>(){

        @Override
        public PNode f(final PieSet pieSet) {
            return new FNode(pieSet.cells.map(new F<Slice, Vector2D>(){

                @Override
                public Vector2D f(Slice slice) {
                    return slice.position;
                }
            }).nub().map(new F<Vector2D, PNode>(){

                @Override
                public PNode f(final Vector2D vector2D) {
                    return new PImage(CakeSetNode.cropAndTrim(FractionsResources.RESOURCES.getImage("cake/cake_grid_" + pieSet.denominator + ".png"))){
                        {
                            super(image);
                            this.setOffset(vector2D.x, vector2D.y);
                            this.setOffset(vector2D.x - this.getFullBounds().getWidth() / 2.0, vector2D.y - this.getFullBounds().getHeight() / 2.0 - 40.0);
                        }
                    };
                }
            }));
        }
    };

    public CakeSetNode(SettableProperty<PieSet> settableProperty, PNode pNode, boolean bl) {
        super(settableProperty, pNode, createSliceNode, CreateEmptyCellsNode, new F<PieSet, PNode>(){

            @Override
            public PNode f(PieSet pieSet) {
                return CakeSetNode.createBucketIcon(pieSet, createSliceNode);
            }
        }, bl);
    }

    private static BufferedImage cropAndTrim(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth() - 48, bufferedImage.getHeight(), bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawRenderedImage(bufferedImage, AffineTransform.getTranslateInstance(-24.0, 0.0));
        graphics2D.dispose();
        return BufferedImageUtils.multiScaleToWidth(bufferedImage2, (int)((double)bufferedImage2.getWidth() * 0.93));
    }

    public static class Arg {
        final int cell;
        final int denominator;

        @ConstructorProperties(value={"cell", "denominator"})
        public Arg(int n, int n2) {
            this.cell = n;
            this.denominator = n2;
        }

        public int getCell() {
            return this.cell;
        }

        public int getDenominator() {
            return this.denominator;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Arg)) {
                return false;
            }
            Arg arg = (Arg)object;
            if (!arg.canEqual(this)) {
                return false;
            }
            if (this.getCell() != arg.getCell()) {
                return false;
            }
            return this.getDenominator() == arg.getDenominator();
        }

        public boolean canEqual(Object object) {
            return object instanceof Arg;
        }

        public int hashCode() {
            int n = 1;
            n = n * 31 + this.getCell();
            n = n * 31 + this.getDenominator();
            return n;
        }

        public String toString() {
            return "CakeSetNode.Arg(cell=" + this.getCell() + ", denominator=" + this.getDenominator() + ")";
        }
    }

    static class SliceImage
    extends PImage {
        SliceImage(int n, SliceNodeArgs sliceNodeArgs) {
            super((Image)cakeImages.f(new Arg(n, sliceNodeArgs.denominator)));
            double d = this.getFullBounds().getHeight() / 4.0;
            this.setOffset(sliceNodeArgs.slice.position.getX(), sliceNodeArgs.slice.position.getY());
            this.setOffset(sliceNodeArgs.slice.position.getX() - this.getFullBounds().getWidth() / 2.0, sliceNodeArgs.slice.position.getY() - this.getFullBounds().getHeight() / 2.0 - d);
        }
    }
}

