/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories;

import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import fj.F;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerticalShape
extends F<Slice, Shape> {
    private final double height;
    private final double barWidth;

    public VerticalShape(double d, double d2) {
        this.height = d;
        this.barWidth = d2;
    }

    @Override
    public Shape f(Slice slice) {
        return new Rectangle2D.Double(slice.position.getX() - this.barWidth / 2.0, slice.position.getY() - this.height / 2.0, this.barWidth, this.height);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VerticalShape)) {
            return false;
        }
        VerticalShape verticalShape = (VerticalShape)object;
        if (!verticalShape.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.height, verticalShape.height) != 0) {
            return false;
        }
        return Double.compare(this.barWidth, verticalShape.barWidth) == 0;
    }

    public boolean canEqual(Object object) {
        return object instanceof VerticalShape;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.height);
        long l2 = Double.doubleToLongBits(this.barWidth);
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (int)(l2 >>> 32 ^ l2);
        return n;
    }
}

