/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.fractions.common.util.Size2D;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.SliceFactory;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.StackedHorizontalSliceToShape;
import fj.F;
import java.awt.Color;
import java.awt.Shape;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackedHorizontalSliceFactory
extends SliceFactory {
    private final double x;
    private final double y;
    private final boolean backwards;
    public final double barHeight = 40.0;
    public final double distanceBetweenBars = 30.0;
    private final double oneBarWidth = 200.0;

    public StackedHorizontalSliceFactory(Vector2D vector2D, Size2D size2D, Color color, double d, double d2, boolean bl) {
        super(15.0, vector2D, size2D, color);
        this.x = d;
        this.y = d2;
        this.backwards = bl;
    }

    final F<Slice, Shape> createToShape(double d) {
        return new StackedHorizontalSliceToShape(d, 40.0);
    }

    @Override
    public Slice createBucketSlice(int n, long l) {
        Random random = new Random(l);
        Slice slice = this.createPieCell(6, 0, 0, n);
        Shape shape = slice.getShape();
        double d = this.getBucketCenter().getX() - this.bucket.getHoleShape().getBounds2D().getWidth() / 2.0 + shape.getBounds2D().getWidth() / 2.0 + 20.0;
        double d2 = this.getBucketCenter().getX() + this.bucket.getHoleShape().getBounds2D().getWidth() / 2.0 - shape.getBounds2D().getWidth() / 2.0 - 20.0;
        double d3 = random.nextDouble() * (d2 - d) + d;
        return slice.withPosition(new Vector2D(d3, this.getBucketCenter().getY() + random.nextDouble() * this.yRange));
    }

    @Override
    public Slice createPieCell(int n, int n2, int n3, int n4) {
        if (this.backwards) {
            n3 = n4 - n3 - 1;
        }
        int n5 = n2;
        double d = 200.0 / (double)n4;
        double d2 = 70.0;
        Vector2D vector2D = new Vector2D(100.0, 400.0 - (double)n5 * d2);
        double d3 = vector2D.x - 100.0;
        double d4 = 200.0 - d * (double)n3;
        double d5 = d3 + d4 + d / 2.0;
        return new Slice(new Vector2D(d5 - d + this.x, vector2D.y + this.y), Math.PI, false, null, this.createToShape(200.0 / (double)n4), this.sliceColor, Slice.nextID());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackedHorizontalSliceFactory)) {
            return false;
        }
        StackedHorizontalSliceFactory stackedHorizontalSliceFactory = (StackedHorizontalSliceFactory)object;
        if (!stackedHorizontalSliceFactory.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.x, stackedHorizontalSliceFactory.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, stackedHorizontalSliceFactory.y) != 0) {
            return false;
        }
        if (this.backwards != stackedHorizontalSliceFactory.backwards) {
            return false;
        }
        if (Double.compare(this.barHeight, stackedHorizontalSliceFactory.barHeight) != 0) {
            return false;
        }
        if (Double.compare(this.distanceBetweenBars, stackedHorizontalSliceFactory.distanceBetweenBars) != 0) {
            return false;
        }
        return Double.compare(this.oneBarWidth, stackedHorizontalSliceFactory.oneBarWidth) == 0;
    }

    @Override
    public boolean canEqual(Object object) {
        return object instanceof StackedHorizontalSliceFactory;
    }

    @Override
    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        long l3 = Double.doubleToLongBits(this.barHeight);
        long l4 = Double.doubleToLongBits(this.distanceBetweenBars);
        long l5 = Double.doubleToLongBits(this.oneBarWidth);
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (int)(l2 >>> 32 ^ l2);
        n = n * 31 + (this.backwards ? 1231 : 1237);
        n = n * 31 + (int)(l3 >>> 32 ^ l3);
        n = n * 31 + (int)(l4 >>> 32 ^ l4);
        n = n * 31 + (int)(l5 >>> 32 ^ l5);
        return n;
    }
}

