/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.Bucket;
import edu.colorado.phet.common.phetcommon.util.functionaljava.FJUtils;
import edu.colorado.phet.common.phetcommon.view.Dimension2DDouble;
import edu.colorado.phet.fractions.common.util.Size2D;
import edu.colorado.phet.fractions.fractionsintro.intro.model.containerset.Container;
import edu.colorado.phet.fractions.fractionsintro.intro.model.containerset.ContainerSet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Pie;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.PieSet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import fj.F;
import fj.data.List;
import java.awt.Color;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SliceFactory {
    public static final Dimension2DDouble stageSize = new Dimension2DDouble(1024.0, 768.0);
    public final Color bucketColor = new Color(136, 177, 240);
    public final Bucket bucket;
    public final double yRange;
    public final Color sliceColor;

    SliceFactory(double d, Vector2D vector2D, Size2D size2D, Color color) {
        this.yRange = d;
        this.sliceColor = color;
        this.bucket = new Bucket(vector2D.x + 50.0, vector2D.y, size2D.toDimension2DDouble(), this.bucketColor, "");
    }

    public List<Pie> createEmptyPies(final int n, final int n2) {
        ArrayList<Pie> arrayList = new ArrayList<Pie>(){
            {
                for (int i = 0; i < n; ++i) {
                    ArrayList<Slice> arrayList = new ArrayList<Slice>();
                    for (int j = 0; j < n2; ++j) {
                        arrayList.add(SliceFactory.this.createPieCell(n, i, j, n2));
                    }
                    this.add(new Pie(List.iterableList(arrayList)));
                }
            }
        };
        return List.iterableList(arrayList);
    }

    public abstract Slice createBucketSlice(int var1, long var2);

    public abstract Slice createPieCell(int var1, int var2, int var3, int var4);

    public PieSet fromContainerSetState(ContainerSet containerSet) {
        List<Pie> list = this.createEmptyPies(containerSet.containers.length(), containerSet.denominator);
        return new PieSet(containerSet.denominator, list, this.createSlices(list, containerSet, 0L), this);
    }

    private List<Slice> createSlices(List<Pie> list, ContainerSet containerSet, long l) {
        ArrayList<Slice> arrayList = new ArrayList<Slice>();
        for (int i = 0; i < containerSet.containers.length(); ++i) {
            Container container = containerSet.containers.index(i);
            for (Integer n : container.filledCells) {
                arrayList.add(list.index((int)i).cells.index(n));
            }
        }
        return List.iterableList(arrayList).append(this.createSlicesForBucket(containerSet.denominator, 10, l));
    }

    public List<Slice> createSlicesForBucket(final int n, final int n2, long l) {
        final Random random = new Random(l);
        return List.iterableList(new ArrayList<Slice>(){
            {
                for (int i = 0; i < n2; ++i) {
                    this.add(SliceFactory.this.createBucketSlice(n, random.nextLong()));
                }
            }
        });
    }

    public Vector2D getBucketCenter() {
        double d = this.bucket.getHoleShape().getBounds2D().getCenterX() + this.bucket.getPosition().getX();
        double d2 = -this.bucket.getHoleShape().getBounds2D().getCenterY() - this.bucket.getPosition().getY();
        return new Vector2D(d, d2);
    }

    public Slice getDropTarget(PieSet pieSet, final Slice slice) {
        if (pieSet.getEmptyCells().length() == 0) {
            return null;
        }
        Slice slice2 = pieSet.getEmptyCells().minimum(FJUtils.ord(new F<Slice, Double>(){

            @Override
            public Double f(Slice slice2) {
                return slice2.getCenter().distance(slice.getCenter());
            }
        }));
        return slice2 != null && !new Area(slice2.getShape()){
            {
                super(shape);
                this.intersect(new Area(slice.getShape()));
            }
        }.isEmpty() ? slice2 : null;
    }

    public Color getBucketColor() {
        return this.bucketColor;
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public double getYRange() {
        return this.yRange;
    }

    public Color getSliceColor() {
        return this.sliceColor;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SliceFactory)) {
            return false;
        }
        SliceFactory sliceFactory = (SliceFactory)object;
        if (!sliceFactory.canEqual(this)) {
            return false;
        }
        if (this.getBucketColor() == null ? sliceFactory.getBucketColor() != null : !this.getBucketColor().equals(sliceFactory.getBucketColor())) {
            return false;
        }
        if (this.getBucket() == null ? sliceFactory.getBucket() != null : !this.getBucket().equals(sliceFactory.getBucket())) {
            return false;
        }
        if (Double.compare(this.getYRange(), sliceFactory.getYRange()) != 0) {
            return false;
        }
        return !(this.getSliceColor() == null ? sliceFactory.getSliceColor() != null : !this.getSliceColor().equals(sliceFactory.getSliceColor()));
    }

    public boolean canEqual(Object object) {
        return object instanceof SliceFactory;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.getYRange());
        n = n * 31 + (this.getBucketColor() == null ? 0 : this.getBucketColor().hashCode());
        n = n * 31 + (this.getBucket() == null ? 0 : this.getBucket().hashCode());
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (this.getSliceColor() == null ? 0 : this.getSliceColor().hashCode());
        return n;
    }

    public String toString() {
        return "SliceFactory(bucketColor=" + this.getBucketColor() + ", bucket=" + this.getBucket() + ", yRange=" + this.getYRange() + ", sliceColor=" + this.getSliceColor() + ")";
    }
}

