/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.fractions.common.util.Size2D;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.HorizontalShapeFunction;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.SliceFactory;
import fj.F;
import java.awt.Color;
import java.awt.Shape;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorizontalSliceFactory
extends SliceFactory {
    public final double barHeight = 50.0;
    private final int distanceBetweenBars = 20;
    private final double oneBarWidth = 310.0;

    public HorizontalSliceFactory(Vector2D vector2D, Size2D size2D, Color color) {
        super(15.0, vector2D, size2D, color);
    }

    final F<Slice, Shape> createToShape(double d) {
        return new HorizontalShapeFunction(d, 50.0);
    }

    @Override
    public Slice createBucketSlice(int n, long l) {
        Random random = new Random(l);
        Slice slice = this.createPieCell(6, 0, 0, n);
        Shape shape = slice.getShape();
        double d = this.getBucketCenter().getX() - this.bucket.getHoleShape().getBounds2D().getWidth() / 2.0 + shape.getBounds2D().getWidth() / 2.0 + 20.0;
        double d2 = this.getBucketCenter().getX() + this.bucket.getHoleShape().getBounds2D().getWidth() / 2.0 - shape.getBounds2D().getWidth() / 2.0 - 20.0;
        double d3 = random.nextDouble() * (d2 - d) + d;
        return slice.withPosition(new Vector2D(d3, this.getBucketCenter().getY() + random.nextDouble() * this.yRange));
    }

    @Override
    public Slice createPieCell(int n, int n2, int n3, int n4) {
        int n5 = Math.min(n, 3);
        double d = 330.0;
        double d2 = new Function.LinearFunction(1.0, 3.0, d * 1.0, 0.0).evaluate(n5);
        int n6 = n2 / 3;
        int n7 = n2 % 3;
        double d3 = 310.0 / (double)n4;
        double d4 = 70.0;
        Vector2D vector2D = new Vector2D(155.0 + (double)n7 * d + 20.0, 250.0 + (double)n6 * d4);
        double d5 = vector2D.getX() - 155.0;
        double d6 = d3 * (double)n3;
        double d7 = d5 + d6 + d3 / 2.0;
        return new Slice(new Vector2D(d7 + d2, vector2D.getY()), Math.PI, false, null, this.createToShape(310.0 / (double)n4), this.sliceColor, Slice.nextID());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HorizontalSliceFactory)) {
            return false;
        }
        HorizontalSliceFactory horizontalSliceFactory = (HorizontalSliceFactory)object;
        if (!horizontalSliceFactory.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.barHeight, horizontalSliceFactory.barHeight) != 0) {
            return false;
        }
        if (this.distanceBetweenBars != horizontalSliceFactory.distanceBetweenBars) {
            return false;
        }
        return Double.compare(this.oneBarWidth, horizontalSliceFactory.oneBarWidth) == 0;
    }

    @Override
    public boolean canEqual(Object object) {
        return object instanceof HorizontalSliceFactory;
    }

    @Override
    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.barHeight);
        long l2 = Double.doubleToLongBits(this.oneBarWidth);
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + this.distanceBetweenBars;
        n = n * 31 + (int)(l2 >>> 32 ^ l2);
        return n;
    }
}

