/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import fj.F;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorizontalShapeFunction
extends F<Slice, Shape> {
    public final double width;
    public final double barHeight;

    public HorizontalShapeFunction(double d, double d2) {
        this.width = d;
        this.barHeight = d2;
    }

    @Override
    public Shape f(Slice slice) {
        Vector2D vector2D = slice.position;
        return new Rectangle2D.Double(vector2D.getX() - this.width / 2.0, vector2D.getY() - this.barHeight / 2.0, this.width, this.barHeight);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HorizontalShapeFunction)) {
            return false;
        }
        HorizontalShapeFunction horizontalShapeFunction = (HorizontalShapeFunction)object;
        if (!horizontalShapeFunction.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.width, horizontalShapeFunction.width) != 0) {
            return false;
        }
        return Double.compare(this.barHeight, horizontalShapeFunction.barHeight) == 0;
    }

    public boolean canEqual(Object object) {
        return object instanceof HorizontalShapeFunction;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.width);
        long l2 = Double.doubleToLongBits(this.barHeight);
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (int)(l2 >>> 32 ^ l2);
        return n;
    }
}

