/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import fj.F;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CakeSliceFunction
extends F<Slice, Shape> {
    private final double extent;
    private final double radius;
    private final double spacing;

    public CakeSliceFunction(double d, double d2, double d3) {
        this.extent = d;
        this.radius = d2;
        this.spacing = d3;
    }

    @Override
    public Shape f(Slice slice) {
        double d = 1.0E-6;
        Vector2D vector2D = slice.position;
        double d2 = slice.angle;
        Ellipse2D.Double double_ = new Ellipse2D.Double(vector2D.x - this.radius, vector2D.y - this.radius, this.radius * 2.0, this.radius * 2.0 - this.radius * 0.65);
        if (Math.abs(this.extent - Math.PI) < d) {
            d2 += 1.5707963267948966;
        }
        return this.extent >= Math.PI * 2 - d ? double_ : new Arc2D.Double(double_.x, double_.y, double_.width, double_.height, d2 * 180.0 / Math.PI, this.extent * 180.0 / Math.PI, 2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CakeSliceFunction)) {
            return false;
        }
        CakeSliceFunction cakeSliceFunction = (CakeSliceFunction)object;
        if (!cakeSliceFunction.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.extent, cakeSliceFunction.extent) != 0) {
            return false;
        }
        if (Double.compare(this.radius, cakeSliceFunction.radius) != 0) {
            return false;
        }
        return Double.compare(this.spacing, cakeSliceFunction.spacing) == 0;
    }

    public boolean canEqual(Object object) {
        return object instanceof CakeSliceFunction;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.extent);
        long l2 = Double.doubleToLongBits(this.radius);
        long l3 = Double.doubleToLongBits(this.spacing);
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (int)(l2 >>> 32 ^ l2);
        n = n * 31 + (int)(l3 >>> 32 ^ l3);
        return n;
    }
}

