/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.fractions.common.util.Size2D;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.PieSet;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.Slice;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.CakeSliceFunction;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.factories.SliceFactory;
import fj.F;
import fj.Ord;
import fj.Ordering;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CakeSliceFactory
extends SliceFactory {
    public final double diameter = 144.15;
    public final double radius = 72.075;
    public final double spacing = 22.0;
    private static final HashMap<Integer, int[]> _renderOrder = new HashMap<Integer, int[]>(){
        {
            this.put(1, new int[]{1});
            this.put(2, new int[]{2, 1});
            this.put(3, new int[]{1, 2, 3});
            this.put(4, new int[]{1, 2, 3, 4});
            this.put(5, new int[]{2, 1, 3, 5, 4});
            this.put(6, new int[]{2, 1, 3, 6, 4, 5});
            this.put(7, new int[]{2, 3, 1, 4, 7, 5, 6});
            this.put(8, new int[]{2, 3, 1, 4, 5, 8, 6, 7});
        }
    };

    public CakeSliceFactory(Vector2D vector2D, Size2D size2D) {
        super(0.0, vector2D, size2D, null);
    }

    final F<Slice, Shape> getShapeFunction(double d) {
        return new CakeSliceFunction(d, 72.075, 22.0);
    }

    @Override
    public Slice createBucketSlice(int n, long l) {
        Random random = new Random(l);
        double d = Math.PI * 2 / (double)n;
        Vector2D vector2D = new Vector2D(this.getBucketCenter().x + (random.nextDouble() * 2.0 - 1.0) * 72.075, this.getBucketCenter().y + 18.01875 + random.nextDouble() / 100.0);
        return new Slice(vector2D, 4.71238898038469 - d / 2.0, false, null, this.getShapeFunction(d), null, Slice.nextID());
    }

    @Override
    public Slice createPieCell(int n, int n2, int n3, int n4) {
        double d = new Function.LinearFunction(1.0, 6.0, 384.40000000000003, 0.0).evaluate(n);
        double d2 = Math.PI * 2 / (double)n4;
        Vector2D vector2D = new Vector2D(144.15 * (double)(n2 + 1) + 22.0 * (double)(n2 + 1) - 80.0 + d, 300.0);
        return new Slice(vector2D, d2 * (double)n3, false, null, this.getShapeFunction(d2), null, Slice.nextID());
    }

    public static PieSet sort(final PieSet pieSet) {
        final int[] nArray = _renderOrder.get(pieSet.denominator);
        final ArrayList<Integer> arrayList = new ArrayList<Integer>(){
            {
                for (int n : nArray) {
                    this.add(n);
                }
            }
        };
        return pieSet.withSlices(pieSet.slices.sort(Ord.ord(new F<Slice, F<Slice, Ordering>>(){

            @Override
            public F<Slice, Ordering> f(final Slice slice) {
                return new F<Slice, Ordering>(){

                    @Override
                    public Ordering f(Slice slice2) {
                        int n;
                        int n2 = arrayList.indexOf(slice.cell(pieSet.denominator) + 1);
                        return n2 > (n = arrayList.indexOf(slice2.cell(pieSet.denominator) + 1)) ? Ordering.GT : (n2 < n ? Ordering.LT : (slice.id < slice2.id ? Ordering.LT : (slice.id > slice2.id ? Ordering.GT : Ordering.GT)));
                    }
                };
            }
        })));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CakeSliceFactory)) {
            return false;
        }
        CakeSliceFactory cakeSliceFactory = (CakeSliceFactory)object;
        if (!cakeSliceFactory.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.diameter, cakeSliceFactory.diameter) != 0) {
            return false;
        }
        if (Double.compare(this.radius, cakeSliceFactory.radius) != 0) {
            return false;
        }
        return Double.compare(this.spacing, cakeSliceFactory.spacing) == 0;
    }

    @Override
    public boolean canEqual(Object object) {
        return object instanceof CakeSliceFactory;
    }

    @Override
    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.diameter);
        long l2 = Double.doubleToLongBits(this.radius);
        long l3 = Double.doubleToLongBits(this.spacing);
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (int)(l2 >>> 32 ^ l2);
        n = n * 31 + (int)(l3 >>> 32 ^ l3);
        return n;
    }
}

