/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.containerset;

import edu.colorado.phet.common.phetcommon.util.functionaljava.FJUtils;
import edu.colorado.phet.fractions.fractionsintro.intro.model.containerset.CellPointer;
import edu.colorado.phet.fractions.fractionsintro.intro.model.containerset.Container;
import fj.Equal;
import fj.F;
import fj.F2;
import fj.Function;
import fj.data.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerSet {
    public final List<Container> containers;
    public final int denominator;
    public final int numerator;

    private static <T> Equal<T> refEqual() {
        return Equal.equal(Function.curry(new F2<T, T, Boolean>(){

            @Override
            public Boolean f(T t, T t2) {
                return t == t2;
            }
        }));
    }

    public ContainerSet(int n, Container[] containerArray) {
        this(n, Arrays.asList(containerArray));
    }

    public ContainerSet(int n, List<Container> list) {
        this(n, list.toCollection());
    }

    private ContainerSet(int n, Collection<Container> collection) {
        this.containers = List.iterableList(collection);
        this.denominator = n;
        int n2 = 0;
        for (Container container : collection) {
            n2 += container.filledCells.length();
        }
        this.numerator = n2;
    }

    public String toString() {
        return this.containers.toString();
    }

    public ContainerSet padAndTrim() {
        ContainerSet containerSet = this.trim();
        while (containerSet.containers.length() < 6) {
            containerSet = containerSet.addEmptyContainer();
        }
        return containerSet;
    }

    ContainerSet trim() {
        final List<Container> list = this.containers.reverse();
        final boolean[] blArray = new boolean[]{false};
        ArrayList<Container> arrayList = new ArrayList<Container>(){
            {
                for (Container container : list) {
                    if (!container.isEmpty().booleanValue()) {
                        blArray[0] = true;
                    }
                    if (!blArray[0]) continue;
                    this.add(container);
                }
            }
        };
        Collections.reverse(arrayList);
        return new ContainerSet(this.denominator, (Collection<Container>)arrayList);
    }

    ContainerSet addEmptyContainer() {
        return new ContainerSet(this.denominator, (Collection<Container>)new ArrayList<Container>(this.containers.toCollection()){
            {
                this.add(new Container(ContainerSet.this.denominator, new int[0]));
            }
        });
    }

    public ContainerSet toggle(final CellPointer cellPointer) {
        return new ContainerSet(this.denominator, this.containers.map(new F<Container, Container>(){

            @Override
            public Container f(Container container) {
                int n = ContainerSet.this.containers.elementIndex(ContainerSet.refEqual(), container).some();
                if (cellPointer.container == n) {
                    return container.toggle(cellPointer.cell);
                }
                return container;
            }
        }));
    }

    public CellPointer getLastFullCell() {
        return this.getAllCellPointers().reverse().find(new F<CellPointer, Boolean>(){

            @Override
            public Boolean f(CellPointer cellPointer) {
                return ContainerSet.this.isEmpty(cellPointer) == false;
            }
        }).some();
    }

    List<CellPointer> getAllCellPointers() {
        return List.iterableList(new ArrayList<CellPointer>(){
            {
                for (int i = 0; i < ContainerSet.this.containers.length(); ++i) {
                    for (int j = 0; j < ContainerSet.this.containers.index((int)i).numCells; ++j) {
                        this.add(new CellPointer(i, j));
                    }
                }
            }
        });
    }

    public CellPointer getFirstEmptyCell() {
        return this.getAllCellPointers().find(new F<CellPointer, Boolean>(){

            @Override
            public Boolean f(CellPointer cellPointer) {
                return ContainerSet.this.isEmpty(cellPointer);
            }
        }).some();
    }

    Boolean isEmpty(CellPointer cellPointer) {
        return this.containers.index(cellPointer.container).isEmpty(cellPointer.cell);
    }

    boolean isFilled(CellPointer cellPointer) {
        return this.isEmpty(cellPointer) == false;
    }

    CellPointer getClosestUnoccupiedLocation(final CellPointer cellPointer) {
        List<CellPointer> list = this.getEmptyCells();
        if (list.isEmpty()) {
            return null;
        }
        return list.minimum(FJUtils.ord(new F<CellPointer, Double>(){

            @Override
            public Double f(CellPointer cellPointer2) {
                return cellPointer.distance(cellPointer2);
            }
        }));
    }

    List<CellPointer> getFilledCells() {
        return this.getAllCellPointers().filter(new F<CellPointer, Boolean>(){

            @Override
            public Boolean f(CellPointer cellPointer) {
                return ContainerSet.this.isFilled(cellPointer);
            }
        });
    }

    List<CellPointer> getEmptyCells() {
        return this.getAllCellPointers().filter(new F<CellPointer, Boolean>(){

            @Override
            public Boolean f(CellPointer cellPointer) {
                return !ContainerSet.this.isFilled(cellPointer);
            }
        });
    }

    public ContainerSet update(final int n, final Integer n2) {
        ContainerSet containerSet = new ContainerSet((int)n2, List.iterableList(new ArrayList<Container>(){
            {
                for (int i = 0; i < n; ++i) {
                    this.add(new Container((int)n2, new int[0]));
                }
            }
        }));
        for (CellPointer cellPointer : this.getFilledCells()) {
            CellPointer cellPointer2 = containerSet.getClosestUnoccupiedLocation(cellPointer);
            if (cellPointer2 == null) continue;
            containerSet = containerSet.toggle(cellPointer2);
        }
        return containerSet;
    }

    public ContainerSet maximum(Integer n) {
        return this.update(n, this.denominator);
    }

    public ContainerSet scale(final int n) {
        return new ContainerSet(this.denominator * n, this.containers.map(new F<Container, Container>(){

            @Override
            public Container f(Container container) {
                return container.scale(n);
            }
        }));
    }

    public CellPointer getRandomEmptyCell(Random random) {
        List<CellPointer> list = this.getEmptyCells();
        return list.index(random.nextInt(list.length()));
    }

    public List<Container> getContainers() {
        return this.containers;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ContainerSet)) {
            return false;
        }
        ContainerSet containerSet = (ContainerSet)object;
        if (!containerSet.canEqual(this)) {
            return false;
        }
        if (this.getContainers() == null ? containerSet.getContainers() != null : !this.getContainers().equals(containerSet.getContainers())) {
            return false;
        }
        if (this.getDenominator() != containerSet.getDenominator()) {
            return false;
        }
        return this.getNumerator() == containerSet.getNumerator();
    }

    public boolean canEqual(Object object) {
        return object instanceof ContainerSet;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + (this.getContainers() == null ? 0 : this.getContainers().hashCode());
        n = n * 31 + this.getDenominator();
        n = n * 31 + this.getNumerator();
        return n;
    }
}

