/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.containerset;

import fj.F;
import fj.data.List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Container {
    public final int numCells;
    public final List<Integer> filledCells;

    public Container(int n, int[] nArray) {
        this(n, Container.toSet(nArray));
    }

    private static HashSet<Integer> toSet(int[] nArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n : nArray) {
            hashSet.add(n);
        }
        return hashSet;
    }

    public String toString() {
        return this.filledCells.toString();
    }

    private Container(int n, final Collection<Integer> collection) {
        this(n, List.iterableList(new HashSet<Integer>(){
            {
                for (Integer n : collection) {
                    this.add(n);
                }
            }
        }));
    }

    public Container(int n, List<Integer> list) {
        this.numCells = n;
        this.filledCells = list;
    }

    public Boolean isEmpty() {
        return this.filledCells.length() == 0;
    }

    public Boolean isEmpty(int n) {
        return !this.filledCells.exists(this.cellIndex(n));
    }

    private F<Integer, Boolean> cellIndex(final int n) {
        return new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n2) {
                return n2 == n;
            }
        };
    }

    public Container toggle(final int n) {
        if (!this.filledCells.exists(this.cellIndex(n))) {
            return new Container(this.numCells, (Collection<Integer>)new HashSet<Integer>(this.filledCells.toCollection()){
                {
                    super(collection);
                    this.add(n);
                }
            });
        }
        return new Container(this.numCells, (Collection<Integer>)new HashSet<Integer>(this.filledCells.toCollection()){
            {
                super(collection);
                this.remove(n);
            }
        });
    }

    public Container scale(final int n) {
        return new Container(this.numCells * n, List.iterableList(new ArrayList<Integer>(){
            {
                for (Integer n2 : Container.this.filledCells) {
                    for (int i = 0; i < n; ++i) {
                        this.add(n2 * n + i);
                    }
                }
            }
        }));
    }

    public int getNumCells() {
        return this.numCells;
    }

    public List<Integer> getFilledCells() {
        return this.filledCells;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Container)) {
            return false;
        }
        Container container = (Container)object;
        if (this.getNumCells() != container.getNumCells()) {
            return false;
        }
        return !(this.getFilledCells() == null ? container.getFilledCells() != null : !this.getFilledCells().equals(container.getFilledCells()));
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + this.getNumCells();
        n = n * 31 + (this.getFilledCells() == null ? 0 : this.getFilledCells().hashCode());
        return n;
    }
}

