/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.model.containerset;

import java.beans.ConstructorProperties;

public class CellPointer {
    public final int container;
    public final int cell;

    public double distance(CellPointer cellPointer) {
        return Math.abs(cellPointer.container - this.container) * 10 + Math.abs(cellPointer.cell - this.cell);
    }

    @ConstructorProperties(value={"container", "cell"})
    public CellPointer(int n, int n2) {
        this.container = n;
        this.cell = n2;
    }

    public int getContainer() {
        return this.container;
    }

    public int getCell() {
        return this.cell;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CellPointer)) {
            return false;
        }
        CellPointer cellPointer = (CellPointer)object;
        if (!cellPointer.canEqual(this)) {
            return false;
        }
        if (this.getContainer() != cellPointer.getContainer()) {
            return false;
        }
        return this.getCell() == cellPointer.getCell();
    }

    public boolean canEqual(Object object) {
        return object instanceof CellPointer;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + this.getContainer();
        n = n * 31 + this.getCell();
        return n;
    }

    public String toString() {
        return "CellPointer(container=" + this.getContainer() + ", cell=" + this.getCell() + ")";
    }
}

