/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.intro.controller;

import edu.colorado.phet.fractions.fractionsintro.intro.model.IntroState;
import edu.colorado.phet.fractions.fractionsintro.intro.model.containerset.CellPointer;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.PieSet;
import fj.F;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetNumerator
extends F<IntroState, IntroState> {
    public final int numerator;

    public SetNumerator(int n) {
        this.numerator = n;
    }

    @Override
    public IntroState f(IntroState introState) {
        block3: {
            int n;
            block2: {
                int n2 = introState.numerator;
                n = this.numerator - n2;
                if (n <= 0) break block2;
                for (int i = 0; i < n; ++i) {
                    final CellPointer cellPointer = introState.containerSet.getFirstEmptyCell();
                    final long l = introState.randomSeed;
                    introState = introState.updatePieSets(new F<PieSet, PieSet>(){

                        @Override
                        public PieSet f(PieSet pieSet) {
                            return pieSet.animateBucketSliceToPie(cellPointer, l);
                        }
                    }).numerator(this.numerator).nextRandomSeed();
                }
                break block3;
            }
            if (n >= 0) break block3;
            for (int i = 0; i < Math.abs(n); ++i) {
                final CellPointer cellPointer = introState.containerSet.getLastFullCell();
                final long l = introState.randomSeed;
                introState = introState.updatePieSets(new F<PieSet, PieSet>(){

                    @Override
                    public PieSet f(PieSet pieSet) {
                        return pieSet.animateSliceToBucket(cellPointer, l);
                    }
                }).numerator(this.numerator).nextRandomSeed();
            }
        }
        return introState;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SetNumerator)) {
            return false;
        }
        SetNumerator setNumerator = (SetNumerator)object;
        if (!setNumerator.canEqual(this)) {
            return false;
        }
        return this.numerator == setNumerator.numerator;
    }

    public boolean canEqual(Object object) {
        return object instanceof SetNumerator;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + this.numerator;
        return n;
    }
}

