/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionsintro.equalitylab.view;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.common.piccolophet.nodes.radiobuttonstrip.RadioButtonStripControlPanelNode;
import edu.colorado.phet.fractions.common.view.AbstractFractionsCanvas;
import edu.colorado.phet.fractions.common.view.Colors;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import edu.colorado.phet.fractions.fractionsintro.equalitylab.model.EqualityLabModel;
import edu.colorado.phet.fractions.fractionsintro.equalitylab.view.ScaledUpFractionNode;
import edu.colorado.phet.fractions.fractionsintro.intro.model.pieset.PieSet;
import edu.colorado.phet.fractions.fractionsintro.intro.view.DynamicNumberLineNode;
import edu.colorado.phet.fractions.fractionsintro.intro.view.FractionControlNode;
import edu.colorado.phet.fractions.fractionsintro.intro.view.Representation;
import edu.colorado.phet.fractions.fractionsintro.intro.view.RepresentationNode;
import edu.colorado.phet.fractions.fractionsintro.intro.view.WaterGlassSetNode;
import edu.colorado.phet.fractions.fractionsintro.intro.view.pieset.MovableSliceLayer;
import edu.colorado.phet.fractions.fractionsintro.intro.view.pieset.PieSetNode;
import edu.colorado.phet.fractions.fractionsintro.intro.view.representationcontrolpanel.HorizontalBarIcon;
import edu.colorado.phet.fractions.fractionsintro.intro.view.representationcontrolpanel.NumberLineIcon;
import edu.colorado.phet.fractions.fractionsintro.intro.view.representationcontrolpanel.PieIcon;
import edu.colorado.phet.fractions.fractionsintro.intro.view.representationcontrolpanel.VerticalBarIcon;
import edu.colorado.phet.fractions.fractionsintro.intro.view.representationcontrolpanel.WaterGlassIcon;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualityLabCanvas
extends AbstractFractionsCanvas {
    public EqualityLabCanvas(final EqualityLabModel equalityLabModel) {
        final SettableProperty<Representation> settableProperty = equalityLabModel.leftRepresentation;
        ObservableProperty<Representation> observableProperty = equalityLabModel.rightRepresentation;
        List<RadioButtonStripControlPanelNode.Element<Representation>> list = this.getIcons(settableProperty, "leftSide");
        RadioButtonStripControlPanelNode<Representation> radioButtonStripControlPanelNode = new RadioButtonStripControlPanelNode<Representation>(settableProperty, list, 7){
            {
                this.scale(1.0);
            }
        };
        final ZeroOffsetNode zeroOffsetNode = new ZeroOffsetNode((PNode)radioButtonStripControlPanelNode){
            {
                this.setOffset(60.0, 10.0);
            }
        };
        ZeroOffsetNode zeroOffsetNode2 = new ZeroOffsetNode(new PNode(){
            {
                settableProperty.addObserver(new VoidFunction1<Representation>(){

                    @Override
                    public void apply(Representation representation) {
                        this.removeAllChildren();
                        ArrayList<RadioButtonStripControlPanelNode.Element<Boolean>> arrayList = new ArrayList<RadioButtonStripControlPanelNode.Element<Boolean>>();
                        if (representation == Representation.PIE) {
                            arrayList.add(new RadioButtonStripControlPanelNode.Element<Boolean>(new PieIcon(new Property<Representation>(Representation.PIE), Colors.LIGHT_PINK), true, UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.pieRadioButton, "rightSide")));
                        } else if (representation == Representation.HORIZONTAL_BAR) {
                            arrayList.add(new RadioButtonStripControlPanelNode.Element<Boolean>(new HorizontalBarIcon(new Property<Representation>(Representation.HORIZONTAL_BAR), Colors.LIGHT_PINK){
                                {
                                    this.scale(0.8);
                                }
                            }, true, UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.horizontalBarRadioButton, "rightSide")));
                        } else if (representation == Representation.VERTICAL_BAR) {
                            VerticalBarIcon verticalBarIcon = new VerticalBarIcon(EqualityLabModel.scaledFactorySet.verticalSliceFactory, Colors.LIGHT_PINK);
                            PNode pNode = verticalBarIcon.getNode();
                            pNode.scale(0.8);
                            arrayList.add(new RadioButtonStripControlPanelNode.Element<Boolean>(pNode, true, UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.verticalBarRadioButton, "rightSide")));
                        } else if (representation == Representation.WATER_GLASSES) {
                            arrayList.add(new RadioButtonStripControlPanelNode.Element<Boolean>(new WaterGlassIcon(new Property<Representation>(Representation.WATER_GLASSES), Colors.LIGHT_PINK){
                                {
                                    this.scale(0.8);
                                }
                            }, true, UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.waterGlassesRadioButton, "rightSide")));
                        } else if (representation == Representation.NUMBER_LINE) {
                            arrayList.add(new RadioButtonStripControlPanelNode.Element<Boolean>(new NumberLineIcon(new Property<Representation>(Representation.NUMBER_LINE)), true, UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.numberLineRadioButton, "rightSide")));
                        }
                        arrayList.add(new RadioButtonStripControlPanelNode.Element<Boolean>(new NumberLineIcon(new Property<Representation>(Representation.NUMBER_LINE)), false, UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.numberLineRadioButton, "leftSide")));
                        this.addChild(new RadioButtonStripControlPanelNode<Boolean>(equalityLabModel.sameAsLeft, arrayList, 7){
                            {
                                this.scale(1.0);
                            }
                        });
                    }
                });
            }
        }){
            {
                super(pNode);
                this.setOffset(zeroOffsetNode.getMaxX() + 110.0, zeroOffsetNode.getCenterY() - this.getFullBounds().getHeight() / 2.0);
            }
        };
        this.addChildren(zeroOffsetNode, zeroOffsetNode2);
        ResetAllButtonNode resetAllButtonNode = new ResetAllButtonNode(new Resettable(){

            public void reset() {
                equalityLabModel.resetAll();
            }
        }, this, CONTROL_FONT, Color.black, Color.orange){
            {
                this.setConfirmationEnabled(false);
                this.setOffset(AbstractFractionsCanvas.STAGE_SIZE.width - this.getFullBounds().getWidth() - 10.0, AbstractFractionsCanvas.STAGE_SIZE.height - this.getFullBounds().getHeight() - 10.0);
            }
        };
        this.addChild(resetAllButtonNode);
        boolean bl = false;
        this.addPrimaryRepresentationNodes(equalityLabModel, settableProperty, equalityLabModel.pieSet, bl);
        this.addChild(new RepresentationNode(observableProperty, Representation.PIE, new PNode(){
            {
                equalityLabModel.scaledPieSet.addObserver(new SimpleObserver(){

                    public void update() {
                        this.removeAllChildren();
                        this.addChild(PieSetNode.CreateEmptyCellsNode.f((PieSet)equalityLabModel.scaledPieSet.get()));
                        this.addChild(new MovableSliceLayer((PieSet)equalityLabModel.scaledPieSet.get(), PieSetNode.CreateNode, equalityLabModel.scaledPieSet, EqualityLabCanvas.this.rootNode, null));
                    }
                });
                this.setChildrenPickable(false);
            }
        }));
        this.addChild(new RepresentationNode(observableProperty, Representation.HORIZONTAL_BAR, new PNode(){
            {
                equalityLabModel.rightHorizontalBars.addObserver(new SimpleObserver(){

                    public void update() {
                        this.removeAllChildren();
                        this.addChild(PieSetNode.CreateEmptyCellsNode.f((PieSet)equalityLabModel.rightHorizontalBars.get()));
                        this.addChild(new MovableSliceLayer((PieSet)equalityLabModel.rightHorizontalBars.get(), PieSetNode.CreateNode, equalityLabModel.rightHorizontalBars, EqualityLabCanvas.this.rootNode, null));
                    }
                });
                this.setChildrenPickable(false);
            }
        }));
        this.addChild(new RepresentationNode(observableProperty, Representation.VERTICAL_BAR, new PNode(){
            {
                equalityLabModel.rightVerticalBars.addObserver(new SimpleObserver(){

                    public void update() {
                        this.removeAllChildren();
                        this.addChild(PieSetNode.CreateEmptyCellsNode.f((PieSet)equalityLabModel.rightVerticalBars.get()));
                        this.addChild(new MovableSliceLayer((PieSet)equalityLabModel.rightVerticalBars.get(), PieSetNode.CreateNode, equalityLabModel.rightVerticalBars, EqualityLabCanvas.this.rootNode, null));
                    }
                });
                this.setChildrenPickable(false);
            }
        }));
        this.addChild(new RepresentationNode(observableProperty, Representation.WATER_GLASSES, new PNode(){
            {
                equalityLabModel.rightWaterGlasses.addObserver(new SimpleObserver(){

                    public void update() {
                        this.removeAllChildren();
                        Shape shape = EqualityLabModel.scaledFactorySet.waterGlassSetFactory.createSlicesForBucket((Integer)equalityLabModel.denominator.get(), 1, equalityLabModel.getRandomSeed()).head().getShape();
                        this.addChild(WaterGlassSetNode.createEmptyCellsNode(Colors.LIGHT_PINK, shape.getBounds2D().getWidth(), shape.getBounds2D().getHeight()).f((PieSet)equalityLabModel.rightWaterGlasses.get()));
                    }
                });
                this.setChildrenPickable(false);
            }
        }));
        this.addChild(new DynamicNumberLineNode(equalityLabModel.scaledNumerator, null, equalityLabModel.scaledDenominator, equalityLabModel.rightRepresentation.valueEquals(Representation.NUMBER_LINE), equalityLabModel.maximum, 15.0, new Color(Colors.LIGHT_PINK.getRed(), Colors.LIGHT_PINK.getGreen(), Colors.LIGHT_PINK.getBlue(), 200), true, equalityLabModel.denominator){
            {
                this.setOffset(585.0, 445.0);
                this.setPickable(false);
                this.setChildrenPickable(false);
            }
        });
        final ZeroOffsetNode zeroOffsetNode3 = new ZeroOffsetNode((PNode)new FractionControlNode(equalityLabModel.numerator, equalityLabModel.denominator, equalityLabModel.maximum, 6){
            {
                this.setScale(0.75);
            }
        }){
            {
                this.setOffset(AbstractFractionsCanvas.STAGE_SIZE.getWidth() / 2.0 - this.getFullWidth() - 50.0, AbstractFractionsCanvas.STAGE_SIZE.getHeight() - this.getFullBounds().getHeight());
            }
        };
        this.addChild(zeroOffsetNode3);
        final PhetPText phetPText = new PhetPText("=", new PhetFont(120)){
            {
                super(string, font);
                this.setOffset(zeroOffsetNode3.getMaxX() + 10.0, zeroOffsetNode3.getCenterY() - this.getFullHeight() / 2.0);
            }
        };
        this.addChild(phetPText);
        this.addChild(new ZeroOffsetNode((PNode)new ScaledUpFractionNode(equalityLabModel.numerator, equalityLabModel.denominator, equalityLabModel.scale){
            {
                this.setScale(0.75);
            }
        }){
            {
                super(pNode);
                this.setOffset(phetPText.getMaxX() + 10.0, phetPText.getCenterY() - this.getFullHeight() / 2.0);
            }
        });
    }

    private void addPrimaryRepresentationNodes(EqualityLabModel equalityLabModel, SettableProperty<Representation> settableProperty, SettableProperty<PieSet> settableProperty2, boolean bl) {
        this.addChild(new RepresentationNode(settableProperty, Representation.PIE, new PieSetNode(settableProperty2, this.rootNode, bl)));
        this.addChild(new RepresentationNode(settableProperty, Representation.HORIZONTAL_BAR, new PieSetNode(equalityLabModel.horizontalBarSet, this.rootNode, bl)));
        this.addChild(new RepresentationNode(settableProperty, Representation.VERTICAL_BAR, new PieSetNode(equalityLabModel.verticalBarSet, this.rootNode, bl)));
        Rectangle2D rectangle2D = equalityLabModel.getWaterGlassSetNodeBounds();
        this.addChild(new RepresentationNode(settableProperty, Representation.WATER_GLASSES, new WaterGlassSetNode(equalityLabModel.waterGlassSet, this.rootNode, Colors.CUP_COLOR, rectangle2D.getWidth(), rectangle2D.getHeight(), bl)));
    }

    private List<RadioButtonStripControlPanelNode.Element<Representation>> getIcons(SettableProperty<Representation> settableProperty, String string) {
        PNode pNode = new VerticalBarIcon(EqualityLabModel.scaledFactorySet.verticalSliceFactory, Colors.VERTICAL_SLICE_COLOR).getNode();
        pNode.scale(0.8);
        return Arrays.asList(new RadioButtonStripControlPanelNode.Element<Representation>(new PieIcon(settableProperty, Colors.CIRCLE_COLOR), Representation.PIE, UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.pieRadioButton, string)), new RadioButtonStripControlPanelNode.Element<Representation>(new HorizontalBarIcon(settableProperty, Colors.HORIZONTAL_SLICE_COLOR){
            {
                this.scale(0.8);
            }
        }, Representation.HORIZONTAL_BAR, UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.horizontalBarRadioButton, string)), new RadioButtonStripControlPanelNode.Element<Representation>(pNode, Representation.VERTICAL_BAR, UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.verticalBarRadioButton, string)), new RadioButtonStripControlPanelNode.Element<Representation>(new WaterGlassIcon(settableProperty, Colors.CUP_COLOR){
            {
                this.scale(0.8);
            }
        }, Representation.WATER_GLASSES, UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.waterGlassesRadioButton, string)));
    }
}

