/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.fractions.FractionsResources;
import edu.colorado.phet.fractions.fractionmatcher.model.GameResult;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import fj.F;
import fj.Ord;
import fj.data.List;
import java.awt.Color;
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StarSetNode
extends PNode {
    private static final List<BufferedImage> STAR_IMAGES = List.list(BufferedImageUtils.multiScaleToWidth(FractionsResources.Images.STAR_0, 30), BufferedImageUtils.multiScaleToWidth(FractionsResources.Images.STAR_1, 30), BufferedImageUtils.multiScaleToWidth(FractionsResources.Images.STAR_2, 30), BufferedImageUtils.multiScaleToWidth(FractionsResources.Images.STAR_3, 30), BufferedImageUtils.multiScaleToWidth(FractionsResources.Images.STAR_4, 30));

    private static BufferedImage getImage(int n) {
        return STAR_IMAGES.index(MathUtil.clamp(0, n, 4));
    }

    public StarSetNode(Property<List<GameResult>> property, final int n) {
        property.addObserver(new VoidFunction1<List<GameResult>>(){

            @Override
            public void apply(List<GameResult> list) {
                int n3;
                StarSetNode.this.removeAllChildren();
                int n2 = n3 = this.getBestScore(list);
                List<BufferedImage> list2 = List.list(StarSetNode.getImage(n2 - 0), StarSetNode.getImage(n2 - 4), StarSetNode.getImage(n2 - 8));
                if (list2 == null) {
                    throw new RuntimeException("No images found for score: " + n3);
                }
                StarSetNode.this.addChild(new ControlPanelNode((PNode)new HBox(new PImage(list2.index(0)), new PImage(list2.index(1)), new PImage(list2.index(2))), Color.white));
            }

            private int getBestScore(List<GameResult> list) {
                List<GameResult> list2 = list.filter(new F<GameResult, Boolean>(){

                    @Override
                    public Boolean f(GameResult gameResult) {
                        return gameResult.level == n;
                    }
                });
                return list2.length() == 0 ? 0 : list2.map(new F<GameResult, Integer>(){

                    @Override
                    public Integer f(GameResult gameResult) {
                        return gameResult.score;
                    }
                }).maximum(Ord.intOrd);
            }
        });
    }
}

