/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.view;

import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.fractions.common.view.AbstractFractionsCanvas;
import edu.colorado.phet.fractions.fractionmatcher.model.MatchingGameModel;
import edu.colorado.phet.fractions.fractionmatcher.model.Mode;
import edu.colorado.phet.fractions.fractionmatcher.model.MovableFraction;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import fj.F;
import fj.Ord;
import fj.data.List;
import java.awt.image.BufferedImage;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RewardNode
extends PNode {
    public RewardNode(final MatchingGameModel matchingGameModel) {
        matchingGameModel.mode.addObserver(new VoidFunction1<Mode>(){

            @Override
            public void apply(Mode mode) {
                boolean bl = mode == Mode.SHOWING_GAME_OVER_SCREEN && matchingGameModel.state.get().info.score == 12;
                RewardNode.this.removeAllChildren();
                if (bl) {
                    ContentNode contentNode = new ContentNode(matchingGameModel);
                    RewardNode.this.addChild(contentNode);
                    contentNode.init();
                }
            }
        });
    }

    private static double maxHeight(List<BufferedImage> list) {
        List<PNode> list2 = list.map(new F<BufferedImage, PNode>(){

            @Override
            public PNode f(BufferedImage bufferedImage) {
                return new PImage(bufferedImage);
            }
        });
        return list2.map(new F<PNode, Double>(){

            @Override
            public Double f(PNode pNode) {
                return pNode.getFullBounds().getHeight();
            }
        }).maximum(Ord.doubleOrd);
    }

    private static class ContentNode
    extends PNode {
        private final MatchingGameModel model;

        public ContentNode(MatchingGameModel matchingGameModel) {
            this.model = matchingGameModel;
        }

        public void init() {
            List<BufferedImage> list = this.model.state.get().fractions.map(new F<MovableFraction, BufferedImage>(){

                @Override
                public BufferedImage f(MovableFraction movableFraction) {
                    return BufferedImageUtils.toBufferedImage(movableFraction.node.toImage());
                }
            });
            double d = RewardNode.maxHeight(list);
            double d2 = 0.0;
            double d3 = AbstractFractionsCanvas.STAGE_SIZE.width;
            double d4 = (d3 - d2) / (double)list.length();
            double d5 = 0.0;
            double d6 = d4;
            Random random = new Random();
            for (int i = 0; i < 20; ++i) {
                for (BufferedImage bufferedImage : list) {
                    PImage pImage = new PImage(bufferedImage);
                    pImage.setOffset(d2, -d - pImage.getFullBounds().getHeight() / 2.0 + d5);
                    this.addChild(pImage);
                    double d7 = AbstractFractionsCanvas.STAGE_SIZE.getHeight();
                    pImage.animateToPositionScaleRotation(d2, d7 + d7 / 16.0 + d7 / 4.0 * (random.nextDouble() - 0.5) * 2.0, random.nextDouble() + 0.5, 2.0 * (random.nextDouble() - 0.5) * Math.PI, 5000 + random.nextInt(5000));
                    pImage.setTransparency(0.0f);
                    pImage.animateToTransparency(1.0f, 2000L);
                    d2 += d4;
                }
                d2 = 0.0;
                d5 -= d6;
            }
        }
    }
}

