/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.view;

import edu.colorado.phet.fractions.common.math.Fraction;
import edu.colorado.phet.fractions.common.util.DefaultP2;
import edu.colorado.phet.fractions.fractionmatcher.model.Pattern;
import edu.colorado.phet.fractions.fractionmatcher.view.PatternType;
import fj.F;
import fj.P2;
import fj.data.List;
import java.awt.Shape;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilledPattern {
    public final List<P2<Shape, Boolean>> shapes;
    public final Shape outline;
    public final PatternType type;

    public static FilledPattern sequentialFill(Pattern pattern, final int n) {
        return new FilledPattern(pattern.shapes.zipIndex().map(new F<P2<Shape, Integer>, P2<Shape, Boolean>>(){

            @Override
            public P2<Shape, Boolean> f(P2<Shape, Integer> p2) {
                return DefaultP2.p2(p2._1(), p2._2() < n);
            }
        }), pattern.outline, pattern.type);
    }

    public static FilledPattern randomFill(Pattern pattern, int n, final long l) {
        int n2 = pattern.shapes.length();
        final List<Integer> list = List.iterableList(new ArrayList<Integer>(List.range(0, n2).toCollection()){
            {
                super(collection);
                Collections.shuffle(this, new Random(l));
            }
        }).take(n);
        return new FilledPattern(pattern.shapes.zipIndex().map(new F<P2<Shape, Integer>, P2<Shape, Boolean>>(){

            @Override
            public P2<Shape, Boolean> f(P2<Shape, Integer> p2) {
                return DefaultP2.p2(p2._1(), list.toCollection().contains(p2._2()));
            }
        }), pattern.outline, pattern.type);
    }

    public Fraction toFraction() {
        return new Fraction(this.shapes.filter(new F<P2<Shape, Boolean>, Boolean>(){

            @Override
            public Boolean f(P2<Shape, Boolean> p2) {
                return p2._2();
            }
        }).length(), this.shapes.length());
    }

    public Integer getDenominator() {
        return this.shapes.length();
    }

    @ConstructorProperties(value={"shapes", "outline", "type"})
    public FilledPattern(List<P2<Shape, Boolean>> list, Shape shape, PatternType patternType) {
        this.shapes = list;
        this.outline = shape;
        this.type = patternType;
    }

    public List<P2<Shape, Boolean>> getShapes() {
        return this.shapes;
    }

    public Shape getOutline() {
        return this.outline;
    }

    public PatternType getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FilledPattern)) {
            return false;
        }
        FilledPattern filledPattern = (FilledPattern)object;
        if (!filledPattern.canEqual(this)) {
            return false;
        }
        if (this.getShapes() == null ? filledPattern.getShapes() != null : !this.getShapes().equals(filledPattern.getShapes())) {
            return false;
        }
        if (this.getOutline() == null ? filledPattern.getOutline() != null : !this.getOutline().equals(filledPattern.getOutline())) {
            return false;
        }
        return !(this.getType() == null ? filledPattern.getType() != null : !this.getType().equals((Object)filledPattern.getType()));
    }

    public boolean canEqual(Object object) {
        return object instanceof FilledPattern;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + (this.getShapes() == null ? 0 : this.getShapes().hashCode());
        n = n * 31 + (this.getOutline() == null ? 0 : this.getOutline().hashCode());
        n = n * 31 + (this.getType() == null ? 0 : this.getType().hashCode());
        return n;
    }

    public String toString() {
        return "FilledPattern(shapes=" + this.getShapes() + ", outline=" + this.getOutline() + ", type=" + (Object)((Object)this.getType()) + ")";
    }
}

