/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.model;

import edu.colorado.phet.fractions.fractionmatcher.model.MatchingGameState;
import edu.colorado.phet.fractions.fractionmatcher.model.MovableFraction;
import java.beans.ConstructorProperties;

public class UpdateArgs {
    public final MovableFraction fraction;
    public final double dt;
    public final MatchingGameState state;

    public UpdateArgs withFraction(MovableFraction movableFraction) {
        return new UpdateArgs(movableFraction, this.dt, this.state);
    }

    @ConstructorProperties(value={"fraction", "dt", "state"})
    public UpdateArgs(MovableFraction movableFraction, double d, MatchingGameState matchingGameState) {
        this.fraction = movableFraction;
        this.dt = d;
        this.state = matchingGameState;
    }

    public MovableFraction getFraction() {
        return this.fraction;
    }

    public double getDt() {
        return this.dt;
    }

    public MatchingGameState getState() {
        return this.state;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof UpdateArgs)) {
            return false;
        }
        UpdateArgs updateArgs = (UpdateArgs)object;
        if (!updateArgs.canEqual(this)) {
            return false;
        }
        if (this.getFraction() == null ? updateArgs.getFraction() != null : !this.getFraction().equals(updateArgs.getFraction())) {
            return false;
        }
        if (Double.compare(this.getDt(), updateArgs.getDt()) != 0) {
            return false;
        }
        return !(this.getState() == null ? updateArgs.getState() != null : !this.getState().equals(updateArgs.getState()));
    }

    public boolean canEqual(Object object) {
        return object instanceof UpdateArgs;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.getDt());
        n = n * 31 + (this.getFraction() == null ? 0 : this.getFraction().hashCode());
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (this.getState() == null ? 0 : this.getState().hashCode());
        return n;
    }

    public String toString() {
        return "UpdateArgs(fraction=" + this.getFraction() + ", dt=" + this.getDt() + ", state=" + this.getState() + ")";
    }
}

