/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.RichPNode;
import edu.colorado.phet.fractions.FractionsResources;
import edu.colorado.phet.fractions.common.util.Cache;
import edu.colorado.phet.fractions.fractionmatcher.model.MixedNumberNode;
import edu.colorado.phet.fractions.fractionmatcher.model.MovableFraction;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import fj.F;
import java.awt.image.BufferedImage;
import java.beans.ConstructorProperties;

public class Scale {
    private static final BufferedImage scale = BufferedImageUtils.multiScale(FractionsResources.Images.SCALE, 0.5);
    public final Vector2D position;
    private static final Cache<MovableFraction, Double> HEIGHT = new Cache<MovableFraction, Double>(100, new F<MovableFraction, Double>(){

        @Override
        public Double f(MovableFraction movableFraction) {
            return movableFraction.getNodeWithCorrectScale().getFullBounds().getHeight();
        }
    });

    public PNode toNode() {
        return new PImage(scale){
            {
                this.setOffset(Scale.this.position.getX(), Scale.this.position.getY());
            }
        };
    }

    Vector2D getCenter() {
        return this.position.plus(scale.getWidth() / 2, scale.getHeight() / 2);
    }

    private Vector2D getAttachmentPoint() {
        return this.getCenter().plus(0.0, -25.0);
    }

    public Vector2D getAttachmentPoint(MovableFraction movableFraction) {
        return Scale.getAttachmentPoint(this, movableFraction);
    }

    private static Vector2D getAttachmentPoint(Scale scale, MovableFraction movableFraction) {
        int n = movableFraction.getNode() instanceof RichPNode && movableFraction.getNode().getChild(0) instanceof MixedNumberNode ? 9 : 0;
        return scale.getAttachmentPoint().plus(0.0, -HEIGHT.f(movableFraction).doubleValue() / 2.0 + (double)n);
    }

    @ConstructorProperties(value={"position"})
    public Scale(Vector2D vector2D) {
        this.position = vector2D;
    }

    public Vector2D getPosition() {
        return this.position;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Scale)) {
            return false;
        }
        Scale scale = (Scale)object;
        if (!scale.canEqual(this)) {
            return false;
        }
        return !(this.getPosition() == null ? scale.getPosition() != null : !this.getPosition().equals(scale.getPosition()));
    }

    public boolean canEqual(Object object) {
        return object instanceof Scale;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + (this.getPosition() == null ? 0 : this.getPosition().hashCode());
        return n;
    }

    public String toString() {
        return "Scale(position=" + this.getPosition() + ")";
    }
}

