/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.fractions.fractionmatcher.model.Cell;
import edu.colorado.phet.fractions.fractionmatcher.model.MovableFraction;
import edu.colorado.phet.fractions.fractionmatcher.model.UpdateArgs;
import fj.F;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Motions {
    public static final F<UpdateArgs, MovableFraction> MOVE_TO_LEFT_SCALE = new F<UpdateArgs, MovableFraction>(){

        @Override
        public MovableFraction f(UpdateArgs updateArgs) {
            return updateArgs.fraction.stepTowards(updateArgs.state.leftScale.getAttachmentPoint(updateArgs.fraction), updateArgs.dt);
        }
    };
    public static final F<UpdateArgs, MovableFraction> MOVE_TO_RIGHT_SCALE = new F<UpdateArgs, MovableFraction>(){

        @Override
        public MovableFraction f(UpdateArgs updateArgs) {
            return updateArgs.fraction.stepTowards(updateArgs.state.rightScale.getAttachmentPoint(updateArgs.fraction), updateArgs.dt);
        }
    };
    public static final F<UpdateArgs, MovableFraction> WAIT = new F<UpdateArgs, MovableFraction>(){

        @Override
        public MovableFraction f(UpdateArgs updateArgs) {
            return updateArgs.fraction;
        }
    };

    public static F<UpdateArgs, MovableFraction> composite(final F<UpdateArgs, MovableFraction> f, final F<UpdateArgs, MovableFraction> f2) {
        return new F<UpdateArgs, MovableFraction>(){

            @Override
            public MovableFraction f(UpdateArgs updateArgs) {
                updateArgs = updateArgs.withFraction((MovableFraction)f.f(updateArgs));
                updateArgs = updateArgs.withFraction((MovableFraction)f2.f(updateArgs));
                return updateArgs.fraction;
            }
        };
    }

    public static F<UpdateArgs, MovableFraction> scale(final double d) {
        return new F<UpdateArgs, MovableFraction>(){

            @Override
            public MovableFraction f(UpdateArgs updateArgs) {
                return updateArgs.fraction.scaleTowards(d);
            }
        };
    }

    public static F<UpdateArgs, MovableFraction> moveToPosition(final Vector2D vector2D) {
        return new F<UpdateArgs, MovableFraction>(){

            @Override
            public MovableFraction f(UpdateArgs updateArgs) {
                return updateArgs.fraction.stepTowards(vector2D, updateArgs.dt);
            }
        };
    }

    public static F<UpdateArgs, MovableFraction> moveToCell(final Cell cell) {
        return new F<UpdateArgs, MovableFraction>(){

            @Override
            public MovableFraction f(UpdateArgs updateArgs) {
                return updateArgs.fraction.stepTowards(cell.getPosition(), updateArgs.dt);
            }
        };
    }
}

