/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableRectangle2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.functionaljava.FJUtils;
import edu.colorado.phet.fractions.fractionmatcher.model.AbstractLevelFactory;
import edu.colorado.phet.fractions.fractionmatcher.model.Answer;
import edu.colorado.phet.fractions.fractionmatcher.model.Cell;
import edu.colorado.phet.fractions.fractionmatcher.model.GameInfo;
import edu.colorado.phet.fractions.fractionmatcher.model.GameResult;
import edu.colorado.phet.fractions.fractionmatcher.model.Mode;
import edu.colorado.phet.fractions.fractionmatcher.model.Motions;
import edu.colorado.phet.fractions.fractionmatcher.model.MovableFraction;
import edu.colorado.phet.fractions.fractionmatcher.model.Scale;
import edu.colorado.phet.fractions.fractionmatcher.model.UpdateArgs;
import fj.F;
import fj.data.List;
import fj.data.Option;
import java.beans.ConstructorProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingGameState {
    public final List<MovableFraction> fractions;
    public final List<Cell> startCells;
    public final List<Cell> scoreCells;
    public final int scored;
    public final Scale leftScale = new Scale(new Vector2D(220.0, 320.0));
    public final Scale rightScale = new Scale(new Vector2D(570.0, 320.0));
    public final long leftScaleDropTime;
    public final long rightScaleDropTime;
    public final GameInfo info;
    public final double barGraphAnimationTime;
    public final List<GameResult> gameResults;
    public final Option<Answer> lastWrongAnswer;

    public static MatchingGameState initialState(AbstractLevelFactory abstractLevelFactory) {
        return MatchingGameState.newLevel(1, List.<GameResult>nil(), abstractLevelFactory).withMode(Mode.CHOOSING_SETTINGS);
    }

    public static MatchingGameState newLevel(int n, List<GameResult> list, AbstractLevelFactory abstractLevelFactory) {
        List<Cell> list2 = MatchingGameState.createCells(100, 427, 130, 120, 6, 2, 0.0, 0.0);
        List<Cell> list3 = MatchingGameState.createCells(10, 12, 155, 90, 6, 1, 10.0, 0.0);
        return new MatchingGameState(abstractLevelFactory.createLevel(n, list2), list2, list3, 0, 0L, 0L, new GameInfo(n, false, 0, Mode.USER_IS_MOVING_OBJECTS_TO_THE_SCALES, 0, 0L, 0L, true), 0.0, list, Option.<Answer>none());
    }

    private static List<Cell> createCells(final int n, final int n2, final int n3, final int n4, int n5, final int n6, final double d, final double d2) {
        return List.range(0, n5).bind(new F<Integer, List<Cell>>(){

            @Override
            public List<Cell> f(final Integer n5) {
                return List.range(0, n6).map(new F<Integer, Cell>(){

                    @Override
                    public Cell f(Integer n) {
                        return new Cell(new ImmutableRectangle2D((double)n + (double)n5.intValue() * ((double)n3 + d), (double)n2 + (double)n.intValue() * ((double)n4 + d2), n3, n4));
                    }
                });
            }
        });
    }

    public Mode getMode() {
        return this.info.mode;
    }

    public int getChecks() {
        return this.info.checks;
    }

    public MatchingGameState withFractions(List<MovableFraction> list) {
        return new MatchingGameState(list, this.startCells, this.scoreCells, this.scored, this.leftScaleDropTime, this.rightScaleDropTime, this.info, this.barGraphAnimationTime, this.gameResults, this.lastWrongAnswer);
    }

    MatchingGameState withScored(int n) {
        return new MatchingGameState(this.fractions, this.startCells, this.scoreCells, n, this.leftScaleDropTime, this.rightScaleDropTime, this.info, this.barGraphAnimationTime, this.gameResults, this.lastWrongAnswer);
    }

    public MatchingGameState withAudio(boolean bl) {
        return new MatchingGameState(this.fractions, this.startCells, this.scoreCells, this.scored, this.leftScaleDropTime, this.rightScaleDropTime, this.info.withAudio(bl), this.barGraphAnimationTime, this.gameResults, this.lastWrongAnswer);
    }

    public MatchingGameState withLeftScaleDropTime(long l) {
        return new MatchingGameState(this.fractions, this.startCells, this.scoreCells, this.scored, l, this.rightScaleDropTime, this.info, this.barGraphAnimationTime, this.gameResults, this.lastWrongAnswer);
    }

    public MatchingGameState withRightScaleDropTime(long l) {
        return new MatchingGameState(this.fractions, this.startCells, this.scoreCells, this.scored, this.leftScaleDropTime, l, this.info, this.barGraphAnimationTime, this.gameResults, this.lastWrongAnswer);
    }

    public MatchingGameState withMode(Mode mode) {
        return this.withInfo(this.info.withMode(mode)).withBarGraphAnimationTime(0.0);
    }

    public MatchingGameState withInfo(GameInfo gameInfo) {
        return new MatchingGameState(this.fractions, this.startCells, this.scoreCells, this.scored, this.leftScaleDropTime, this.rightScaleDropTime, gameInfo, this.barGraphAnimationTime, this.gameResults, this.lastWrongAnswer);
    }

    MatchingGameState withBarGraphAnimationTime(double d) {
        return new MatchingGameState(this.fractions, this.startCells, this.scoreCells, this.scored, this.leftScaleDropTime, this.rightScaleDropTime, this.info, d, this.gameResults, this.lastWrongAnswer);
    }

    MatchingGameState withGameResults(List<GameResult> list) {
        return new MatchingGameState(this.fractions, this.startCells, this.scoreCells, this.scored, this.leftScaleDropTime, this.rightScaleDropTime, this.info, this.barGraphAnimationTime, list, this.lastWrongAnswer);
    }

    public MatchingGameState withLastWrongAnswer(Option<Answer> option) {
        return new MatchingGameState(this.fractions, this.startCells, this.scoreCells, this.scored, this.leftScaleDropTime, this.rightScaleDropTime, this.info, this.barGraphAnimationTime, this.gameResults, option);
    }

    public MatchingGameState stepInTime(final double d) {
        return this.withFractions(this.fractions.map(new F<MovableFraction, MovableFraction>(){

            @Override
            public MovableFraction f(MovableFraction movableFraction) {
                return movableFraction.stepInTime(new UpdateArgs(movableFraction, d, MatchingGameState.this));
            }
        })).withInfo(this.info.withTime(this.info.time + (long)(d * 1000.0))).withBarGraphAnimationTime(this.info.mode == Mode.SHOWING_CORRECT_ANSWER_AFTER_INCORRECT_GUESS || this.info.mode == Mode.SHOWING_WHY_ANSWER_WRONG || this.info.mode == Mode.USER_CHECKED_CORRECT_ANSWER ? this.barGraphAnimationTime + d : this.barGraphAnimationTime);
    }

    public Option<MovableFraction> getScaleFraction(final Scale scale) {
        return this.fractions.find(new F<MovableFraction, Boolean>(){

            @Override
            public Boolean f(MovableFraction movableFraction) {
                return movableFraction.position.equals(scale.getAttachmentPoint(movableFraction));
            }
        });
    }

    double getScaleValue(Scale scale) {
        return this.getScaleFraction(scale).isSome() ? this.getScaleFraction(scale).some().getFractionValue() : 0.0;
    }

    public double getLeftScaleValue() {
        return this.getScaleValue(this.leftScale);
    }

    public double getRightScaleValue() {
        return this.getScaleValue(this.rightScale);
    }

    public MatchingGameState jettisonFraction(Scale scale) {
        Option<MovableFraction> option = this.getScaleFraction(scale);
        return option.option(this, new F<MovableFraction, MatchingGameState>(){

            @Override
            public MatchingGameState f(final MovableFraction movableFraction) {
                return MatchingGameState.this.withFractions(MatchingGameState.this.fractions.map(new F<MovableFraction, MovableFraction>(){

                    @Override
                    public MovableFraction f(MovableFraction movableFraction2) {
                        return movableFraction.equals(movableFraction2) ? movableFraction2.withMotion(Motions.moveToCell(MatchingGameState.this.getClosestFreeStartCell(movableFraction2))) : movableFraction2;
                    }
                }));
            }
        });
    }

    boolean isOnScale(Scale scale, final MovableFraction movableFraction) {
        return this.getScaleFraction(scale).option(false, new F<MovableFraction, Boolean>(){

            @Override
            public Boolean f(MovableFraction movableFraction2) {
                return movableFraction2.equals(movableFraction);
            }
        });
    }

    boolean isOnScale(MovableFraction movableFraction) {
        return this.isOnScale(this.leftScale, movableFraction) || this.isOnScale(this.rightScale, movableFraction);
    }

    public MatchingGameState animateMatchToScoreCell() {
        List<MovableFraction> list = this.fractions.map(new F<MovableFraction, MovableFraction>(){

            @Override
            public MovableFraction f(MovableFraction movableFraction) {
                double d = movableFraction.withScale(0.5).getNodeWithCorrectScale().getFullBounds().getWidth();
                Cell cell = MatchingGameState.this.scoreCells.index(MatchingGameState.this.scored);
                F<UpdateArgs, MovableFraction> f = Motions.moveToPosition(new Vector2D(cell.rectangle.getCenter().getX() - d / 2.0 - 15.0, cell.rectangle.getCenter().getY()));
                F<UpdateArgs, MovableFraction> f2 = Motions.moveToPosition(new Vector2D(cell.rectangle.getCenter().getX() + d / 2.0 + 15.0, cell.rectangle.getCenter().getY()));
                F<UpdateArgs, MovableFraction> f3 = Motions.composite(f, Motions.scale(0.5));
                F<UpdateArgs, MovableFraction> f4 = Motions.composite(f2, Motions.scale(0.5));
                boolean bl = MatchingGameState.this.isOnScale(MatchingGameState.this.leftScale, movableFraction);
                boolean bl2 = MatchingGameState.this.isOnScale(MatchingGameState.this.rightScale, movableFraction);
                MovableFraction movableFraction2 = movableFraction.withMotion(f3).withScored(true);
                MovableFraction movableFraction3 = movableFraction.withMotion(f4).withScored(true);
                return bl ? movableFraction2 : (bl2 ? movableFraction3 : movableFraction);
            }
        });
        return this.withFractions(list).withScored(this.scored + 1);
    }

    boolean getLastDroppedScaleRight() {
        return this.rightScaleDropTime > this.leftScaleDropTime;
    }

    public Cell getClosestFreeStartCell(final MovableFraction movableFraction) {
        return this.startCells.filter(new F<Cell, Boolean>(){

            @Override
            public Boolean f(Cell cell) {
                return MatchingGameState.this.isFree(cell);
            }
        }).sort(FJUtils.ord(new F<Cell, Double>(){

            @Override
            public Double f(Cell cell) {
                return cell.getPosition().distance(movableFraction.position);
            }
        })).head();
    }

    private boolean isFree(Cell cell) {
        return !this.isTaken(cell);
    }

    public boolean allStartCellsFree() {
        return this.startCells.filter(new F<Cell, Boolean>(){

            @Override
            public Boolean f(Cell cell) {
                return MatchingGameState.this.isFree(cell);
            }
        }).length() == this.startCells.length();
    }

    private boolean isTaken(final Cell cell) {
        return this.fractions.exists(new F<MovableFraction, Boolean>(){

            @Override
            public Boolean f(MovableFraction movableFraction) {
                return !movableFraction.dragging && movableFraction.position.equals(cell.getPosition());
            }
        });
    }

    public MatchingGameState animateToCorrectAnswer() {
        final double d = this.getLastDroppedScaleRight() ? this.getLeftScaleValue() : this.getRightScaleValue();
        final MovableFraction movableFraction = this.fractions.find(new F<MovableFraction, Boolean>(){

            @Override
            public Boolean f(MovableFraction movableFraction) {
                return Math.abs(movableFraction.getFractionValue() - d) < 1.0E-8 && !MatchingGameState.this.isOnScale(movableFraction) && !movableFraction.scored;
            }
        }).some();
        return this.withFractions(this.fractions.map(new F<MovableFraction, MovableFraction>(){

            @Override
            public MovableFraction f(MovableFraction movableFraction2) {
                boolean bl;
                boolean bl2 = MatchingGameState.this.isOnScale(MatchingGameState.this.leftScale, movableFraction2) && !MatchingGameState.this.getLastDroppedScaleRight();
                boolean bl3 = bl = MatchingGameState.this.isOnScale(MatchingGameState.this.rightScale, movableFraction2) && MatchingGameState.this.getLastDroppedScaleRight();
                if (bl2 || bl) {
                    return movableFraction2.withMotion(Motions.moveToCell(MatchingGameState.this.getClosestFreeStartCell(movableFraction2)));
                }
                if (movableFraction2 == movableFraction) {
                    return movableFraction2.withMotion(MatchingGameState.this.getLastDroppedScaleRight() ? Motions.MOVE_TO_RIGHT_SCALE : Motions.MOVE_TO_LEFT_SCALE);
                }
                return movableFraction2;
            }
        }));
    }

    public MatchingGameState newGame(int n, int n2) {
        return this.withMode(Mode.CHOOSING_SETTINGS).withGameResults(this.gameResults.snoc(new GameResult(n, n2)));
    }

    public MatchingGameState withChecks(int n) {
        return this.withInfo(this.info.withChecks(n));
    }

    public MatchingGameState withScore(int n) {
        return this.withInfo(this.info.withScore(n));
    }

    public MatchingGameState withTimerVisible(Boolean bl) {
        return this.withInfo(this.info.withTimerVisible(bl));
    }

    public MatchingGameState recordWrongAnswer() {
        return this.withLastWrongAnswer(this.getCurrentAnswer());
    }

    private Option<Answer> getCurrentAnswer() {
        assert (this.getScaleFraction(this.leftScale).isSome() && this.getScaleFraction(this.rightScale).isSome());
        return Option.some(new Answer(this.getScaleFraction((Scale)this.leftScale).some().id, this.getScaleFraction((Scale)this.rightScale).some().id));
    }

    public boolean changedFromWrongAnswer() {
        return !this.lastWrongAnswer.equals(this.getCurrentAnswer());
    }

    @ConstructorProperties(value={"fractions", "startCells", "scoreCells", "scored", "leftScaleDropTime", "rightScaleDropTime", "info", "barGraphAnimationTime", "gameResults", "lastWrongAnswer"})
    public MatchingGameState(List<MovableFraction> list, List<Cell> list2, List<Cell> list3, int n, long l, long l2, GameInfo gameInfo, double d, List<GameResult> list4, Option<Answer> option) {
        this.fractions = list;
        this.startCells = list2;
        this.scoreCells = list3;
        this.scored = n;
        this.leftScaleDropTime = l;
        this.rightScaleDropTime = l2;
        this.info = gameInfo;
        this.barGraphAnimationTime = d;
        this.gameResults = list4;
        this.lastWrongAnswer = option;
    }

    public List<MovableFraction> getFractions() {
        return this.fractions;
    }

    public List<Cell> getStartCells() {
        return this.startCells;
    }

    public List<Cell> getScoreCells() {
        return this.scoreCells;
    }

    public int getScored() {
        return this.scored;
    }

    public Scale getLeftScale() {
        return this.leftScale;
    }

    public Scale getRightScale() {
        return this.rightScale;
    }

    public long getLeftScaleDropTime() {
        return this.leftScaleDropTime;
    }

    public long getRightScaleDropTime() {
        return this.rightScaleDropTime;
    }

    public GameInfo getInfo() {
        return this.info;
    }

    public double getBarGraphAnimationTime() {
        return this.barGraphAnimationTime;
    }

    public List<GameResult> getGameResults() {
        return this.gameResults;
    }

    public Option<Answer> getLastWrongAnswer() {
        return this.lastWrongAnswer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MatchingGameState)) {
            return false;
        }
        MatchingGameState matchingGameState = (MatchingGameState)object;
        if (!matchingGameState.canEqual(this)) {
            return false;
        }
        if (this.getFractions() == null ? matchingGameState.getFractions() != null : !this.getFractions().equals(matchingGameState.getFractions())) {
            return false;
        }
        if (this.getStartCells() == null ? matchingGameState.getStartCells() != null : !this.getStartCells().equals(matchingGameState.getStartCells())) {
            return false;
        }
        if (this.getScoreCells() == null ? matchingGameState.getScoreCells() != null : !this.getScoreCells().equals(matchingGameState.getScoreCells())) {
            return false;
        }
        if (this.getScored() != matchingGameState.getScored()) {
            return false;
        }
        if (this.getLeftScale() == null ? matchingGameState.getLeftScale() != null : !this.getLeftScale().equals(matchingGameState.getLeftScale())) {
            return false;
        }
        if (this.getRightScale() == null ? matchingGameState.getRightScale() != null : !this.getRightScale().equals(matchingGameState.getRightScale())) {
            return false;
        }
        if (this.getLeftScaleDropTime() != matchingGameState.getLeftScaleDropTime()) {
            return false;
        }
        if (this.getRightScaleDropTime() != matchingGameState.getRightScaleDropTime()) {
            return false;
        }
        if (this.getInfo() == null ? matchingGameState.getInfo() != null : !this.getInfo().equals(matchingGameState.getInfo())) {
            return false;
        }
        if (Double.compare(this.getBarGraphAnimationTime(), matchingGameState.getBarGraphAnimationTime()) != 0) {
            return false;
        }
        if (this.getGameResults() == null ? matchingGameState.getGameResults() != null : !this.getGameResults().equals(matchingGameState.getGameResults())) {
            return false;
        }
        return !(this.getLastWrongAnswer() == null ? matchingGameState.getLastWrongAnswer() != null : !this.getLastWrongAnswer().equals(matchingGameState.getLastWrongAnswer()));
    }

    public boolean canEqual(Object object) {
        return object instanceof MatchingGameState;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.getBarGraphAnimationTime());
        n = n * 31 + (this.getFractions() == null ? 0 : this.getFractions().hashCode());
        n = n * 31 + (this.getStartCells() == null ? 0 : this.getStartCells().hashCode());
        n = n * 31 + (this.getScoreCells() == null ? 0 : this.getScoreCells().hashCode());
        n = n * 31 + this.getScored();
        n = n * 31 + (this.getLeftScale() == null ? 0 : this.getLeftScale().hashCode());
        n = n * 31 + (this.getRightScale() == null ? 0 : this.getRightScale().hashCode());
        n = n * 31 + (int)(this.getLeftScaleDropTime() >>> 32 ^ this.getLeftScaleDropTime());
        n = n * 31 + (int)(this.getRightScaleDropTime() >>> 32 ^ this.getRightScaleDropTime());
        n = n * 31 + (this.getInfo() == null ? 0 : this.getInfo().hashCode());
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (this.getGameResults() == null ? 0 : this.getGameResults().hashCode());
        n = n * 31 + (this.getLastWrongAnswer() == null ? 0 : this.getLastWrongAnswer().hashCode());
        return n;
    }

    public String toString() {
        return "MatchingGameState(fractions=" + this.getFractions() + ", startCells=" + this.getStartCells() + ", scoreCells=" + this.getScoreCells() + ", scored=" + this.getScored() + ", leftScale=" + this.getLeftScale() + ", rightScale=" + this.getRightScale() + ", leftScaleDropTime=" + this.getLeftScaleDropTime() + ", rightScaleDropTime=" + this.getRightScaleDropTime() + ", info=" + this.getInfo() + ", barGraphAnimationTime=" + this.getBarGraphAnimationTime() + ", gameResults=" + this.getGameResults() + ", lastWrongAnswer=" + this.getLastWrongAnswer() + ")";
    }
}

