/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.model;

import edu.colorado.phet.common.games.GameAudioPlayer;
import edu.colorado.phet.common.phetcommon.model.clock.Clock;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.CompositeBooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.CompositeProperty;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.CompositeDoubleProperty;
import edu.colorado.phet.common.phetcommon.model.property.integerproperty.CompositeIntegerProperty;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.fractions.fractionmatcher.model.AbstractLevelFactory;
import edu.colorado.phet.fractions.fractionmatcher.model.GameResult;
import edu.colorado.phet.fractions.fractionmatcher.model.MatchingGameState;
import edu.colorado.phet.fractions.fractionmatcher.model.Mode;
import edu.colorado.phet.fractions.fractionmatcher.model.MovableFraction;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import fj.F;
import fj.data.List;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingGameModel {
    private final GameAudioPlayer gameAudioPlayer = new GameAudioPlayer(true);
    public final AbstractLevelFactory levelFactory;
    public final Property<MatchingGameState> state;
    public final ObservableProperty<Double> leftScaleValue;
    public final ObservableProperty<Double> rightScaleValue;
    public final ObservableProperty<Integer> checks;
    public final ObservableProperty<Integer> scored;
    public final ObservableProperty<Integer> level;
    public final ObservableProperty<Integer> score;
    public final ObservableProperty<Boolean> timerVisible;
    public final ObservableProperty<Double> barGraphAnimationTime;
    public final ObservableProperty<Mode> mode;
    public final ObservableProperty<Boolean> revealClues;
    public final ObservableProperty<Long> timeInSec;
    public final ObservableProperty<List<Integer>> fractionIDs;
    public final Property<List<GameResult>> gameResults;
    public final CompositeBooleanProperty choosingSettings;
    private final HashMap<Integer, MatchingGameState> savedGames = new HashMap();
    private final ArrayList<VoidFunction0> refreshListeners = new ArrayList();
    private final ArrayList<VoidFunction1<Integer>> levelStartedListeners = new ArrayList();
    public final Clock clock;

    private ObservableProperty<Double> doubleProperty(final F<MatchingGameState, Double> f) {
        return new CompositeDoubleProperty(new Function0<Double>(){

            @Override
            public Double apply() {
                return (Double)f.f(MatchingGameModel.this.state.get());
            }
        }, (ObservableProperty<?>[])new ObservableProperty[]{this.state});
    }

    private ObservableProperty<Integer> intProperty(final F<MatchingGameState, Integer> f) {
        return new CompositeIntegerProperty(new Function0<Integer>(){

            @Override
            public Integer apply() {
                return (Integer)f.f(MatchingGameModel.this.state.get());
            }
        }, (ObservableProperty<?>[])new ObservableProperty[]{this.state});
    }

    private ObservableProperty<Boolean> booleanProperty(final F<MatchingGameState, Boolean> f) {
        return new CompositeBooleanProperty(new Function0<Boolean>(){

            @Override
            public Boolean apply() {
                return (Boolean)f.f(MatchingGameModel.this.state.get());
            }
        }, (ObservableProperty<?>[])new ObservableProperty[]{this.state});
    }

    public MatchingGameModel(Clock clock, AbstractLevelFactory abstractLevelFactory) {
        this.clock = clock;
        clock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(final ClockEvent clockEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MatchingGameModel.this.state.set(MatchingGameModel.this.state.get().stepInTime(clockEvent.getSimulationTimeChange()));
                    }
                });
            }
        });
        this.levelFactory = abstractLevelFactory;
        this.state = new Property<MatchingGameState>(MatchingGameState.initialState(abstractLevelFactory)){
            {
                this.addObserver(new ChangeObserver<MatchingGameState>(){

                    @Override
                    public void update(MatchingGameState matchingGameState, MatchingGameState matchingGameState2) {
                        if (matchingGameState.info.audio && matchingGameState2.info.mode == Mode.USER_IS_MOVING_OBJECTS_TO_THE_SCALES && matchingGameState.info.mode == Mode.USER_CHECKED_CORRECT_ANSWER) {
                            MatchingGameModel.this.gameAudioPlayer.correctAnswer();
                        }
                        if (matchingGameState.info.audio && matchingGameState2.info.mode == Mode.USER_IS_MOVING_OBJECTS_TO_THE_SCALES && matchingGameState.info.mode == Mode.SHOWING_WHY_ANSWER_WRONG) {
                            MatchingGameModel.this.gameAudioPlayer.wrongAnswer();
                        }
                    }
                });
                this.addObserver(new ChangeObserver<MatchingGameState>(){

                    @Override
                    public void update(MatchingGameState matchingGameState, MatchingGameState matchingGameState2) {
                        if (matchingGameState2.getMode() != Mode.CHOOSING_SETTINGS && matchingGameState.getMode() == Mode.CHOOSING_SETTINGS) {
                            MatchingGameModel.this.savedGames.put(matchingGameState.info.getLevel(), matchingGameState2);
                        }
                    }
                });
            }
        };
        this.mode = new CompositeProperty<Mode>(new Function0<Mode>(){

            @Override
            public Mode apply() {
                return MatchingGameModel.this.state.get().getMode();
            }
        }, this.state);
        this.revealClues = new CompositeBooleanProperty(new Function0<Boolean>(){

            @Override
            public Boolean apply() {
                return MatchingGameModel.this.state.get().getMode() == Mode.SHOWING_WHY_ANSWER_WRONG || MatchingGameModel.this.state.get().getMode() == Mode.USER_CHECKED_CORRECT_ANSWER || MatchingGameModel.this.state.get().getMode() == Mode.SHOWING_CORRECT_ANSWER_AFTER_INCORRECT_GUESS;
            }
        }, (ObservableProperty<?>[])new ObservableProperty[]{this.state});
        this.timeInSec = new CompositeProperty<Long>(new Function0<Long>(){

            @Override
            public Long apply() {
                return MatchingGameModel.this.state.get().info.time / 1000L;
            }
        }, this.state);
        this.fractionIDs = new CompositeProperty<List<Integer>>(new Function0<List<Integer>>(){

            @Override
            public List<Integer> apply() {
                return MatchingGameModel.this.state.get().fractions.map(new F<MovableFraction, Integer>(){

                    @Override
                    public Integer f(MovableFraction movableFraction) {
                        return movableFraction.id.value;
                    }
                });
            }
        }, this.state);
        this.gameResults = new Property<List<GameResult>>(this.state.get().gameResults){
            {
                MatchingGameModel.this.state.addObserver(new VoidFunction1<MatchingGameState>(){

                    @Override
                    public void apply(MatchingGameState matchingGameState) {
                        this.set(MatchingGameModel.this.state.get().gameResults);
                    }
                });
            }
        };
        this.choosingSettings = new CompositeBooleanProperty(new Function0<Boolean>(){

            @Override
            public Boolean apply() {
                return MatchingGameModel.this.state.get().info.mode == Mode.CHOOSING_SETTINGS;
            }
        }, (ObservableProperty<?>[])new ObservableProperty[]{this.state});
        this.leftScaleValue = this.doubleProperty(new F<MatchingGameState, Double>(){

            @Override
            public Double f(MatchingGameState matchingGameState) {
                return matchingGameState.getLeftScaleValue();
            }
        });
        this.rightScaleValue = this.doubleProperty(new F<MatchingGameState, Double>(){

            @Override
            public Double f(MatchingGameState matchingGameState) {
                return matchingGameState.getRightScaleValue();
            }
        });
        this.checks = this.intProperty(new F<MatchingGameState, Integer>(){

            @Override
            public Integer f(MatchingGameState matchingGameState) {
                return matchingGameState.getChecks();
            }
        });
        this.scored = this.intProperty(new F<MatchingGameState, Integer>(){

            @Override
            public Integer f(MatchingGameState matchingGameState) {
                return matchingGameState.scored;
            }
        });
        this.level = this.intProperty(new F<MatchingGameState, Integer>(){

            @Override
            public Integer f(MatchingGameState matchingGameState) {
                return matchingGameState.info.level;
            }
        });
        this.score = this.intProperty(new F<MatchingGameState, Integer>(){

            @Override
            public Integer f(MatchingGameState matchingGameState) {
                return matchingGameState.info.score;
            }
        });
        this.timerVisible = this.booleanProperty(new F<MatchingGameState, Boolean>(){

            @Override
            public Boolean f(MatchingGameState matchingGameState) {
                return matchingGameState.info.timerVisible;
            }
        });
        this.barGraphAnimationTime = this.doubleProperty(new F<MatchingGameState, Double>(){

            @Override
            public Double f(MatchingGameState matchingGameState) {
                return matchingGameState.barGraphAnimationTime;
            }
        });
        this.leftScaleValue.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                SimSharingManager.sendModelMessage(FractionsIntroSimSharing.ModelComponents.leftScaleValue, FractionsIntroSimSharing.ModelComponentTypes.scale, FractionsIntroSimSharing.ModelActions.changed, ParameterSet.parameterSet((IParameterKey)ParameterKeys.value, d));
            }
        });
        this.rightScaleValue.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                SimSharingManager.sendModelMessage(FractionsIntroSimSharing.ModelComponents.rightScaleValue, FractionsIntroSimSharing.ModelComponentTypes.scale, FractionsIntroSimSharing.ModelActions.changed, ParameterSet.parameterSet((IParameterKey)ParameterKeys.value, d));
            }
        });
    }

    public void refresh() {
        for (VoidFunction0 voidFunction0 : this.refreshListeners) {
            voidFunction0.apply();
        }
    }

    public void finishRefresh() {
        this.startNewGame(this.level.get(), this.state.get().getInfo().audio, this.state.get().getInfo().timerVisible);
    }

    private void startNewGame(int n, boolean bl, boolean bl2) {
        MatchingGameState matchingGameState = MatchingGameState.newLevel(n, this.state.get().gameResults, this.levelFactory).withMode(Mode.USER_IS_MOVING_OBJECTS_TO_THE_SCALES).withAudio(bl).withTimerVisible(bl2);
        this.state.set(matchingGameState);
    }

    public void resumeOrStartGame(int n, boolean bl, boolean bl2) {
        for (VoidFunction1<Integer> voidFunction1 : this.levelStartedListeners) {
            voidFunction1.apply(n);
        }
        if (this.savedGames.containsKey(n)) {
            MatchingGameState matchingGameState = this.savedGames.get(n).withAudio(bl).withTimerVisible(bl2).withGameResults(this.state.get().gameResults);
            this.state.set(matchingGameState);
        } else {
            this.startNewGame(n, bl, bl2);
        }
    }

    public void addRefreshListener(VoidFunction0 voidFunction0) {
        this.refreshListeners.add(voidFunction0);
    }

    public void addLevelStartedListener(VoidFunction1<Integer> voidFunction1) {
        this.levelStartedListeners.add(voidFunction1);
    }

    public void startNewGame() {
        MatchingGameState matchingGameState = this.state.get();
        this.finishRefresh();
        MatchingGameState matchingGameState2 = this.state.get().newGame(matchingGameState.info.level, matchingGameState.info.score);
        this.state.set(matchingGameState2);
    }

    public void showLevelSelectionScreen() {
        this.state.set(this.state.get().withMode(Mode.CHOOSING_SETTINGS));
    }

    public Mode getMode() {
        return this.state.get().getMode();
    }

    public void levelSelectionButtonPressed() {
        if (this.isGameOver()) {
            this.startNewGame();
        } else {
            this.showLevelSelectionScreen();
        }
    }

    private boolean isGameOver() {
        return this.getMode() == Mode.SHOWING_GAME_OVER_SCREEN;
    }
}

