/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.fractionmatcher.model;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.functionaljava.FJUtils;
import edu.colorado.phet.common.piccolophet.RichPNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.fractions.common.math.Fraction;
import edu.colorado.phet.fractions.common.view.Colors;
import edu.colorado.phet.fractions.fractionmatcher.model.Cell;
import edu.colorado.phet.fractions.fractionmatcher.model.FillType;
import edu.colorado.phet.fractions.fractionmatcher.model.GraphicalRepresentation;
import edu.colorado.phet.fractions.fractionmatcher.model.MixedNumberNode;
import edu.colorado.phet.fractions.fractionmatcher.model.Motions;
import edu.colorado.phet.fractions.fractionmatcher.model.MovableFraction;
import edu.colorado.phet.fractions.fractionmatcher.model.MovableFractionID;
import edu.colorado.phet.fractions.fractionmatcher.model.Pattern;
import edu.colorado.phet.fractions.fractionmatcher.model.ShapeType;
import edu.colorado.phet.fractions.fractionmatcher.view.FilledPattern;
import edu.colorado.phet.fractions.fractionmatcher.view.PatternNode;
import edu.colorado.phet.fractions.fractionsintro.intro.model.containerset.Container;
import edu.colorado.phet.fractions.fractionsintro.intro.model.containerset.ContainerSet;
import edu.colorado.phet.fractions.fractionsintro.intro.view.FractionNode;
import edu.umd.cs.piccolo.PNode;
import fj.data.List;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLevelFactory {
    private final Random RANDOM = new Random();

    ArrayList<GraphicalRepresentation> filter(ArrayList<GraphicalRepresentation> arrayList, Fraction fraction) {
        ArrayList<GraphicalRepresentation> arrayList2 = new ArrayList<GraphicalRepresentation>();
        for (GraphicalRepresentation graphicalRepresentation : arrayList) {
            if (!this.matches(graphicalRepresentation.shapeType, fraction)) continue;
            arrayList2.add(graphicalRepresentation);
        }
        return arrayList2;
    }

    boolean matches(ShapeType shapeType, Fraction fraction) {
        int n = fraction.denominator;
        return shapeType == ShapeType.PIES ? true : (shapeType == ShapeType.HORIZONTAL_BARS ? n < 9 : (shapeType == ShapeType.VERTICAL_BARS ? n < 9 : (shapeType == ShapeType.GRID ? n == 4 || n == 9 : (shapeType == ShapeType.FLOWER ? n == 6 : (shapeType == ShapeType.PYRAMID ? n == 1 || n == 4 || n == 9 : (shapeType == ShapeType.PLUSSES ? n == 6 : (shapeType == ShapeType.POLYGON ? n >= 3 : (shapeType == ShapeType.TETRIS ? n == 4 : (shapeType == ShapeType.LETTER_L_SHAPES ? n % 2 == 0 : (shapeType == ShapeType.INTERLEAVED_L_SHAPES ? n == 2 || n == 4 : (shapeType == ShapeType.RING_OF_HEXAGONS ? n == 7 : (shapeType == ShapeType.NINJA_STAR ? n == 8 : false))))))))))));
    }

    List<GraphicalRepresentation> generateAll(List<ShapeType> list, List<FillType> list2) {
        ArrayList<GraphicalRepresentation> arrayList = new ArrayList<GraphicalRepresentation>();
        for (ShapeType shapeType : list) {
            for (Color color : List.list(Colors.LIGHT_BLUE, Colors.LIGHT_GREEN, Colors.LIGHT_RED)) {
                for (FillType fillType : list2) {
                    arrayList.add(new GraphicalRepresentation(shapeType, color, fillType));
                }
            }
        }
        return List.iterableList(arrayList);
    }

    PNode createGraphic(Fraction fraction, GraphicalRepresentation graphicalRepresentation) {
        int n;
        if (fraction.numerator <= fraction.denominator) {
            PatternNode patternNode = this.createSingle(fraction, graphicalRepresentation.shapeType, graphicalRepresentation.fillType == FillType.RANDOM, graphicalRepresentation.color);
            HBox hBox = new HBox(patternNode);
            this.scaleBoxNode(hBox, 80.0);
            return hBox;
        }
        int n2 = (int)Math.ceil(fraction.toDouble());
        if (n2 >= 3) {
            throw new RuntimeException("3+ not handled yet");
        }
        if (graphicalRepresentation.fillType == FillType.SEQUENTIAL || graphicalRepresentation.fillType == FillType.MIXED) {
            PatternNode patternNode = this.createSingle(new Fraction(fraction.denominator, fraction.denominator), graphicalRepresentation.shapeType, false, graphicalRepresentation.color);
            PatternNode patternNode2 = this.createSingle(new Fraction(fraction.numerator - fraction.denominator, fraction.denominator), graphicalRepresentation.shapeType, graphicalRepresentation.fillType == FillType.MIXED, graphicalRepresentation.color);
            return this.addToBox(patternNode, patternNode2);
        }
        ContainerSet containerSet = new ContainerSet(fraction.denominator, List.list(new Container(fraction.denominator, List.<Integer>nil()), new Container(fraction.denominator, List.<Integer>nil())));
        for (n = 0; n < fraction.numerator; ++n) {
            containerSet = containerSet.toggle(containerSet.getRandomEmptyCell(this.RANDOM));
        }
        n = containerSet.containers.index(0).getFilledCells().length();
        Fraction fraction2 = new Fraction(n, fraction.denominator);
        int n3 = containerSet.containers.index(1).getFilledCells().length();
        Fraction fraction3 = new Fraction(n3, fraction.denominator);
        double d = fraction2.toDouble() + fraction3.toDouble();
        double d2 = d - fraction.toDouble();
        if (d2 > 1.0E-6) {
            System.out.println("fraction = " + fraction + ", numInFirst = " + n + ", numInSecond = " + n3 + ", difference = " + d2);
            throw new RuntimeException("values didn't add up");
        }
        PatternNode patternNode = this.createSingle(fraction2, graphicalRepresentation.shapeType, true, graphicalRepresentation.color);
        PatternNode patternNode3 = this.createSingle(fraction3, graphicalRepresentation.shapeType, true, graphicalRepresentation.color);
        return this.addToBox(patternNode, patternNode3);
    }

    PNode addToBox(PatternNode patternNode, PatternNode patternNode2) {
        double d = patternNode.getFullBounds().getWidth();
        Function.LinearFunction linearFunction = new Function.LinearFunction(80.0, 160.0, 10.0, 20.0);
        HBox hBox = new HBox(linearFunction.evaluate(d), patternNode, patternNode2);
        this.scaleBoxNode(hBox, 110.0);
        return hBox;
    }

    void scaleBoxNode(HBox hBox, double d) {
        double d2 = hBox.getFullBounds().getWidth();
        double d3 = d / d2;
        double d4 = hBox.getFullBounds().getHeight();
        double d5 = d / d4;
        double d6 = Math.min(d3, d5);
        hBox.scale(d6);
        double d7 = hBox.getFullHeight();
        if (d7 > 90.0) {
            hBox.scale(1.0 / d6);
            hBox.scale(d6 * 0.8);
            d6 *= 0.8;
        }
        if (d6 < 1.0) {
            for (Object e : hBox.getChildrenReference()) {
                if (!(e instanceof PatternNode)) continue;
                PatternNode patternNode = (PatternNode)e;
                patternNode.scaleStrokes(1.0 / d3);
            }
        }
    }

    PatternNode createSingle(Fraction fraction, ShapeType shapeType, boolean bl, Color color) {
        Pattern pattern;
        boolean bl2;
        boolean bl3 = bl2 = fraction.numerator <= fraction.denominator && fraction.numerator >= 0 && fraction.denominator > 0;
        if (!bl2) {
            throw new RuntimeException("Failed assertion, fraction = " + fraction);
        }
        int n = fraction.denominator;
        Pattern pattern2 = shapeType == ShapeType.PIES ? Pattern.pie(n) : (shapeType == ShapeType.VERTICAL_BARS ? Pattern.verticalBars(n) : (shapeType == ShapeType.HORIZONTAL_BARS ? Pattern.horizontalBars(n) : (shapeType == ShapeType.FLOWER && n == 6 ? Pattern.sixFlower() : (shapeType == ShapeType.TETRIS && n == 4 ? Pattern.tetrisPiece(50) : (shapeType == ShapeType.PLUSSES && n == 6 ? Pattern.plusSigns(n) : (shapeType == ShapeType.POLYGON ? Pattern.polygon(80.0, n) : (shapeType == ShapeType.PYRAMID && n == 1 ? Pattern.pyramidSingle() : (shapeType == ShapeType.PYRAMID && n == 4 ? Pattern.pyramidFour() : (shapeType == ShapeType.PYRAMID && n == 9 ? Pattern.pyramidNine() : (shapeType == ShapeType.GRID && n == 4 ? Pattern.grid(2) : (shapeType == ShapeType.GRID && n == 9 ? Pattern.grid(3) : (shapeType == ShapeType.LETTER_L_SHAPES && n % 2 == 0 ? Pattern.letterLShapedDiagonal(14, n / 2) : (shapeType == ShapeType.INTERLEAVED_L_SHAPES && n == 2 ? Pattern.interleavedLShape(80, 1, 1) : (shapeType == ShapeType.INTERLEAVED_L_SHAPES && n == 4 ? Pattern.interleavedLShape(80, 2, 1) : (shapeType == ShapeType.RING_OF_HEXAGONS && n == 7 ? Pattern.ringOfHexagons() : (pattern = shapeType == ShapeType.NINJA_STAR && n == 8 ? Pattern.ninjaStar() : null))))))))))))))));
        if (pattern == null) {
            throw new RuntimeException("Null pattern for rep = " + (Object)((Object)shapeType) + ", f = " + fraction);
        }
        return new PatternNode(bl ? FilledPattern.randomFill(pattern, fraction.numerator, 123L) : FilledPattern.sequentialFill(pattern, fraction.numerator), color);
    }

    List<MovableFraction> generateLevel(int n, List<Cell> list, List<Integer> list2, List<Fraction> list3, boolean bl) {
        List<GraphicalRepresentation> list4;
        ArrayList<Cell> arrayList = new ArrayList<Cell>(FJUtils.shuffle(list).toCollection());
        List<ShapeType> list5 = List.list(ShapeType.PIES, ShapeType.HORIZONTAL_BARS, ShapeType.VERTICAL_BARS);
        List<ShapeType> list6 = List.list(ShapeType.PLUSSES, ShapeType.GRID, ShapeType.PYRAMID, ShapeType.POLYGON, ShapeType.TETRIS, ShapeType.FLOWER, ShapeType.LETTER_L_SHAPES, ShapeType.INTERLEAVED_L_SHAPES, ShapeType.RING_OF_HEXAGONS, ShapeType.NINJA_STAR).append(list5);
        List<GraphicalRepresentation> list7 = n == 1 ? this.generateAll(list5, List.list(FillType.SEQUENTIAL)) : (n == 2 || n == 3 ? this.generateAll(list6, List.list(FillType.SEQUENTIAL)) : (n == 4 ? this.generateAll(list6, List.list(FillType.SEQUENTIAL)) : (n == 5 ? this.generateAll(list6, List.list(FillType.SEQUENTIAL, FillType.MIXED)) : (n == 6 ? this.generateAll(list6, List.list(FillType.MIXED, FillType.RANDOM)) : (n == 7 ? this.generateAll(list6, List.list(FillType.MIXED, FillType.RANDOM)) : (list4 = n == 8 ? this.generateAll(list6, List.list(FillType.MIXED, FillType.RANDOM)) : null))))));
        if (list4 == null) {
            throw new RuntimeException("No representations found for level: " + n);
        }
        ArrayList<GraphicalRepresentation> arrayList2 = new ArrayList<GraphicalRepresentation>(list4.toCollection());
        ArrayList<MovableFraction> arrayList3 = new ArrayList<MovableFraction>();
        for (int i = 0; i < list3.length(); ++i) {
            PNode pNode;
            boolean bl2;
            Fraction fraction = list3.index(i % 6);
            ArrayList<GraphicalRepresentation> arrayList4 = this.filter(arrayList2, fraction);
            Collections.shuffle(arrayList4);
            GraphicalRepresentation graphicalRepresentation = null;
            boolean bl3 = bl2 = i < 3 || this.RANDOM.nextBoolean();
            if (bl2) {
                int n2 = list2.index(this.RANDOM.nextInt(list2.length()));
                pNode = bl && fraction.numerator > fraction.denominator ? new MixedNumberNode(fraction, n2, 0.3, 2.4) : new FractionNode(new Fraction(fraction.numerator * n2, fraction.denominator * n2), 0.3);
            } else {
                if (arrayList4.size() == 0) {
                    arrayList4 = this.filter(new ArrayList<GraphicalRepresentation>(list4.toCollection()), fraction);
                }
                graphicalRepresentation = arrayList4.get(0);
                pNode = this.createGraphic(fraction, graphicalRepresentation);
                arrayList2.remove(graphicalRepresentation);
                arrayList4.remove(graphicalRepresentation);
            }
            Object object = arrayList.remove(0);
            Object object2 = new MovableFractionID();
            Object object3 = bl2 ? "numeric" : graphicalRepresentation.toString();
            arrayList3.add(new MovableFraction((MovableFractionID)object2, ((Cell)object).getPosition(), fraction.numerator, fraction.denominator, false, (Cell)object, 1.0, new RichPNode(pNode), Motions.WAIT, false, new IUserComponent((MovableFractionID)object2, fraction, (String)object3){
                final /* synthetic */ MovableFractionID val$id;
                final /* synthetic */ Fraction val$fraction;
                final /* synthetic */ String val$representationString;
                {
                    this.val$id = movableFractionID;
                    this.val$fraction = fraction;
                    this.val$representationString = string;
                }

                public String toString() {
                    return "fraction.id=" + this.val$id + ".value=" + this.val$fraction.numerator + "/" + this.val$fraction.denominator + ".representation=" + this.val$representationString;
                }
            }, bl2 ? Color.black : graphicalRepresentation.color, (String)object3));
            if (arrayList4.size() == 0) {
                arrayList4 = this.filter(new ArrayList<GraphicalRepresentation>(list4.toCollection()), fraction);
            }
            object = arrayList4.get(0);
            pNode = this.createGraphic(fraction, (GraphicalRepresentation)object);
            arrayList2.remove(object);
            object2 = arrayList.remove(0);
            object3 = new MovableFractionID();
            arrayList3.add(new MovableFraction((MovableFractionID)object3, ((Cell)object2).getPosition(), fraction.numerator, fraction.denominator, false, (Cell)object2, 1.0, new RichPNode(pNode), Motions.WAIT, false, new IUserComponent((MovableFractionID)object3, fraction, (GraphicalRepresentation)object){
                final /* synthetic */ MovableFractionID val$id;
                final /* synthetic */ Fraction val$fraction;
                final /* synthetic */ GraphicalRepresentation val$alternateRepresentation;
                {
                    this.val$id = movableFractionID;
                    this.val$fraction = fraction;
                    this.val$alternateRepresentation = graphicalRepresentation;
                }

                public String toString() {
                    return "fraction.id=" + this.val$id + ".value=" + this.val$fraction.numerator + "/" + this.val$fraction.denominator + ".representation=" + this.val$alternateRepresentation.toString();
                }
            }, ((GraphicalRepresentation)object).color, ((GraphicalRepresentation)object).toString()));
        }
        return List.iterableList(arrayList3);
    }

    public abstract List<MovableFraction> createLevel(int var1, List<Cell> var2);
}

