/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.common.math;

import edu.colorado.phet.fractions.buildafraction.model.MixedFraction;
import fj.F;
import fj.F2;
import fj.data.List;
import fj.function.Integers;
import java.beans.ConstructorProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fraction {
    public final int numerator;
    public final int denominator;
    public static final F<Fraction, Integer> _denominator = new F<Fraction, Integer>(){

        @Override
        public Integer f(Fraction fraction) {
            return fraction.denominator;
        }
    };
    public static final F<Fraction, Integer> _numerator = new F<Fraction, Integer>(){

        @Override
        public Integer f(Fraction fraction) {
            return fraction.numerator;
        }
    };
    public static final F<Fraction, Fraction> _reduce = new F<Fraction, Fraction>(){

        @Override
        public Fraction f(Fraction fraction) {
            return fraction.reduce();
        }
    };
    public static final F2<Fraction, Integer, Fraction> _times = new F2<Fraction, Integer, Fraction>(){

        @Override
        public Fraction f(Fraction fraction, Integer n) {
            return fraction.times(n);
        }
    };

    public boolean greaterThanOne() {
        return this.numerator > this.denominator;
    }

    public double toDouble() {
        return (double)this.numerator / (double)this.denominator;
    }

    public String toString() {
        return this.numerator + "/" + this.denominator;
    }

    public boolean approxEquals(Fraction fraction) {
        return Math.abs(this.toDouble() - fraction.toDouble()) < 1.0E-6;
    }

    public static Fraction fraction(int n, int n2) {
        return new Fraction(n, n2);
    }

    public Fraction reduce() {
        int n = this.gcd(this.numerator, this.denominator);
        return new Fraction(this.numerator / n, this.denominator / n);
    }

    private int gcd(int n, int n2) {
        return n2 == 0 ? n : this.gcd(n2, n % n2);
    }

    public Fraction times(int n) {
        return new Fraction(this.numerator * n, this.denominator * n);
    }

    public static Fraction sum(List<Fraction> list) {
        final int n = list.foldLeft(new F2<Integer, Fraction, Integer>(){

            @Override
            public Integer f(Integer n, Fraction fraction) {
                return n * fraction.denominator;
            }
        }, Integer.valueOf(1));
        List<Integer> list2 = list.map(new F<Fraction, Integer>(){

            @Override
            public Integer f(Fraction fraction) {
                int n2 = n / fraction.denominator;
                return fraction.numerator * n2;
            }
        });
        Integer n2 = list2.foldLeft(Integers.add, Integer.valueOf(0));
        return Fraction.fraction(n2, n).reduce();
    }

    public Fraction plus(Fraction fraction) {
        return Fraction.sum(List.list(this, fraction));
    }

    public boolean lessThanOrEqualTo(Fraction fraction) {
        Fraction fraction2 = new Fraction(this.numerator * fraction.denominator, this.denominator * fraction.denominator);
        Fraction fraction3 = new Fraction(fraction.numerator * this.denominator, fraction.denominator * this.denominator);
        return fraction2.numerator <= fraction3.numerator;
    }

    public boolean valueEquals(Fraction fraction) {
        return fraction.reduce().equals(this.reduce());
    }

    public MixedFraction toMixedFraction() {
        Fraction fraction = this.reduce();
        int n = fraction.numerator / fraction.denominator;
        Fraction fraction2 = new Fraction(fraction.numerator - n * fraction.denominator, fraction.denominator);
        return new MixedFraction(n, fraction2.numerator, fraction2.denominator);
    }

    @ConstructorProperties(value={"numerator", "denominator"})
    public Fraction(int n, int n2) {
        this.numerator = n;
        this.denominator = n2;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Fraction)) {
            return false;
        }
        Fraction fraction = (Fraction)object;
        if (!fraction.canEqual(this)) {
            return false;
        }
        if (this.getNumerator() != fraction.getNumerator()) {
            return false;
        }
        return this.getDenominator() == fraction.getDenominator();
    }

    public boolean canEqual(Object object) {
        return object instanceof Fraction;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + this.getNumerator();
        n = n * 31 + this.getDenominator();
        return n;
    }
}

