/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view.shapes;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.functionaljava.FJUtils;
import edu.colorado.phet.common.piccolophet.RichPNode;
import edu.colorado.phet.common.piccolophet.activities.PActivityDelegateAdapter;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.fractions.buildafraction.model.BuildAFractionModel;
import edu.colorado.phet.fractions.buildafraction.model.MixedFraction;
import edu.colorado.phet.fractions.buildafraction.model.shapes.ShapeLevel;
import edu.colorado.phet.fractions.buildafraction.model.shapes.ShapeType;
import edu.colorado.phet.fractions.buildafraction.view.BuildAFractionCanvas;
import edu.colorado.phet.fractions.buildafraction.view.DisablePickingWhileAnimating;
import edu.colorado.phet.fractions.buildafraction.view.SceneContext;
import edu.colorado.phet.fractions.buildafraction.view.SceneNode;
import edu.colorado.phet.fractions.buildafraction.view.Stack;
import edu.colorado.phet.fractions.buildafraction.view.StackContext;
import edu.colorado.phet.fractions.buildafraction.view.shapes.BarPieceNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.CompositeDelegate;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ContainerContext;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ContainerNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ContainerShapeNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.MixedFractionNodeFactory;
import edu.colorado.phet.fractions.buildafraction.view.shapes.MoveAwayFromCollectionBoxes;
import edu.colorado.phet.fractions.buildafraction.view.shapes.NullDelegate;
import edu.colorado.phet.fractions.buildafraction.view.shapes.PiePieceNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.PieceContext;
import edu.colorado.phet.fractions.buildafraction.view.shapes.PieceIconNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.PieceNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ShapeCollectionBoxNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ShapeSceneCollectionBoxPair;
import edu.colorado.phet.fractions.buildafraction.view.shapes.SingleContainerNode;
import edu.colorado.phet.fractions.common.math.Fraction;
import edu.colorado.phet.fractions.common.view.AbstractFractionsCanvas;
import edu.colorado.phet.fractions.common.view.FNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.util.PBounds;
import fj.Effect;
import fj.Equal;
import fj.F;
import fj.Ord;
import fj.P2;
import fj.data.List;
import fj.data.Option;
import fj.function.Booleans;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeSceneNode
extends SceneNode<ShapeSceneCollectionBoxPair>
implements StackContext<PieceNode>,
ContainerContext,
PieceContext {
    private final RichPNode toolboxNode;
    private final F<PieceIconNode, Double> _minX = FNode._minX();
    private final F<ContainerNode, Double> _maxX = FNode._maxX();
    private final double distanceBetweenStacks;
    private final double layoutXOffset;
    private final ShapeLevel level;
    private final ArrayList<Vector2D> containerNodeToolboxLocations = new ArrayList();
    private static final Random random = new Random();
    private final BuildAFractionModel model;
    public int toolboxHeight;
    private boolean toolboxEnabled = true;

    public ShapeSceneNode(int n, BuildAFractionModel buildAFractionModel, SceneContext sceneContext, BooleanProperty booleanProperty, boolean bl, boolean bl2) {
        this(n, buildAFractionModel, sceneContext, booleanProperty, Option.some(ShapeSceneNode.getToolbarOffset(n, buildAFractionModel, sceneContext, booleanProperty, bl, bl2)), bl, bl2);
    }

    private static double getToolbarOffset(int n, BuildAFractionModel buildAFractionModel, SceneContext sceneContext, BooleanProperty booleanProperty, boolean bl, boolean bl2) {
        ShapeSceneNode shapeSceneNode = new ShapeSceneNode(n, buildAFractionModel, sceneContext, booleanProperty, Option.<Double>none(), bl, bl2);
        double d = shapeSceneNode.title.getFullBounds().getCenterX();
        double d2 = shapeSceneNode.toolboxNode.getFullBounds().getCenterX();
        double d3 = d - d2;
        double d4 = shapeSceneNode.toolboxNode.getFullBounds().getX();
        double d5 = d4 + d3;
        if (d5 < 10.0) {
            d3 = 10.0 - d4;
        }
        return d3;
    }

    private ShapeSceneNode(final int n, BuildAFractionModel buildAFractionModel, final SceneContext sceneContext, BooleanProperty booleanProperty, Option<Double> option, final boolean bl, boolean bl2) {
        super(n, booleanProperty, sceneContext, bl);
        Cloneable cloneable;
        int n2;
        this.model = buildAFractionModel;
        double d = 10.0;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                sceneContext.goToShapeLevel(n + 1);
            }
        };
        VoidFunction0 voidFunction0 = new VoidFunction0(){

            public void apply() {
                sceneContext.resampleShapeLevel(n);
            }
        };
        this.level = buildAFractionModel.getShapeLevel(n);
        this.distanceBetweenStacks = bl ? (this.level.shapeType == ShapeType.BAR ? 104.0 : 104.0) : (this.level.shapeType == ShapeType.BAR ? 117.0 : 106.0);
        ArrayList<ShapeSceneCollectionBoxPair> arrayList = new ArrayList<ShapeSceneCollectionBoxPair>();
        for (int i = 0; i < this.level.targets.length(); ++i) {
            MixedFraction mixedFraction = this.level.getTarget(i);
            PNode pNode = MixedFractionNodeFactory.toNode(mixedFraction);
            ShapeCollectionBoxNode object = new ShapeCollectionBoxNode(this, this.level.targets.maximum(FJUtils.ord(MixedFraction._toDouble)), buildAFractionModel.collectedMatch.or(this.level.matchExists));
            arrayList.add(new ShapeSceneCollectionBoxPair(object, new ZeroOffsetNode(pNode), mixedFraction));
        }
        this.initCollectionBoxes(d, arrayList, bl);
        this.init(n, buildAFractionModel, actionListener, voidFunction0, bl);
        if (bl2) {
            ContainerNode containerNode = new ContainerNode(this, this, this.level.hasValuesGreaterThanOne(), this.level.shapeType, this.level.getMaxNumberOfSingleContainers()){
                {
                    Vector2D vector2D = ShapeSceneNode.this.getContainerPosition();
                    this.setInitialState(vector2D.x, vector2D.y, ShapeSceneNode.this.getContainerScale());
                }
            };
            this.addChild(containerNode);
        }
        List<List<Integer>> list = this.level.pieces.group(Equal.intEqual);
        int n3 = list.length();
        this.layoutXOffset = (double)(6 - n3) * this.distanceBetweenStacks / 4.0 + (double)(this.level.shapeType == ShapeType.BAR ? 0 : 45) + (option.isSome() ? option.some() : 0.0);
        this.toolboxHeight = (this.level.shapeType == ShapeType.BAR ? 100 : 140) + 5;
        if (bl && this.level.shapeType == ShapeType.PIE) {
            this.toolboxHeight -= 25;
        }
        for (P2 p2 : list.zipIndex()) {
            PieceNode pieceNode;
            n2 = (Integer)p2._2();
            List list2 = (List)p2._1();
            Rectangle2D rectangle2D = null;
            cloneable = new ArrayList();
            for (P2 p22 : list2.zipIndex()) {
                int n4 = (Integer)p22._1();
                int n5 = p22._2();
                pieceNode = this.level.shapeType == ShapeType.PIE ? new PiePieceNode(n4, this, new PhetPPath(ContainerShapeNode.createPieSlice(n4), this.level.color, PieceNode.stroke, Color.black)) : new BarPieceNode(n4, this, new PhetPPath(ContainerShapeNode.createRect(n4), this.level.color, PieceNode.stroke, Color.black));
                pieceNode.setOffset(this.getLocation(n2, n5, pieceNode).toPoint2D());
                pieceNode.setInitialScale(PieceIconNode.toolboxScale(bl));
                this.addChild(pieceNode);
                rectangle2D = rectangle2D == null ? pieceNode.getFullBounds() : ((Rectangle2D)rectangle2D).createUnion(pieceNode.getFullBounds());
                ((ArrayList)cloneable).add(pieceNode);
            }
            List list3 = List.iterableList(cloneable);
            Stack<PieceNode> stack = new Stack<PieceNode>(list3, n2, this);
            for (P2 p23 : list3.zipIndex()) {
                pieceNode = (PieceNode)p23._1();
                Integer n6 = p23._2();
                pieceNode.setStack(stack);
                pieceNode.setPositionInStack(Option.some(n6));
            }
            stack.update();
            PieceIconNode pieceIconNode = new PieceIconNode((Integer)list2.head(), this.level.shapeType, bl);
            PieceNode pieceNode2 = (PieceNode)((ArrayList)cloneable).get(0);
            pieceIconNode.setOffset(this.level.shapeType == ShapeType.PIE ? new Point2D.Double(pieceNode2.getFullBounds().getMaxX() - pieceIconNode.getFullBounds().getWidth(), pieceNode2.getYOffset()) : new Point2D.Double(((PieceNode)((ArrayList)cloneable).get(0)).getOffset().getX() + 0.5, ((PieceNode)((ArrayList)cloneable).get(0)).getOffset().getY() + 0.5));
            if (this.level.shapeType == ShapeType.PIE && pieceNode2.pieceSize == 5) {
                pieceIconNode.translate(4.0, 0.0);
            }
            this.addChild(pieceIconNode);
            pieceIconNode.moveToBack();
        }
        final int n7 = list.length();
        int n8 = this.level.targets.length() - 1;
        for (n2 = 0; n2 < n8; ++n2) {
            final double d2 = this.getCardOffsetWithinStack(n8, n2);
            cloneable = new ContainerNode(this, this, this.level.hasValuesGreaterThanOne(), this.level.shapeType, this.level.getMaxNumberOfSingleContainers()){
                {
                    super(shapeSceneNode2, containerContext, bl3, shapeType, n);
                    int n3 = ((ShapeSceneNode)ShapeSceneNode.this).level.shapeType == ShapeType.PIE ? -1 : 1;
                    this.setInitialState(ShapeSceneNode.this.layoutXOffset + 10.0 + 20.0 + d2 * (double)n3 + (double)n7 * ShapeSceneNode.this.distanceBetweenStacks, AbstractFractionsCanvas.STAGE_SIZE.height - 10.0 - (double)ShapeSceneNode.this.toolboxHeight + 20.0 + d2, PieceIconNode.toolboxScale(bl));
                }
            };
            this.addChild((PNode)cloneable);
            this.containerNodeToolboxLocations.add(new Vector2D(((PNode)cloneable).getOffset()));
        }
        this.toolboxNode = new RichPNode(new PNode[0]){
            {
                double d = FNode.getChildren(ShapeSceneNode.this, PieceIconNode.class).map(ShapeSceneNode.this._minX).minimum(Ord.doubleOrd);
                double d2 = FNode.getChildren(ShapeSceneNode.this, ContainerNode.class).map(ShapeSceneNode.this._maxX).maximum(Ord.doubleOrd);
                double d3 = d2 - d;
                PhetPPath phetPPath = new PhetPPath(new RoundRectangle2D.Double(0.0, 0.0, d3 + 60.0, ShapeSceneNode.this.toolboxHeight, 30.0, 30.0), Color.white, BuildAFractionCanvas.CONTROL_PANEL_STROKE, Color.darkGray);
                this.addChild(phetPPath);
                this.setOffset(d - 30.0, AbstractFractionsCanvas.STAGE_SIZE.height - 10.0 - this.getFullHeight());
            }
        };
        this.addChild(this.toolboxNode);
        this.toolboxNode.moveToBack();
    }

    public boolean isMixedNumbers() {
        return this.model.isMixedNumbers();
    }

    private Vector2D getContainerPosition() {
        double d = this.level.shapeType == ShapeType.PIE ? 85.0 : 89.50500000000001;
        double d2 = this.fractionLab ? AbstractFractionsCanvas.STAGE_SIZE.height - (double)this.toolboxHeight - 30.0 - 50.0 : 0.0;
        double d3 = (double)(this.level.shapeType == ShapeType.PIE ? 200 : 250) + d2;
        return new Vector2D(this.fractionLab ? 485.0 : this.title.getCenterX() - d * this.getContainerScale(), d3);
    }

    @Override
    protected void reset() {
        for (ContainerNode object : this.getContainerNodes()) {
            object.undoAll();
            object.animateHome();
            object.selectedPieceSize.reset();
            object.resetNumberOfContainers();
        }
        for (ShapeSceneCollectionBoxPair shapeSceneCollectionBoxPair : this.getCollectionBoxPairs()) {
            shapeSceneCollectionBoxPair.collectionBoxNode.undo();
        }
        for (PieceNode pieceNode : this.getPieceNodes()) {
            pieceNode.animateToTopOfStack();
        }
        this.level.filledTargets.reset();
    }

    @Override
    public void setToolboxEnabled(boolean bl) {
        this.toolboxEnabled = bl;
        this.toolboxNode.setVisible(bl);
        this.toolboxNode.setPickable(bl);
        this.toolboxNode.setChildrenPickable(bl);
        for (PieceNode pNode : this.getPieceNodes()) {
            if (!pNode.isInStack()) continue;
            pNode.setVisible(bl);
            pNode.setPickable(bl);
            pNode.setChildrenPickable(bl);
        }
        for (ContainerNode containerNode : this.getContainerNodesInToolbox()) {
            containerNode.setVisible(bl);
            containerNode.setPickable(bl);
            containerNode.setChildrenPickable(bl);
        }
        for (PieceIconNode pieceIconNode : this.getPieceIconNodes()) {
            pieceIconNode.setVisible(bl);
            pieceIconNode.setPickable(bl);
            pieceIconNode.setChildrenPickable(bl);
        }
    }

    private List<PieceNode> getPieceNodes() {
        ArrayList<PieceNode> arrayList = new ArrayList<PieceNode>();
        for (Object e : this.getChildrenReference()) {
            if (!(e instanceof PieceNode)) continue;
            arrayList.add((PieceNode)e);
        }
        return List.iterableList(arrayList);
    }

    @Override
    public void endDrag(final ContainerNode containerNode) {
        List<Point2D> list;
        int n;
        boolean bl;
        containerNode.updateExpansionButtonsEnabled();
        List<ShapeSceneCollectionBoxPair> list2 = this.getCollectionBoxPairs().sort(FJUtils.ord(new F<ShapeSceneCollectionBoxPair, Double>(){

            @Override
            public Double f(ShapeSceneCollectionBoxPair shapeSceneCollectionBoxPair) {
                return shapeSceneCollectionBoxPair.collectionBoxNode.getGlobalFullBounds().getCenter2D().distance(containerNode.getGlobalFullBounds().getCenter2D());
            }
        }));
        boolean bl2 = false;
        boolean bl3 = containerNode.getGlobalFullBounds().intersects(this.toolboxNode.getGlobalFullBounds());
        ShapeSceneCollectionBoxPair shapeSceneCollectionBoxPair = list2.take(1).head();
        double d = shapeSceneCollectionBoxPair.getCollectionBoxNode().getGlobalFullBounds().getCenterY();
        double d2 = this.toolboxNode.getGlobalFullBounds().getCenterY();
        double d3 = containerNode.getGlobalFullBounds().getCenterY();
        double d4 = Math.abs(d - d3);
        double d5 = Math.abs(d2 - d3);
        boolean bl4 = d5 < d4;
        boolean bl5 = bl = bl3 && bl4;
        if (!bl) {
            for (ShapeSceneCollectionBoxPair object : list2.take(1)) {
                double d6;
                n = object.collectionBoxNode.getGlobalFullBounds().intersects(containerNode.getGlobalFullBounds()) ? 1 : 0;
                boolean bl6 = containerNode.getFractionValue().approxEquals(object.value.toFraction());
                boolean bl7 = object.getCollectionBoxNode().isCompleted();
                if (n != 0 && bl6 && !bl7) {
                    d6 = 0.5 * object.collectionBoxNode.scaleFactor;
                    containerNode.removeUndoButton();
                    containerNode.setInCollectionBox(true, object.value.denominator);
                    PBounds pBounds = object.collectionBoxNode.getFullBounds();
                    PBounds pBounds2 = containerNode.getFullBounds();
                    containerNode.animateToPositionScaleRotation(pBounds.getCenterX() - pBounds2.getWidth() / 2.0 * d6 / this.getContainerScale(), pBounds.getCenterY() - pBounds2.getHeight() / 2.0 * d6 / this.getContainerScale() + 20.0, d6, 0.0, 200L).setDelegate(new DisablePickingWhileAnimating(containerNode, false));
                    object.collectionBoxNode.setCompletedFraction(containerNode);
                    containerNode.setAllPickable(false);
                    bl2 = true;
                    break;
                }
                if (n == 0 || this.fractionLab) continue;
                if (this.getContainerNodesInPlayArea().exists(new F<ContainerNode, Boolean>(){

                    @Override
                    public Boolean f(ContainerNode containerNode) {
                        return containerNode.getOffset().distance(ShapeSceneNode.this.getContainerPosition().toPoint2D()) < 10.0;
                    }
                })) {
                    d6 = Math.PI * 2 * random.nextDouble();
                    this.animateToPosition(containerNode, this.getContainerPosition().plus(Vector2D.createPolar(150.0, d6)), new MoveAwayFromCollectionBoxes(this, containerNode));
                    continue;
                }
                this.animateToPosition(containerNode, this.getContainerPosition(), new MoveAwayFromCollectionBoxes(this, containerNode));
            }
        }
        if (bl2) {
            this.level.filledTargets.increment();
        }
        if (!bl2 && bl3 && containerNode.getFractionValue().numerator == 0) {
            containerNode.resetNumberOfContainers();
            containerNode.selectedPieceSize.reset();
            if (!containerNode.startedInToolbox() || this.fractionLab) {
                list = this.getContainerNodesThatStartedInToolbox().map(new F<ContainerNode, Point2D>(){

                    @Override
                    public Point2D f(ContainerNode containerNode) {
                        return new Point2D.Double(containerNode.initialX, containerNode.initialY);
                    }
                }).sort(FJUtils.ord(new F<Point2D, Double>(){

                    @Override
                    public Double f(Point2D point2D) {
                        return point2D.getX();
                    }
                }));
                System.out.println("list = " + list);
                Point2D n2 = this.level.shapeType == ShapeType.PIE ? list.last() : list.head();
                containerNode.animateToToolboxStack(n2, this.getContainerNodesThatStartedInToolbox().map(new F<ContainerNode, Double>(){

                    @Override
                    public Double f(ContainerNode containerNode) {
                        return containerNode.initialScale;
                    }
                }).minimum(Ord.doubleOrd));
            } else {
                containerNode.animateHome();
            }
        }
        if (!this.allCollectionBoxesFilled()) {
            list = this.getContainerNodesInToolbox();
            int n2 = this.getContainerNodesInPlayArea().length();
            n = list.length();
            if (n2 == 0 && n > 0) {
                this.animateToCenterScreen((ContainerNode)list.head(), new NullDelegate());
            }
        }
        if (this.allCollectionBoxesFilled()) {
            this.notifyAllCompleted();
            this.faceNodeDialog.setVisible(true);
            this.faceNodeDialog.animateToTransparency(1.0f, 200L);
            this.faceNodeDialog.setPickable(true);
            this.faceNodeDialog.setChildrenPickable(true);
            this.faceNodeDialog.moveToFront();
        }
        if (!this.allCollectionBoxesFilled() && bl2) {
            this.notifyOneCompleted();
        }
        this.syncModelFractions();
    }

    public void animateContainerNodeToAppropriateLocation(ContainerNode containerNode) {
        if (this.getContainerNodesInPlayArea().length() == 0) {
            this.animateToCenterScreen(containerNode, new NullDelegate());
        } else {
            containerNode.animateToShowSpinners();
            List<Vector2D> list = List.iterableList(this.containerNodeToolboxLocations).filter(new F<Vector2D, Boolean>(){

                @Override
                public Boolean f(final Vector2D vector2D) {
                    return !ShapeSceneNode.this.getContainerNodes().exists(new F<ContainerNode, Boolean>(){

                        @Override
                        public Boolean f(ContainerNode containerNode) {
                            return new Vector2D(containerNode.getOffset()).equals(vector2D);
                        }
                    });
                }
            });
            if (list.length() == 0) {
                this.animateToPosition(containerNode, this.getContainerPosition().plus(100.0, 100.0), new NullDelegate());
            } else {
                containerNode.animateToPositionScaleRotation(list.head().x, list.head().y, PieceIconNode.toolboxScale(this.fractionLab), 0.0, 200L).setDelegate(new DisablePickingWhileAnimating(containerNode, true));
                this.animateToPosition(containerNode, list.head(), new NullDelegate());
            }
        }
    }

    private List<ContainerNode> getContainerNodesThatStartedInToolbox() {
        return this.getContainerNodes().filter(new F<ContainerNode, Boolean>(){

            @Override
            public Boolean f(ContainerNode containerNode) {
                return containerNode.startedInToolbox();
            }
        });
    }

    private List<ContainerNode> getContainerNodesInToolbox() {
        return this.getContainerNodes().filter(new F<ContainerNode, Boolean>(){

            @Override
            public Boolean f(ContainerNode containerNode) {
                return containerNode.isInToolbox();
            }
        });
    }

    private List<PieceIconNode> getPieceIconNodes() {
        return FNode.getChildren(this, PieceIconNode.class);
    }

    private List<ContainerNode> getContainerNodesInPlayArea() {
        return this.getContainerNodes().filter(new F<ContainerNode, Boolean>(){

            @Override
            public Boolean f(ContainerNode containerNode) {
                return containerNode.isInPlayArea();
            }
        });
    }

    private void animateToCenterScreen(ContainerNode containerNode, PActivity.PActivityDelegate pActivityDelegate) {
        this.animateToPosition(containerNode, this.getContainerPosition(), pActivityDelegate);
    }

    private void animateToPosition(final ContainerNode containerNode, Vector2D vector2D, PActivity.PActivityDelegate pActivityDelegate) {
        containerNode.animateToPositionScaleRotation(vector2D.x, vector2D.y, this.getContainerScale(), 0.0, 200L).setDelegate(new CompositeDelegate(new DisablePickingWhileAnimating(containerNode, true), pActivityDelegate, new PActivityDelegateAdapter(){

            public void activityFinished(PActivity pActivity) {
                containerNode.updateExpansionButtonsEnabled();
            }
        }));
    }

    @Override
    public void endDrag(final PieceNode pieceNode) {
        boolean bl = false;
        List<SingleContainerNode> list = this.getContainerNodes().bind(ContainerNode._getSingleContainerNodes);
        List<SingleContainerNode> list2 = list.sort(FJUtils.ord(new F<SingleContainerNode, Double>(){

            @Override
            public Double f(SingleContainerNode singleContainerNode) {
                return singleContainerNode.getGlobalFullBounds().getCenter2D().distance(pieceNode.getGlobalFullBounds().getCenter2D());
            }
        }));
        for (SingleContainerNode singleContainerNode : list2) {
            if (!singleContainerNode.getGlobalFullBounds().intersects(pieceNode.getGlobalFullBounds()) || singleContainerNode.isInToolbox() || singleContainerNode.willOverflow(pieceNode) || singleContainerNode.parent.isInCollectionBox().booleanValue()) continue;
            this.dropInto(pieceNode, singleContainerNode);
            bl = true;
            break;
        }
        if (!bl) {
            pieceNode.animateToTopOfStack();
        }
    }

    @Override
    public Option<Double> getNextAngle(final PieceNode pieceNode) {
        List<SingleContainerNode> list = this.getContainerNodes().bind(ContainerNode._getSingleContainerNodes).filter(new F<SingleContainerNode, Boolean>(){

            @Override
            public Boolean f(SingleContainerNode singleContainerNode) {
                return !singleContainerNode.isInToolbox();
            }
        }).filter(new F<SingleContainerNode, Boolean>(){

            @Override
            public Boolean f(SingleContainerNode singleContainerNode) {
                return !singleContainerNode.willOverflow(pieceNode);
            }
        }).filter(new F<SingleContainerNode, Boolean>(){

            @Override
            public Boolean f(SingleContainerNode singleContainerNode) {
                return singleContainerNode.parent.isInCollectionBox() == false;
            }
        }).sort(FJUtils.ord(new F<SingleContainerNode, Double>(){

            @Override
            public Double f(SingleContainerNode singleContainerNode) {
                return singleContainerNode.getGlobalFullBounds().getCenter2D().distance(pieceNode.getGlobalFullBounds().getCenter2D());
            }
        }));
        if (list.isNotEmpty()) {
            return Option.some(list.head().getDropLocation((PieceNode)pieceNode, (ShapeType)this.level.shapeType).angle);
        }
        return Option.none();
    }

    @Override
    public double getContainerScale() {
        return this.isFractionLab() ? 0.69 : (this.isMixedNumbers() ? 0.69 : 1.0);
    }

    @Override
    public boolean isFractionLab() {
        return this.fractionLab;
    }

    @Override
    public void containerNodeAnimationToToolboxFinished(ContainerNode containerNode) {
        this.setToolboxEnabled(this.toolboxEnabled);
    }

    @Override
    public void startDrag(PieceNode pieceNode) {
        if (this.isFractionLab()) {
            PieceNode pieceNode2 = pieceNode.copy();
            this.addChild(pieceNode2);
            pieceNode2.setGlobalRotation(pieceNode.getGlobalRotation());
            pieceNode2.setGlobalScale(pieceNode.getGlobalScale());
            pieceNode2.setGlobalTranslation(pieceNode.getGlobalTranslation());
        }
        this.fireInteractionEvent();
    }

    private void dropInto(final PieceNode pieceNode, final SingleContainerNode singleContainerNode) {
        VoidFunction0 voidFunction0;
        PTransformActivity pTransformActivity;
        Object object;
        singleContainerNode.setPickable(false);
        singleContainerNode.setChildrenPickable(false);
        if (this.level.shapeType == ShapeType.PIE) {
            object = singleContainerNode.getDropLocation(pieceNode, this.level.shapeType);
            pTransformActivity = pieceNode.animateToPositionScaleRotation(((DropLocation)object).position.x, ((DropLocation)object).position.y, this.getContainerScale(), 0.0, 200L);
            voidFunction0 = new VoidFunction0((DropLocation)object){
                final /* synthetic */ DropLocation val$dropLocation;
                {
                    this.val$dropLocation = dropLocation;
                }

                public void apply() {
                    pieceNode.setPickable(false);
                    pieceNode.setChildrenPickable(false);
                    pieceNode.setOffset(this.val$dropLocation.position.x, this.val$dropLocation.position.y);
                    pieceNode.setScale(1.0);
                    pieceNode.setRotation(0.0);
                }
            };
            if (pieceNode instanceof PiePieceNode) {
                ((PiePieceNode)pieceNode).setPieceRotation(((DropLocation)object).angle);
            }
        } else {
            object = singleContainerNode.getGlobalTranslation();
            pieceNode.globalToLocal((Point2D)object);
            pieceNode.localToParent((Point2D)object);
            final DropLocation dropLocation = singleContainerNode.getDropLocation(pieceNode, this.level.shapeType);
            final Vector2D vector2D = dropLocation.position.plus((Point2D)object);
            pTransformActivity = pieceNode.animateToPositionScaleRotation(vector2D.x, vector2D.y, this.getContainerScale(), dropLocation.angle, 200L);
            voidFunction0 = new VoidFunction0(){

                public void apply() {
                    pieceNode.setPickable(false);
                    pieceNode.setChildrenPickable(false);
                    pieceNode.setOffset(vector2D.x, vector2D.y);
                    pieceNode.setScale(1.0);
                    pieceNode.setRotation(dropLocation.angle);
                }
            };
        }
        pieceNode.setPickable(false);
        pieceNode.setChildrenPickable(false);
        object = voidFunction0;
        pTransformActivity.setDelegate(new CompositeDelegate(new PActivityDelegateAdapter((VoidFunction0)object){
            final /* synthetic */ VoidFunction0 val$finalPostProcess;
            {
                this.val$finalPostProcess = voidFunction0;
            }

            public void activityFinished(PActivity pActivity) {
                singleContainerNode.setPickable(true);
                singleContainerNode.setChildrenPickable(true);
                pieceNode.terminateActivities();
                this.val$finalPostProcess.apply();
                singleContainerNode.addPiece(pieceNode);
                ShapeSceneNode.this.syncModelFractions();
            }
        }, new DisablePickingWhileAnimating(pieceNode, false)));
        singleContainerNode.addDropLocationToUndoList();
    }

    @Override
    public void syncModelFractions() {
        this.level.createdFractions.set(this.getUserCreatedFractions());
    }

    @Override
    public void containerAdded(ContainerNode containerNode) {
        this.moveContainerNodeAwayFromCollectionBoxes(containerNode);
    }

    @Override
    public void startDrag(ContainerNode containerNode) {
        if (this.isFractionLab() && containerNode.isInToolbox() && this.getContainerNodes().length() < 4) {
            ContainerNode containerNode2 = containerNode.copy();
            containerNode2.setInitialState(containerNode.initialX, containerNode.initialY, containerNode.initialScale);
            this.addChild(containerNode2);
            containerNode2.setGlobalScale(containerNode.getGlobalScale());
            containerNode2.setGlobalTranslation(containerNode.getGlobalTranslation());
            containerNode.moveToFront();
            containerNode2.updateExpansionButtonsEnabled();
        }
        this.fireInteractionEvent();
    }

    public void moveContainerNodeAwayFromCollectionBoxes(ContainerNode containerNode) {
        double d;
        double d2 = containerNode.getGlobalFullBounds().getMaxX();
        double d3 = d2 - (d = this.isFractionLab() ? AbstractFractionsCanvas.STAGE_SIZE.width : this.getCollectionBoxPairs().map(new F<ShapeSceneCollectionBoxPair, Double>(){

            @Override
            public Double f(ShapeSceneCollectionBoxPair shapeSceneCollectionBoxPair) {
                return shapeSceneCollectionBoxPair.getCollectionBoxNode().getGlobalFullBounds().getMinX();
            }
        }).minimum(Ord.doubleOrd));
        if (d3 > 0.0) {
            double d4 = 20.0 + d3;
            containerNode.animateToPositionScaleRotation(containerNode.getXOffset() - d4, containerNode.getYOffset(), containerNode.getScale(), containerNode.getRotation(), 200L).setDelegate(new DisablePickingWhileAnimating(containerNode, true));
        }
    }

    private List<Fraction> getUserCreatedFractions() {
        return this.getContainerNodes().filter(Booleans.not(ContainerNode._isInTargetCell)).map(ContainerNode._getFractionValue);
    }

    public void undoPieceFromContainer(PieceNode pieceNode) {
        Point2D point2D = pieceNode.getGlobalTranslation();
        double d = pieceNode.getGlobalScale();
        this.addChild(pieceNode);
        pieceNode.setGlobalTranslation(point2D);
        pieceNode.setGlobalScale(d);
        pieceNode.setPickable(true);
        pieceNode.setChildrenPickable(true);
        pieceNode.animateToTopOfStack();
    }

    private List<ContainerNode> getContainerNodes() {
        return FNode.getChildren(this, ContainerNode.class);
    }

    private boolean allCollectionBoxesFilled() {
        return this.getCollectionBoxPairs().map(new F<ShapeSceneCollectionBoxPair, Boolean>(){

            @Override
            public Boolean f(ShapeSceneCollectionBoxPair shapeSceneCollectionBoxPair) {
                return shapeSceneCollectionBoxPair.collectionBoxNode.isCompleted();
            }
        }).filter(new F<Boolean, Boolean>(){

            @Override
            public Boolean f(Boolean bl) {
                return bl;
            }
        }).length() == this.getCollectionBoxPairs().length();
    }

    public void collectionBoxUndone() {
        this.level.filledTargets.decrement();
        this.faceNodeDialog.animateToTransparency(0.0f, 200L);
        this.faceNodeDialog.setPickable(false);
        this.faceNodeDialog.setChildrenPickable(false);
    }

    @Override
    public Vector2D getLocation(int n, int n2, PieceNode pieceNode) {
        int n3;
        int n4 = this.level.shapeType == ShapeType.PIE ? -1 : 1;
        List<List<Integer>> list = this.level.pieces.group(Equal.intEqual);
        double d = this.getCardOffsetWithinStack(list.index(n).length(), n2);
        int n5 = n3 = this.level.shapeType == ShapeType.BAR ? 25 : 0;
        if (this.isFractionLab() && this.level.shapeType == ShapeType.PIE) {
            n3 += 12;
        }
        return new Vector2D(this.layoutXOffset + 30.0 + d * (double)n4 + (double)n * this.distanceBetweenStacks, AbstractFractionsCanvas.STAGE_SIZE.height - 117.0 - 3.0 * (double)n2 + (double)n3);
    }

    @Override
    public void movedNonStackCardsToFront() {
        this.getContainerNodes().foreach(new Effect<ContainerNode>(){

            @Override
            public void e(ContainerNode containerNode) {
                containerNode.moveDottedLinesToFront();
            }
        });
    }

    private double getCardOffsetWithinStack(int n, int n2) {
        double d = -3.0 * (double)(n - 1);
        return this.getCardOffsetWithinStack(n, n2, d);
    }

    private double getCardOffsetWithinStack(int n, int n2, double d) {
        return n == 1 ? 0.0 : new Function.LinearFunction(0.0, n - 1, -d / 2.0, d / 2.0).evaluate(n2);
    }

    public static class DropLocation {
        public final Vector2D position;
        public final double angle;

        @ConstructorProperties(value={"position", "angle"})
        public DropLocation(Vector2D vector2D, double d) {
            this.position = vector2D;
            this.angle = d;
        }

        public Vector2D getPosition() {
            return this.position;
        }

        public double getAngle() {
            return this.angle;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DropLocation)) {
                return false;
            }
            DropLocation dropLocation = (DropLocation)object;
            if (!dropLocation.canEqual(this)) {
                return false;
            }
            if (this.getPosition() == null ? dropLocation.getPosition() != null : !this.getPosition().equals(dropLocation.getPosition())) {
                return false;
            }
            return Double.compare(this.getAngle(), dropLocation.getAngle()) == 0;
        }

        public boolean canEqual(Object object) {
            return object instanceof DropLocation;
        }

        public int hashCode() {
            int n = 1;
            long l = Double.doubleToLongBits(this.getAngle());
            n = n * 31 + (this.getPosition() == null ? 0 : this.getPosition().hashCode());
            n = n * 31 + (int)(l >>> 32 ^ l);
            return n;
        }

        public String toString() {
            return "ShapeSceneNode.DropLocation(position=" + this.getPosition() + ", angle=" + this.getAngle() + ")";
        }
    }
}

