/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view.shapes;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.activities.AnimateToScale;
import edu.colorado.phet.common.piccolophet.activities.PActivityDelegateAdapter;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.DragEvent;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.SimSharingCanvasBoundedDragHandler;
import edu.colorado.phet.fractions.buildafraction.view.DisablePickingWhileAnimating;
import edu.colorado.phet.fractions.buildafraction.view.Stackable;
import edu.colorado.phet.fractions.buildafraction.view.UpdateAnimatingFlag;
import edu.colorado.phet.fractions.buildafraction.view.shapes.CompositeDelegate;
import edu.colorado.phet.fractions.buildafraction.view.shapes.PieceContext;
import edu.colorado.phet.fractions.buildafraction.view.shapes.SingleContainerNode;
import edu.colorado.phet.fractions.common.math.Fraction;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import fj.F;
import fj.data.Option;
import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class PieceNode
extends Stackable {
    public final Integer pieceSize;
    private static final PBounds TEMP_REPAINT_BOUNDS = new PBounds();
    double initialScale = Double.NaN;
    final PieceContext context;
    final PhetPPath pathNode;
    public static final BasicStroke stroke = new BasicStroke(2.0f);
    double pieceRotation = 0.0;
    private SingleContainerNode container;
    public long attachmentTime = -1L;
    public static final F<PieceNode, Fraction> _toFraction = new F<PieceNode, Fraction>(){

        @Override
        public Fraction f(PieceNode pieceNode) {
            return pieceNode.toFraction();
        }
    };
    private final ArrayList<PActivity> activities = new ArrayList();

    PieceNode(Integer n, PieceContext pieceContext, PhetPPath phetPPath) {
        this.pieceSize = n;
        this.context = pieceContext;
        this.pathNode = phetPPath;
    }

    void installInputListeners() {
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new SimSharingCanvasBoundedDragHandler(UserComponentChain.chain((IUserComponent)FractionsIntroSimSharing.Components.piece, this.hashCode()), this){

            protected ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
                return super.getParametersForAllEvents(pInputEvent).with((IParameterKey)FractionsIntroSimSharing.ParameterKeys.denominator, PieceNode.this.pieceSize);
            }

            public void mousePressed(final PInputEvent pInputEvent) {
                if (!pInputEvent.isLeftMouseButton()) {
                    return;
                }
                if (PieceNode.this.getNumberOfActiveActivities() > 0) {
                    return;
                }
                if (PieceNode.this.container != null) {
                    return;
                }
                super.mousePressed(pInputEvent);
                PieceNode.this.dragStarted();
                PieceNode.this.moveToFront();
                AnimateToScale animateToScale = new AnimateToScale(PieceNode.this.context.getContainerScale(), PieceNode.this, 200L);
                PieceNode.this.addActivity(animateToScale);
                animateToScale.setDelegate(new PActivityDelegateAdapter(){

                    public void activityStepped(PActivity pActivity) {
                        PieceNode.this.stepTowardMouse(pInputEvent);
                    }
                });
                PieceNode.this.context.startDrag(PieceNode.this);
                PieceNode.this.setPositionInStack(Option.<Integer>none());
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                if (!pInputEvent.isLeftMouseButton()) {
                    return;
                }
                if (PieceNode.this.container != null) {
                    return;
                }
                super.mouseDragged(pInputEvent);
            }

            protected void dragNode(DragEvent dragEvent) {
                if (PieceNode.this.container != null) {
                    return;
                }
                Option<Double> option = PieceNode.this.context.getNextAngle(PieceNode.this);
                PieceNode.this.translate(dragEvent.delta.width / PieceNode.this.getScale(), dragEvent.delta.height / PieceNode.this.getScale());
                Option<Double> option2 = PieceNode.this.context.getNextAngle(PieceNode.this);
                if (option.isSome() && option2.isSome() && !option.some().equals(option2.some())) {
                    PieceNode.this.rotateTo(option2.some(), dragEvent.event);
                }
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                if (!pInputEvent.isLeftMouseButton()) {
                    return;
                }
                if (PieceNode.this.container != null) {
                    return;
                }
                super.mouseReleased(pInputEvent);
                PieceNode.this.context.endDrag(PieceNode.this);
                PieceNode.this.dragEnded();
            }
        });
    }

    private int getNumberOfActiveActivities() {
        int n = 0;
        for (PActivity pActivity : this.activities) {
            if (!pActivity.isStepping()) continue;
            ++n;
        }
        return n;
    }

    void rotateTo(double d, PInputEvent pInputEvent) {
    }

    void stepTowardMouse(PInputEvent pInputEvent) {
        Point2D point2D = pInputEvent.getPositionRelativeTo(this);
        Point2D point2D2 = this.pathNode.getGlobalFullBounds().getCenter2D();
        point2D2 = this.globalToLocal(point2D2);
        Vector2D vector2D = new Vector2D(point2D2, point2D).times(0.75);
        this.translate(vector2D.x, vector2D.y);
    }

    void dragEnded() {
    }

    void dragStarted() {
    }

    protected double getAnimateToScale() {
        return this.initialScale;
    }

    AffineTransform getShadowOffset() {
        return AffineTransform.getTranslateInstance(6.0, 6.0);
    }

    public void setInitialScale(double d) {
        this.initialScale = d;
        this.setScale(d);
    }

    public Fraction toFraction() {
        return new Fraction(1, this.pieceSize);
    }

    public void animateToTopOfStack() {
        this.stack.animateToTopOfStack(this, this.context.isFractionLab());
    }

    public void animateToStackLocation(Vector2D vector2D, final boolean bl) {
        this.container = null;
        this.attachmentTime = -1L;
        this.animateToPositionScaleRotation(vector2D.x, vector2D.y, this.getAnimateToScale(), 0.0, 200L).setDelegate(new CompositeDelegate(new DisablePickingWhileAnimating(this, true), new PActivityDelegateAdapter(){

            public void activityStarted(PActivity pActivity) {
                PieceNode.this.showShadow();
            }

            public void activityFinished(PActivity pActivity) {
                PieceNode.this.hideShadow();
            }
        }, new UpdateAnimatingFlag(this.animating), new PActivityDelegateAdapter(){

            public void activityFinished(PActivity pActivity) {
                if (bl) {
                    PieceNode.this.delete();
                }
            }
        }));
    }

    protected void delete() {
        super.delete();
        this.removeFromParent();
    }

    protected abstract void hideShadow();

    protected abstract void showShadow();

    public void setInContainer(SingleContainerNode singleContainerNode) {
        this.container = singleContainerNode;
        this.attachmentTime = System.currentTimeMillis();
    }

    public void terminateActivities() {
        for (PActivity pActivity : new ArrayList<PActivity>(this.activities)) {
            this.activities.remove(pActivity);
            pActivity.terminate(0);
        }
        this.activities.clear();
    }

    public boolean addActivity(PActivity pActivity) {
        this.activities.add(pActivity);
        return super.addActivity(pActivity);
    }

    public abstract PieceNode copy();

    public void repaint() {
        TEMP_REPAINT_BOUNDS.setRect(RectangleUtils.expand(this.getFullBoundsReference(), 2.0, 2.0));
        this.repaintFrom(TEMP_REPAINT_BOUNDS, this);
    }
}

