/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view.numbers;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.view.Dimension2DDouble;
import edu.colorado.phet.common.piccolophet.RichPNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.fractions.buildafraction.model.BuildAFractionModel;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberLevel;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberTarget;
import edu.colorado.phet.fractions.buildafraction.view.BuildAFractionCanvas;
import edu.colorado.phet.fractions.buildafraction.view.SceneContext;
import edu.colorado.phet.fractions.buildafraction.view.SceneNode;
import edu.colorado.phet.fractions.buildafraction.view.Stack;
import edu.colorado.phet.fractions.buildafraction.view.StackContext;
import edu.colorado.phet.fractions.buildafraction.view.numbers.FractionCardNode;
import edu.colorado.phet.fractions.buildafraction.view.numbers.FractionDraggingContext;
import edu.colorado.phet.fractions.buildafraction.view.numbers.FractionNode;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberCardNode;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberCollectionBoxNode;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberDragContext;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberNode;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberSceneCollectionBoxPair;
import edu.colorado.phet.fractions.common.view.AbstractFractionsCanvas;
import edu.colorado.phet.fractions.fractionmatcher.view.PatternNode;
import edu.umd.cs.piccolo.PNode;
import fj.Equal;
import fj.F;
import fj.Ord;
import fj.P2;
import fj.data.List;
import fj.data.Option;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberSceneNode
extends SceneNode<NumberSceneCollectionBoxPair>
implements StackContext<NumberCardNode>,
FractionDraggingContext,
NumberDragContext {
    private final ArrayList<FractionNode> fractionNodes = new ArrayList();
    private final PNode rootNode;
    private final RichPNode toolboxNode;
    private final ArrayList<Stack> stackList;
    public final NumberLevel level;
    private final Dimension2DDouble singleDigitCardSize;
    private final Dimension2DDouble doubleDigitCardSize;
    private final List<List<Integer>> stacks;
    private final Vector2D centerOfScreen;
    private final double spaceBetweenStacks;
    private final Property<Option<Integer>> draggedCardProperty = new Property(Option.none());
    private double toolboxPositionY;
    private double offsetX;
    private Vector2D initialToolboxPositionForSkeletons;

    public NumberSceneNode(final int n, PNode pNode, BuildAFractionModel buildAFractionModel, final SceneContext sceneContext, BooleanProperty booleanProperty, boolean bl) {
        super(n, booleanProperty, sceneContext, bl);
        Object object;
        double d = 10.0;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                sceneContext.goToNumberLevel(n + 1);
            }
        };
        VoidFunction0 voidFunction0 = new VoidFunction0(){

            public void apply() {
                sceneContext.resampleNumberLevel(n);
            }
        };
        this.level = buildAFractionModel.getNumberLevel(n);
        this.rootNode = pNode;
        this.initCollectionBoxes(d, this.getCollectionBoxPairs(buildAFractionModel), bl);
        this.stacks = this.level.numbers.group(Equal.intEqual);
        this.singleDigitCardSize = NumberSceneNode.getCardSize(this.stacks, new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n) {
                return n.toString().length() < 2;
            }
        });
        this.doubleDigitCardSize = NumberSceneNode.getCardSize(this.stacks, new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n) {
                return n.toString().length() >= 2;
            }
        });
        Function.LinearFunction linearFunction = new Function.LinearFunction(58.0, 68.0, 38.0, 28.0);
        double d2 = linearFunction.evaluate(this.singleDigitCardSize.width);
        this.spaceBetweenStacks = bl ? d2 : 28.0;
        List<List<NumberCardNode>> list = this.stacks.map(new F<List<Integer>, List<NumberCardNode>>(){

            @Override
            public List<NumberCardNode> f(List<Integer> list) {
                return list.map(new F<Integer, NumberCardNode>(){

                    @Override
                    public NumberCardNode f(Integer n) {
                        return new NumberCardNode(n.toString().length() < 2 ? NumberSceneNode.this.singleDigitCardSize : NumberSceneNode.this.doubleDigitCardSize, n, NumberSceneNode.this);
                    }
                });
            }
        });
        FractionNode fractionNode = new FractionNode(this, this.level.hasMixedNumbers());
        fractionNode.setScale(1.0);
        double d3 = 40.0 + this.getStackOffset(this.stacks.length()) - this.singleDigitCardSize.width + 50.0 + fractionNode.getFullBounds().getWidth() - 30.0 - (double)(this.level.hasMixedNumbers() ? 30 : 0);
        if (bl) {
            d3 = AbstractFractionsCanvas.STAGE_SIZE.width - 20.0;
        }
        final double d4 = d3;
        this.toolboxNode = new RichPNode(new PNode[0]){
            {
                super(pNodeArray);
                PhetPPath phetPPath = new PhetPPath(new RoundRectangle2D.Double(0.0, 0.0, d4, 130.0, 30.0, 30.0), Color.white, BuildAFractionCanvas.CONTROL_PANEL_STROKE, Color.darkGray);
                this.addChild(phetPPath);
                double d2 = Math.max((AbstractFractionsCanvas.STAGE_SIZE.width - 150.0) / 2.0 - this.getFullWidth() / 2.0 - 29.0 - (double)(NumberSceneNode.this.level.hasValuesGreaterThanOne() ? 48 : 0), 10.0);
                this.setOffset(d2, AbstractFractionsCanvas.STAGE_SIZE.height - 10.0 - this.getFullHeight());
            }
        };
        this.addChild(this.toolboxNode);
        this.stackList = new ArrayList();
        for (P2<List<NumberCardNode>, Integer> p2 : list.zipIndex()) {
            Integer n2 = p2._2();
            Stack<NumberCardNode> stack = new Stack<NumberCardNode>(p2._1(), n2, this);
            this.stackList.add(stack);
            for (P2<NumberCardNode, Integer> p22 : p2._1().zipIndex()) {
                object = p22._2();
                NumberCardNode numberCardNode = p22._1();
                numberCardNode.setOffset(stack.getLocation((Integer)object, numberCardNode).toPoint2D());
                numberCardNode.setPositionInStack(Option.some(object));
                numberCardNode.setStack(stack);
                this.addChild(numberCardNode);
            }
            stack.update();
        }
        this.addChild(fractionNode);
        this.fractionNodes.add(fractionNode);
        int n3 = this.level.targets.length() - 1;
        double d5 = 0.0;
        for (int i = 0; i < n3; ++i) {
            object = new CreateNonMixedFractionGraphicFractionLab(bl).invoke();
            double d6 = ((CreateNonMixedFractionGraphicFractionLab)object).getToolboxPositionX();
            d5 = ((CreateNonMixedFractionGraphicFractionLab)object).getToolboxPositionY();
            this.initialToolboxPositionForSkeletons = Vector2D.v(d6, d5);
        }
        if (bl) {
            this.offsetX = this.toolboxNode.getMaxX() - 200.0;
            this.addMixedFractionGraphicFactionLab(d5, this.offsetX);
            this.toolboxPositionY = d5;
        }
        this.init(n, buildAFractionModel, actionListener, voidFunction0, bl);
        fractionNode.setToolboxPosition(this.initialToolboxPositionForSkeletons.x, this.initialToolboxPositionForSkeletons.y);
        this.centerOfScreen = new Vector2D(bl ? 300.0 : this.title.getFullBounds().getCenterX() - fractionNode.getFullWidth() / 2.0 + 28.0, 350.0 - fractionNode.getFullHeight() / 2.0 - (double)(bl ? 0 : 30));
        fractionNode.setOffset(this.centerOfScreen.toPoint2D());
        fractionNode.moveInFrontOf(this.toolboxNode);
    }

    private void addMixedFractionGraphicFactionLab(double d, double d2) {
        FractionNode fractionNode = new FractionNode(this, true);
        double d3 = d2 + 67.0;
        fractionNode.setToolboxPosition(d3, d);
        fractionNode.setOffset(d3, d);
        this.addChild(fractionNode);
        this.fractionNodes.add(fractionNode);
        fractionNode.moveInFrontOf(this.toolboxNode);
    }

    private ArrayList<NumberSceneCollectionBoxPair> getCollectionBoxPairs(BuildAFractionModel buildAFractionModel) {
        ArrayList<NumberSceneCollectionBoxPair> arrayList = new ArrayList<NumberSceneCollectionBoxPair>();
        for (int i = 0; i < this.level.targets.length(); ++i) {
            NumberTarget numberTarget = this.level.targets.index(i);
            ArrayList<7> arrayList2 = new ArrayList<7>();
            for (int j = 0; j < numberTarget.filledPattern.length(); ++j) {
                arrayList2.add(new PatternNode(numberTarget.filledPattern.index(j), numberTarget.color){
                    {
                        double d = 80.0;
                        double d2 = this.getFullBounds().getWidth();
                        double d3 = d / d2;
                        this.scale(d3);
                        this.scaleStrokes(1.0 / d3);
                    }
                });
            }
            HBox hBox = new HBox(arrayList2.toArray(new PNode[arrayList2.size()]));
            if (buildAFractionModel.isMixedNumbers()) {
                hBox.scale(0.75);
            }
            arrayList.add(new NumberSceneCollectionBoxPair(new NumberCollectionBoxNode(numberTarget.mixedFraction, this, buildAFractionModel.collectedMatch.or(this.level.matchExists)), new ZeroOffsetNode((PNode)hBox)));
        }
        return arrayList;
    }

    private static Dimension2DDouble getCardSize(List<List<Integer>> list, final F<Integer, Boolean> f) {
        List<NumberNode> list2 = list.map(new F<List<Integer>, NumberNode>(){

            @Override
            public NumberNode f(List<Integer> list) {
                return new NumberNode(list.head());
            }
        });
        List<NumberNode> list3 = list2.filter(new F<NumberNode, Boolean>(){

            @Override
            public Boolean f(NumberNode numberNode) {
                return (Boolean)f.f(numberNode.number);
            }
        });
        if (list3.length() == 0) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        double d = list3.map(new F<NumberNode, Double>(){

            @Override
            public Double f(NumberNode numberNode) {
                return numberNode.getFullBounds().getWidth();
            }
        }).maximum(Ord.doubleOrd);
        double d2 = list3.map(new F<NumberNode, Double>(){

            @Override
            public Double f(NumberNode numberNode) {
                return numberNode.getFullBounds().getHeight();
            }
        }).maximum(Ord.doubleOrd);
        return new Dimension2DDouble(d + 22.0, d2);
    }

    @Override
    protected void reset() {
        this.resetCollectionBoxes();
        this.resetFractions();
    }

    @Override
    public void setToolboxEnabled(boolean bl) {
    }

    private void resetFractions() {
        boolean bl = true;
        for (FractionNode fractionNode : this.fractionNodes) {
            fractionNode.reset();
            if (bl) {
                fractionNode.animateToCenterOfScreen();
            } else {
                fractionNode.animateToToolbox();
            }
            bl = false;
        }
    }

    private void resetCollectionBoxes() {
        for (NumberSceneCollectionBoxPair numberSceneCollectionBoxPair : this.getCollectionBoxPairs()) {
            if (!numberSceneCollectionBoxPair.collectionBoxNode.isCompleted()) continue;
            numberSceneCollectionBoxPair.collectionBoxNode.undo(false);
        }
    }

    @Override
    public void endDrag(FractionNode fractionNode) {
        if (this.toolboxNode.getGlobalFullBounds().intersects(fractionNode.getGlobalFullBounds()) && fractionNode.isEmpty()) {
            fractionNode.animateToToolbox();
        }
        if (fractionNode.getGlobalFullBounds().getMaxX() > this.minimumCollectionBoxX() && !this.fractionLab) {
            fractionNode.animateNearCenterOfScreen();
        }
    }

    public double minimumCollectionBoxX() {
        return this.getCollectionBoxPairs().map(new F<NumberSceneCollectionBoxPair, Double>(){

            @Override
            public Double f(NumberSceneCollectionBoxPair numberSceneCollectionBoxPair) {
                return numberSceneCollectionBoxPair.collectionBoxNode.getGlobalFullBounds().getMinX();
            }
        }).minimum(Ord.doubleOrd);
    }

    @Override
    public void endDrag(NumberCardNode numberCardNode) {
        boolean bl = false;
        for (FractionNode fractionNode : this.fractionNodes) {
            PhetPPath phetPPath = fractionNode.numerator.box.shape;
            PhetPPath phetPPath2 = fractionNode.denominator.box.shape;
            PhetPPath phetPPath3 = fractionNode.whole.box.shape;
            if (fractionNode.numerator.isEnabled() && numberCardNode.getGlobalFullBounds().intersects(phetPPath.getGlobalFullBounds()) && phetPPath.getVisible() && !fractionNode.isInToolboxPosition()) {
                this.numberDroppedOnFraction(fractionNode, numberCardNode, phetPPath);
                bl = true;
                break;
            }
            if (fractionNode.denominator.isEnabled() && numberCardNode.getGlobalFullBounds().intersects(phetPPath2.getGlobalFullBounds()) && phetPPath2.getVisible() && !fractionNode.isInToolboxPosition()) {
                this.numberDroppedOnFraction(fractionNode, numberCardNode, phetPPath2);
                bl = true;
                break;
            }
            if (!fractionNode.whole.isEnabled() || !numberCardNode.getGlobalFullBounds().intersects(phetPPath3.getGlobalFullBounds()) || !phetPPath3.getVisible() || fractionNode.isInToolboxPosition()) continue;
            this.numberDroppedOnFraction(fractionNode, numberCardNode, phetPPath3);
            bl = true;
            break;
        }
        if (!bl) {
            numberCardNode.animateToTopOfStack(this.isFractionLab());
        }
        this.draggedCardProperty.set(Option.none());
    }

    @Override
    public void startDrag(NumberCardNode numberCardNode) {
        this.draggedCardProperty.set(Option.some(numberCardNode.number));
        if (this.fractionLab && !((Boolean)numberCardNode.animating.get()).booleanValue()) {
            NumberCardNode numberCardNode2 = numberCardNode.copy();
            this.addChild(numberCardNode2);
            numberCardNode2.setGlobalTranslation(numberCardNode.getGlobalTranslation());
            numberCardNode2.setGlobalScale(numberCardNode.getGlobalScale());
            numberCardNode2.moveToFront();
        }
        this.fireInteractionEvent();
    }

    private void numberDroppedOnFraction(FractionNode fractionNode, NumberCardNode numberCardNode, PhetPPath phetPPath) {
        this.centerOnBox(numberCardNode, phetPPath);
        phetPPath.setVisible(false);
        numberCardNode.setPickable(false);
        numberCardNode.setChildrenPickable(false);
        fractionNode.undoButton.setVisible(true);
        fractionNode.attachNumber(phetPPath, numberCardNode);
        if (fractionNode.isComplete()) {
            this.level.createdFractions.set(((List)this.level.createdFractions.get()).snoc(fractionNode.getValue()));
            FractionCardNode fractionCardNode = new FractionCardNode(fractionNode, this.getCollectionBoxPairs(), this);
            this.addChild(fractionCardNode);
            fractionCardNode.moveInBackOf(fractionNode);
        }
    }

    boolean allIncompleteFractionsInToolbox() {
        for (FractionNode fractionNode : this.fractionNodes) {
            if (fractionNode.isComplete() || fractionNode.isInToolboxPosition()) continue;
            return false;
        }
        return true;
    }

    private void centerOnBox(NumberCardNode numberCardNode, PhetPPath phetPPath) {
        Rectangle2D rectangle2D = phetPPath.getGlobalFullBounds();
        rectangle2D = this.rootNode.globalToLocal(rectangle2D);
        numberCardNode.centerFullBoundsOnPoint(rectangle2D.getCenterX(), rectangle2D.getCenterY());
    }

    public void fractionCardNodeDroppedInCollectionBox() {
        this.level.filledTargets.increment();
        if (!this.allTargetsComplete()) {
            this.notifyOneCompleted();
            if (this.allIncompleteFractionsInToolbox()) {
                FractionNode fractionNode = null;
                for (FractionNode fractionNode2 : this.fractionNodes) {
                    if (!fractionNode2.isInToolboxPosition()) continue;
                    fractionNode = fractionNode2;
                }
                if (fractionNode != null) {
                    fractionNode.animateToCenterOfScreen();
                }
            }
        } else {
            this.faceNodeDialog.setVisible(true);
            this.faceNodeDialog.animateToTransparency(1.0f, 200L);
            this.faceNodeDialog.setPickable(true);
            this.faceNodeDialog.setChildrenPickable(true);
            this.faceNodeDialog.moveToFront();
            this.notifyAllCompleted();
        }
    }

    private boolean allTargetsComplete() {
        return this.numCompletedTargets() == this.getCollectionBoxPairs().length();
    }

    private int numCompletedTargets() {
        return this.getCollectionBoxPairs().map(new F<NumberSceneCollectionBoxPair, Boolean>(){

            @Override
            public Boolean f(NumberSceneCollectionBoxPair numberSceneCollectionBoxPair) {
                return numberSceneCollectionBoxPair.collectionBoxNode.isCompleted();
            }
        }).filter(new F<Boolean, Boolean>(){

            @Override
            public Boolean f(Boolean bl) {
                return bl;
            }
        }).length();
    }

    public void numberCollectionBoxUndone() {
        this.level.filledTargets.decrement();
        this.faceNodeDialog.animateToTransparency(0.0f, 200L);
        this.faceNodeDialog.setPickable(false);
        this.faceNodeDialog.setChildrenPickable(false);
    }

    @Override
    public void updateStacks() {
        for (Stack stack : this.stackList) {
            stack.update();
        }
    }

    @Override
    public Vector2D getCenterOfScreen() {
        return this.centerOfScreen;
    }

    @Override
    public ObservableProperty<Option<Integer>> getDraggedCardProperty() {
        return this.draggedCardProperty;
    }

    @Override
    public void startDrag(FractionNode fractionNode) {
        if (this.fractionLab) {
            if (fractionNode.mixedNumber && this.countMixedFractionNodes() < 4) {
                this.addMixedFractionGraphicFactionLab(this.toolboxPositionY, this.offsetX);
            } else if (this.countNonMixedFractionNodes() < 4) {
                new CreateNonMixedFractionGraphicFractionLab(this.fractionLab).invoke();
            }
        }
        this.fireInteractionEvent();
    }

    private int countNonMixedFractionNodes() {
        int n = 0;
        for (Object e : this.getChildrenReference()) {
            RichPNode richPNode;
            PNode pNode = (PNode)e;
            if (pNode instanceof FractionNode) {
                richPNode = (FractionNode)pNode;
                if (((FractionNode)richPNode).mixedNumber) continue;
                ++n;
                continue;
            }
            if (!(pNode instanceof FractionCardNode) || ((FractionCardNode)(richPNode = (FractionCardNode)pNode)).isMixedNumber()) continue;
            ++n;
        }
        return n;
    }

    private int countMixedFractionNodes() {
        int n = 0;
        for (Object e : this.getChildrenReference()) {
            RichPNode richPNode;
            PNode pNode = (PNode)e;
            if (pNode instanceof FractionNode) {
                richPNode = (FractionNode)pNode;
                if (!((FractionNode)richPNode).mixedNumber) continue;
                ++n;
                continue;
            }
            if (!(pNode instanceof FractionCardNode) || !((FractionCardNode)(richPNode = (FractionCardNode)pNode)).isMixedNumber()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean isFractionLab() {
        return this.fractionLab;
    }

    @Override
    public boolean isInCollectionBox(final FractionNode fractionNode) {
        return this.getCollectionBoxPairs().exists(new F<NumberSceneCollectionBoxPair, Boolean>(){

            @Override
            public Boolean f(NumberSceneCollectionBoxPair numberSceneCollectionBoxPair) {
                return numberSceneCollectionBoxPair.getCollectionBoxNode().isCompleted() && numberSceneCollectionBoxPair.getCollectionBoxNode().getCompletedFraction() == fractionNode;
            }
        });
    }

    @Override
    public Vector2D getLocation(int n, int n2, NumberCardNode numberCardNode) {
        double d = (double)n2 * 4.0;
        return new Vector2D(this.toolboxNode.getMinX() + 20.0 + this.getStackOffset(n) + d, this.toolboxNode.getCenterY() - numberCardNode.getFullBounds().getHeight() / 2.0 + (double)n2 * 4.0);
    }

    @Override
    public void movedNonStackCardsToFront() {
    }

    private double getStackOffset(int n) {
        double d = 0.0;
        for (List<Integer> list : this.stacks.take(n)) {
            d += list.head().toString().length() < 2 ? this.singleDigitCardSize.width : this.doubleDigitCardSize.width;
            d += this.spaceBetweenStacks;
        }
        return d + (double)(this.isFractionLab() ? 72 : 0);
    }

    private class CreateNonMixedFractionGraphicFractionLab {
        private final boolean fractionLab;
        private double toolboxPositionX;
        private double toolboxPositionY;

        public CreateNonMixedFractionGraphicFractionLab(boolean bl) {
            this.fractionLab = bl;
        }

        public double getToolboxPositionX() {
            return this.toolboxPositionX;
        }

        public double getToolboxPositionY() {
            return this.toolboxPositionY;
        }

        public CreateNonMixedFractionGraphicFractionLab invoke() {
            FractionNode fractionNode = new FractionNode(NumberSceneNode.this, NumberSceneNode.this.level.hasMixedNumbers());
            this.toolboxPositionX = this.fractionLab ? NumberSceneNode.this.toolboxNode.getMinX() + 23.0 : NumberSceneNode.this.toolboxNode.getMaxX() + 3.0 - fractionNode.getFullBounds().getWidth();
            this.toolboxPositionY = NumberSceneNode.this.toolboxNode.getCenterY() - fractionNode.getFullBounds().getHeight() / 2.0;
            fractionNode.setToolboxPosition(this.toolboxPositionX, this.toolboxPositionY);
            fractionNode.setOffset(this.toolboxPositionX, this.toolboxPositionY);
            NumberSceneNode.this.addChild(fractionNode);
            NumberSceneNode.this.fractionNodes.add(fractionNode);
            fractionNode.moveInFrontOf(NumberSceneNode.this.toolboxNode);
            return this;
        }
    }
}

