/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view.numbers;

import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.fractions.buildafraction.model.MixedFraction;
import edu.colorado.phet.fractions.buildafraction.view.BuildAFractionCanvas;
import edu.colorado.phet.fractions.buildafraction.view.CollectionBoxNode;
import edu.colorado.phet.fractions.buildafraction.view.UndoButton;
import edu.colorado.phet.fractions.buildafraction.view.numbers.FractionCardNode;
import edu.colorado.phet.fractions.buildafraction.view.numbers.FractionNode;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberSceneNode;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberCollectionBoxNode
extends CollectionBoxNode {
    public final MixedFraction mixedFraction;
    private final PhetPPath path;
    private boolean completed;
    private final UndoButton undoButton;
    private FractionNode fractionGraphic;
    private final NumberSceneNode numberSceneNode;

    public NumberCollectionBoxNode(MixedFraction mixedFraction, NumberSceneNode numberSceneNode, final ObservableProperty<Boolean> observableProperty) {
        this.numberSceneNode = numberSceneNode;
        this.path = new PhetPPath(new RoundRectangle2D.Double(0.0, 0.0, 120.0, 120.0, 30.0, 30.0), BACKGROUND, STROKE, DISABLED_STROKE_PAINT){
            {
                super(shape, paint, stroke, paint2);
                if (!((Boolean)observableProperty.get()).booleanValue()) {
                    this.setTransparency(0.2f);
                }
                observableProperty.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        if (bl.booleanValue()) {
                            this.setStrokePaint(ENABLED_STROKE_PAINT);
                            this.animateToTransparency(1.0f, 500L);
                        } else {
                            this.setStrokePaint(DISABLED_STROKE_PAINT);
                            this.animateToTransparency(0.2f, 500L);
                        }
                    }
                });
            }
        };
        this.mixedFraction = mixedFraction;
        this.addChild(this.path);
        this.undoButton = new UndoButton(FractionsIntroSimSharing.Components.collectionBoxUndoButton){
            {
                this.scale(0.8);
                this.setOffset(-1.0, -1.0);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        NumberCollectionBoxNode.this.undo(true);
                    }
                });
            }
        };
        this.undoButton.addInputEventListener(new CursorHandler());
        this.undoButton.setVisible(false);
        this.addChild(this.undoButton);
    }

    public void undo(boolean bl) {
        if (this.completed) {
            this.completed = false;
            this.path.setStroke(BuildAFractionCanvas.CONTROL_PANEL_STROKE);
            this.undoButton.setVisible(false);
            this.undoButton.setPickable(false);
            this.undoButton.setChildrenPickable(false);
            this.fractionGraphic.setScale(1.0);
            this.fractionGraphic.undoButton.setVisible(true);
            FractionCardNode fractionCardNode = new FractionCardNode(this.fractionGraphic, this.numberSceneNode.getCollectionBoxPairs(), this.numberSceneNode);
            this.numberSceneNode.addChild(fractionCardNode);
            this.fractionGraphic = null;
            fractionCardNode.fractionNode.undoAll();
            if (bl) {
                fractionCardNode.fractionNode.animateToToolbox();
            }
            this.numberSceneNode.numberCollectionBoxUndone();
            this.numberSceneNode.updateStacks();
        }
    }

    public void setCompletedFraction(FractionNode fractionNode) {
        this.fractionGraphic = fractionNode;
        this.completed = true;
        this.undoButton.setVisible(true);
        this.undoButton.setPickable(true);
        this.undoButton.setChildrenPickable(true);
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public FractionNode getCompletedFraction() {
        return this.fractionGraphic;
    }
}

