/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view;

import edu.colorado.phet.common.games.GameAudioPlayer;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.SystemComponentTypes;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.FaceNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.fractions.FractionsResources;
import edu.colorado.phet.fractions.buildafraction.model.BuildAFractionModel;
import edu.colorado.phet.fractions.buildafraction.view.ICollectionBoxPair;
import edu.colorado.phet.fractions.buildafraction.view.SceneContext;
import edu.colorado.phet.fractions.common.view.AbstractFractionsCanvas;
import edu.colorado.phet.fractions.common.view.LevelSelectionScreenButton;
import edu.colorado.phet.fractions.common.view.RefreshButtonNode;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import fj.F;
import fj.Ord;
import fj.data.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SceneNode<T extends ICollectionBoxPair>
extends PNode {
    private List<T> collectionBoxPairs;
    private final LevelSelectionScreenButton levelSelectionScreenButton;
    protected VBox faceNodeDialog;
    protected PhetPText title;
    public final boolean fractionLab;
    private final GameAudioPlayer gameAudioPlayer;
    public final int levelIndex;
    private ArrayList<SimpleObserver> interactionHandlers = new ArrayList();

    protected SceneNode(final int n, BooleanProperty booleanProperty, final SceneContext sceneContext, boolean bl) {
        this.fractionLab = bl;
        this.levelIndex = n;
        this.gameAudioPlayer = new GameAudioPlayer((Boolean)booleanProperty.get());
        booleanProperty.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                SceneNode.this.gameAudioPlayer.setEnabled(bl);
            }
        });
        this.levelSelectionScreenButton = new LevelSelectionScreenButton(new VoidFunction0(){

            public void apply() {
                sceneContext.goToLevelSelectionScreen(n);
            }
        }, FractionsResources.Images.FRACTIONS_BUTTON_BUILD){
            {
                this.setOffset(10.0, 10.0);
            }
        };
        if (!bl) {
            this.addChild(this.levelSelectionScreenButton);
        }
    }

    protected void notifyOneCompleted() {
        this.gameAudioPlayer.correctAnswer();
        SimSharingManager.sendSystemMessage(FractionsIntroSimSharing.SystemComponents.buildAFraction, SystemComponentTypes.application, FractionsIntroSimSharing.SystemActions.oneChallengeComplete);
    }

    protected void notifyAllCompleted() {
        this.gameAudioPlayer.gameOverPerfectScore();
        SimSharingManager.sendSystemMessage(FractionsIntroSimSharing.SystemComponents.buildAFraction, SystemComponentTypes.application, FractionsIntroSimSharing.SystemActions.allChallengesComplete);
    }

    public void addInteractionHandler(SimpleObserver simpleObserver) {
        this.interactionHandlers.add(simpleObserver);
    }

    protected void initCollectionBoxes(double d, ArrayList<T> arrayList, boolean bl) {
        this.collectionBoxPairs = List.iterableList(arrayList);
        List<Double> list = this.collectionBoxPairs.map(new F<T, PNode>(){

            @Override
            public PNode f(T t) {
                return t.getTargetNode();
            }
        });
        double d2 = list.map(new F<PNode, Double>(){

            @Override
            public Double f(PNode pNode) {
                return pNode.getFullBounds().getWidth();
            }
        }).maximum(Ord.doubleOrd);
        double d3 = list.map(new F<PNode, Double>(){

            @Override
            public Double f(PNode pNode) {
                return pNode.getFullBounds().getHeight();
            }
        }).maximum(Ord.doubleOrd);
        double d4 = 5.0;
        double d5 = 10.0;
        PBounds pBounds = ((ICollectionBoxPair)this.collectionBoxPairs.head()).getCollectionBoxNode().getFullBounds();
        double d6 = AbstractFractionsCanvas.STAGE_SIZE.width - d2 - d4 - pBounds.getWidth() - d5;
        double d7 = 10.0;
        for (ICollectionBoxPair iCollectionBoxPair : this.collectionBoxPairs) {
            iCollectionBoxPair.getCollectionBoxNode().setOffset(d6, d7);
            iCollectionBoxPair.getTargetNode().setOffset(d6 + pBounds.getWidth() + d4, d7 + pBounds.getHeight() / 2.0 - d3 / 2.0);
            if (!bl) {
                this.addChild(iCollectionBoxPair.getCollectionBoxNode());
                this.addChild(iCollectionBoxPair.getTargetNode());
            }
            d7 += Math.max(d3, pBounds.getHeight()) + d;
        }
    }

    protected void init(int n, BuildAFractionModel buildAFractionModel, final ActionListener actionListener, VoidFunction0 voidFunction0, boolean bl) {
        double d = this.collectionBoxPairs.map(new F<T, Double>(){

            @Override
            public Double f(T t) {
                return t.getCollectionBoxNode().getFullBounds().getMinX();
            }
        }).minimum(Ord.doubleOrd);
        this.title = new PhetPText(MessageFormat.format(FractionsResources.Strings.LEVEL__PATTERN, n + 1), new PhetFont(32, true));
        this.title.setOffset(d / 2.0 - this.title.getFullWidth() / 2.0, this.levelSelectionScreenButton.getFullBounds().getCenterY() - this.title.getFullHeight() / 2.0);
        if (!bl) {
            this.addChild(this.title);
        }
        TextButtonNode textButtonNode = new TextButtonNode(FractionsResources.Strings.RESET, AbstractFractionsCanvas.CONTROL_FONT, RefreshButtonNode.BUTTON_COLOR){
            {
                this.setUserComponent(FractionsIntroSimSharing.Components.resetButton);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SceneNode.this.reset();
                    }
                });
            }
        };
        RefreshButtonNode refreshButtonNode = new RefreshButtonNode(voidFunction0);
        if (!bl) {
            this.addChild(new HBox(new PNode[]{textButtonNode, refreshButtonNode}){
                {
                    this.setOffset(SceneNode.this.title.getCenterX() - this.getFullBounds().getWidth() / 2.0, SceneNode.this.title.getMaxY() + 10.0);
                }
            });
        }
        HTMLImageButtonNode hTMLImageButtonNode = new HTMLImageButtonNode(FractionsResources.Strings.NEXT, new PhetFont(20, true), RefreshButtonNode.BUTTON_COLOR){
            {
                super(string, phetFont, color);
                this.setUserComponent(FractionsIntroSimSharing.Components.nextButton);
                this.addActionListener(actionListener);
            }
        };
        this.faceNodeDialog = new VBox(new PNode[]{new FaceNode(200.0), buildAFractionModel.isLastLevel(n) ? new PNode() : hTMLImageButtonNode}){
            {
                this.setOffset(SceneNode.this.title.getCenterX() - this.getFullBounds().getWidth() / 2.0, AbstractFractionsCanvas.STAGE_SIZE.getHeight() / 2.0 - this.getFullBounds().getHeight() / 2.0 - 50.0);
            }
        };
        this.faceNodeDialog.setTransparency(0.0f);
        this.faceNodeDialog.setVisible(false);
        this.faceNodeDialog.setPickable(false);
        this.faceNodeDialog.setChildrenPickable(false);
        this.addChild(this.faceNodeDialog);
    }

    protected abstract void reset();

    public List<T> getCollectionBoxPairs() {
        return this.collectionBoxPairs;
    }

    public void fireInteractionEvent() {
        for (SimpleObserver simpleObserver : this.interactionHandlers) {
            simpleObserver.update();
        }
    }

    public void moveToFrontDuringInteraction() {
        this.addInteractionHandler(new SimpleObserver(){

            public void update() {
                SceneNode.this.moveToFront();
            }
        });
    }

    public abstract void setToolboxEnabled(boolean var1);
}

