/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.common.piccolophet.nodes.radiobuttonstrip.RadioButtonStripControlPanelNode;
import edu.colorado.phet.fractions.buildafraction.FractionLabCanvasContext;
import edu.colorado.phet.fractions.buildafraction.model.BuildAFractionModel;
import edu.colorado.phet.fractions.buildafraction.model.MixedFraction;
import edu.colorado.phet.fractions.buildafraction.model.NumberLevelFactory;
import edu.colorado.phet.fractions.buildafraction.model.ShapeLevelFactory;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberLevel;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberLevelList;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberTarget;
import edu.colorado.phet.fractions.buildafraction.model.shapes.ShapeLevel;
import edu.colorado.phet.fractions.buildafraction.model.shapes.ShapeType;
import edu.colorado.phet.fractions.buildafraction.view.BuildAFractionCanvas;
import edu.colorado.phet.fractions.buildafraction.view.LevelSelectionNode;
import edu.colorado.phet.fractions.buildafraction.view.SceneContext;
import edu.colorado.phet.fractions.buildafraction.view.SceneNode;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberSceneNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ContainerShapeNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.PieceNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ShapeSceneNode;
import edu.colorado.phet.fractions.common.math.Fraction;
import edu.colorado.phet.fractions.common.view.AbstractFractionsCanvas;
import edu.colorado.phet.fractions.common.view.RefreshButtonNode;
import edu.colorado.phet.fractions.fractionsintro.FractionsIntroSimSharing;
import edu.umd.cs.piccolo.PNode;
import fj.data.List;
import java.awt.BasicStroke;
import java.awt.Color;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractionLabCanvas
extends AbstractFractionsCanvas {
    public FractionLabCanvas(final FractionLabCanvasContext fractionLabCanvasContext) {
        this.setBackground(BuildAFractionCanvas.LIGHT_BLUE);
        BuildAFractionModel buildAFractionModel = this.createModel(ShapeType.PIE, LevelSelectionNode.colors[0]);
        SceneContext sceneContext = new SceneContext(){

            public void goToShapeLevel(int n) {
            }

            public void goToNumberLevel(int n) {
            }

            public void goToLevelSelectionScreen(int n) {
            }

            public void resampleShapeLevel(int n) {
            }

            public void resampleNumberLevel(int n) {
            }
        };
        BooleanProperty booleanProperty = new BooleanProperty(false);
        NumberSceneNode numberSceneNode = new NumberSceneNode(0, this.rootNode, buildAFractionModel, sceneContext, booleanProperty, true){
            {
                this.moveToFrontDuringInteraction();
            }
        };
        this.addChild(numberSceneNode);
        final ShapeSceneNode shapeSceneNode = new ShapeSceneNode(0, buildAFractionModel, sceneContext, booleanProperty, true, true){
            {
                this.translate(0.0, -AbstractFractionsCanvas.STAGE_SIZE.height + (double)this.toolboxHeight + 30.0);
                this.moveToFrontDuringInteraction();
            }
        };
        this.addChild(shapeSceneNode);
        final ShapeSceneNode shapeSceneNode2 = new ShapeSceneNode(0, this.createModel(ShapeType.BAR, LevelSelectionNode.colors[1]), sceneContext, booleanProperty, true, false){
            {
                this.translate(0.0, -AbstractFractionsCanvas.STAGE_SIZE.height + (double)this.toolboxHeight + 30.0);
                this.moveToFrontDuringInteraction();
            }
        };
        this.addChild(shapeSceneNode2);
        java.util.List list = Arrays.asList(new RadioButtonStripControlPanelNode.Element<ShapeType>(new PhetPPath(ContainerShapeNode.createPieSlice(1), LevelSelectionNode.colors[0], PieceNode.stroke, Color.black){
            {
                this.scale(0.15);
            }
        }, ShapeType.PIE, FractionsIntroSimSharing.Components.pieShapeRadioButton), new RadioButtonStripControlPanelNode.Element<ShapeType>(new PhetPPath(ContainerShapeNode.createRect(1), LevelSelectionNode.colors[1], PieceNode.stroke, Color.black){
            {
                this.scale(0.15);
            }
        }, ShapeType.BAR, FractionsIntroSimSharing.Components.barShapeRadioButton));
        Property<ShapeType> property = new Property<ShapeType>(ShapeType.PIE);
        property.addObserver(new VoidFunction1<ShapeType>(){

            @Override
            public void apply(ShapeType shapeType) {
                if (shapeType == ShapeType.BAR) {
                    FractionLabCanvas.this.setEnabled(shapeSceneNode, false);
                    FractionLabCanvas.this.setEnabled(shapeSceneNode2, true);
                } else {
                    FractionLabCanvas.this.setEnabled(shapeSceneNode, true);
                    FractionLabCanvas.this.setEnabled(shapeSceneNode2, false);
                }
            }
        });
        RadioButtonStripControlPanelNode<ShapeType> radioButtonStripControlPanelNode = new RadioButtonStripControlPanelNode<ShapeType>(property, list, 3, Color.white, new BasicStroke(1.0f), Color.black, 8, 2.0, 3.0);
        this.addChild(new VBox(new PNode[]{radioButtonStripControlPanelNode, new ResetAllButtonNode(new Resettable(){

            public void reset() {
                fractionLabCanvasContext.resetCanvas();
            }
        }, this, 18, Color.black, RefreshButtonNode.BUTTON_COLOR){
            {
                this.setConfirmationEnabled(false);
            }
        }}){
            {
                this.setOffset(AbstractFractionsCanvas.STAGE_SIZE.width - this.getFullBounds().getWidth() - 10.0, 150.0);
            }
        });
    }

    private void setEnabled(SceneNode<?> sceneNode, boolean bl) {
        sceneNode.setToolboxEnabled(bl);
    }

    private BuildAFractionModel createModel(final ShapeType shapeType, final Color color) {
        return new BuildAFractionModel(new BooleanProperty(false), new BooleanProperty(false), new ShapeLevelFactory(){

            public ShapeLevel createLevel(int n) {
                MixedFraction mixedFraction = MixedFraction.mixedFraction(3, Fraction.fraction(1, 2));
                return new ShapeLevel(List.range(1, 9).append(List.range(1, 9)), List.list(mixedFraction, mixedFraction), color, shapeType, false);
            }
        }, new NumberLevelFactory(){

            public NumberLevel createLevel(int n) {
                NumberTarget numberTarget = NumberTarget.target(1, 2, Color.blue, NumberLevelList.pie.sequential());
                return new NumberLevel(List.range(1, 9).append(List.range(1, 9)), List.list(numberTarget, numberTarget));
            }
        });
    }
}

