/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.piccolophet.activities.PActivityDelegateAdapter;
import edu.colorado.phet.fractions.buildafraction.model.BuildAFractionModel;
import edu.colorado.phet.fractions.buildafraction.view.AbstractLevelSelectionNode;
import edu.colorado.phet.fractions.buildafraction.view.DisablePickingWhileAnimating;
import edu.colorado.phet.fractions.buildafraction.view.LevelIdentifier;
import edu.colorado.phet.fractions.buildafraction.view.LevelInfo;
import edu.colorado.phet.fractions.buildafraction.view.LevelSelectionContext;
import edu.colorado.phet.fractions.buildafraction.view.LevelSelectionNode;
import edu.colorado.phet.fractions.buildafraction.view.LevelType;
import edu.colorado.phet.fractions.buildafraction.view.MixedNumbersLevelSelectionNode;
import edu.colorado.phet.fractions.buildafraction.view.SceneContext;
import edu.colorado.phet.fractions.buildafraction.view.numbers.NumberSceneNode;
import edu.colorado.phet.fractions.buildafraction.view.shapes.CompositeDelegate;
import edu.colorado.phet.fractions.buildafraction.view.shapes.ShapeSceneNode;
import edu.colorado.phet.fractions.common.view.AbstractFractionsCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PInterpolatingActivity;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.HashMap;

public class BuildAFractionCanvas
extends AbstractFractionsCanvas
implements LevelSelectionContext,
SceneContext {
    public static final Paint TRANSPARENT = new Color(0, 0, 0, 0);
    public static final Stroke CONTROL_PANEL_STROKE = new BasicStroke(2.0f);
    private PNode currentScene;
    private final BuildAFractionModel model;
    private final HashMap<LevelIdentifier, PNode> levelMap = new HashMap();
    private final String title;
    public static final Color LIGHT_BLUE = new Color(236, 251, 251);

    public BuildAFractionCanvas(BuildAFractionModel buildAFractionModel, String string) {
        this.model = buildAFractionModel;
        this.title = string;
        this.setBackground(LIGHT_BLUE);
        this.currentScene = this.createLevelSelectionNode();
        this.addChild(this.currentScene);
    }

    private void crossFadeTo(final PNode pNode) {
        pNode.setTransparency(0.0f);
        this.addChild(pNode);
        final PNode pNode2 = this.currentScene;
        PInterpolatingActivity pInterpolatingActivity = pNode2.animateToTransparency(0.0f, 500L);
        pInterpolatingActivity.setDelegate(new PActivityDelegateAdapter(){

            public void activityFinished(PActivity pActivity) {
                pNode2.removeFromParent();
                pNode.animateToTransparency(1.0f, 500L);
            }
        });
        this.currentScene = pNode;
    }

    private void animateTo(PNode pNode, Direction direction) {
        pNode.setTransparency(1.0f);
        Vector2D vector2D = direction == Direction.RIGHT ? new Vector2D(BuildAFractionCanvas.STAGE_SIZE.width, 0.0) : (direction == Direction.LEFT ? new Vector2D(-BuildAFractionCanvas.STAGE_SIZE.width, 0.0) : (direction == Direction.DOWN ? new Vector2D(0.0, BuildAFractionCanvas.STAGE_SIZE.height) : Vector2D.ZERO));
        pNode.setOffset(vector2D.toPoint2D());
        this.addChild(pNode);
        final PNode pNode2 = this.currentScene;
        Vector2D vector2D2 = direction == Direction.RIGHT ? new Vector2D(-BuildAFractionCanvas.STAGE_SIZE.width, 0.0) : (direction == Direction.LEFT ? new Vector2D(BuildAFractionCanvas.STAGE_SIZE.width, 0.0) : (direction == Direction.DOWN ? new Vector2D(0.0, -BuildAFractionCanvas.STAGE_SIZE.height) : Vector2D.ZERO));
        PTransformActivity pTransformActivity = this.currentScene.animateToPositionScaleRotation(vector2D2.x, vector2D2.y, 1.0, 0.0, 400L);
        pTransformActivity.setDelegate(new CompositeDelegate(new PActivityDelegateAdapter(){

            public void activityFinished(PActivity pActivity) {
                PInterpolatingActivity pInterpolatingActivity = pNode2.animateToTransparency(0.0f, 200L);
                pInterpolatingActivity.setDelegate(new PActivityDelegateAdapter(){

                    public void activityFinished(PActivity pActivity) {
                        pNode2.removeFromParent();
                    }
                });
            }
        }, new DisablePickingWhileAnimating(this.currentScene, true)));
        pNode.animateToPositionScaleRotation(0.0, 0.0, 1.0, 0.0, 400L);
        this.currentScene = pNode;
    }

    public void levelButtonPressed(LevelInfo levelInfo) {
        this.animateTo(this.levelNode(levelInfo.levelIdentifier), Direction.RIGHT);
    }

    private PNode levelNode(LevelIdentifier levelIdentifier) {
        if (!this.levelMap.containsKey(levelIdentifier)) {
            this.levelMap.put(levelIdentifier, this.createLevelNode(levelIdentifier.levelIndex, levelIdentifier.levelType));
        }
        return this.levelMap.get(levelIdentifier);
    }

    public void reset() {
        this.model.resetAll();
        this.levelMap.clear();
        this.crossFadeTo(this.createLevelSelectionNode());
    }

    private AbstractLevelSelectionNode createLevelSelectionNode() {
        return this.model.isMixedNumbers() ? new MixedNumbersLevelSelectionNode(this.title, this, this.model.audioEnabled, this.model.selectedPage, this.model.gameProgress) : new LevelSelectionNode(this.title, this, this.model.audioEnabled, this.model.selectedPage, this.model.gameProgress);
    }

    public Component getComponent() {
        return this;
    }

    private PNode createLevelNode(int n, LevelType levelType) {
        return levelType == LevelType.SHAPES ? new ShapeSceneNode(n, this.model, this, this.model.audioEnabled, false, true) : new NumberSceneNode(n, this.rootNode, this.model, this, this.model.audioEnabled, false);
    }

    public void goToShapeLevel(int n) {
        this.animateTo(this.levelNode(new LevelIdentifier(n, LevelType.SHAPES)), Direction.RIGHT);
    }

    public void goToNumberLevel(int n) {
        this.animateTo(this.levelNode(new LevelIdentifier(n, LevelType.NUMBERS)), Direction.RIGHT);
    }

    public void goToLevelSelectionScreen(int n) {
        this.model.selectedPage.set(n < 5 ? 0 : 1);
        this.animateTo(this.createLevelSelectionNode(), Direction.LEFT);
    }

    public void resampleShapeLevel(int n) {
        this.model.resampleShapeLevel(n);
        PNode pNode = this.createLevelNode(n, LevelType.SHAPES);
        this.levelMap.put(new LevelIdentifier(n, LevelType.SHAPES), pNode);
        this.crossFadeTo(pNode);
    }

    public void resampleNumberLevel(int n) {
        this.model.resampleNumberLevel(n);
        PNode pNode = this.createLevelNode(n, LevelType.NUMBERS);
        this.levelMap.put(new LevelIdentifier(n, LevelType.NUMBERS), pNode);
        this.crossFadeTo(pNode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction RIGHT = new Direction();
        public static final /* enum */ Direction LEFT = new Direction();
        public static final /* enum */ Direction DOWN = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        static {
            $VALUES = new Direction[]{RIGHT, LEFT, DOWN};
        }
    }
}

