/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.model.shapes;

import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.functionaljava.FJUtils;
import edu.colorado.phet.fractions.buildafraction.model.ShapeLevelFactory;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberLevelList;
import edu.colorado.phet.fractions.buildafraction.model.shapes.ShapeLevel;
import edu.colorado.phet.fractions.buildafraction.model.shapes.ShapeType;
import edu.colorado.phet.fractions.buildafraction.view.LevelSelectionNode;
import edu.colorado.phet.fractions.common.math.Fraction;
import edu.colorado.phet.fractions.common.util.Distribution;
import edu.colorado.phet.fractions.common.util.Sampling;
import fj.F;
import fj.Ord;
import fj.P2;
import fj.data.List;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeLevelList
implements ShapeLevelFactory {
    private static final Random random = new Random();
    private final ArrayList<Function0<ShapeLevel>> levels = new ArrayList();

    public ShapeLevelList() {
        final boolean bl = random.nextBoolean();
        final boolean bl2 = random.nextBoolean();
        this.addWithPostprocessing(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return ShapeLevelList.this.level1(bl);
            }
        });
        this.addWithPostprocessing(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return ShapeLevelList.this.level2(!bl);
            }
        });
        this.addWithPostprocessing(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return ShapeLevelList.this.level3(bl2);
            }
        });
        this.addWithPostprocessing(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return ShapeLevelList.this.level4(!bl2);
            }
        });
        this.addWithPostprocessing(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return ShapeLevelList.this.level5();
            }
        });
        this.addWithPostprocessing(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return ShapeLevelList.this.level6();
            }
        });
        this.addWithPostprocessing(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return ShapeLevelList.this.level7();
            }
        });
        this.addWithPostprocessing(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return ShapeLevelList.this.level8();
            }
        });
        this.addWithPostprocessing(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return ShapeLevelList.this.level9();
            }
        });
        this.addWithPostprocessing(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return ShapeLevelList.level10();
            }
        });
    }

    @Override
    public ShapeLevel createLevel(int n) {
        return this.levels.get(n).apply();
    }

    private void addWithPostprocessing(Function0<ShapeLevel> function0) {
        this.levels.add(this.withProcessing(function0));
    }

    private Function0<ShapeLevel> withProcessing(final Function0<ShapeLevel> function0) {
        return new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                for (int i = 0; i < 100; ++i) {
                    ShapeLevel shapeLevel = (ShapeLevel)function0.apply();
                    if (shapeLevel.getNumberOfStacks() >= 6 || shapeLevel.getNumberOfCardsInHighestStack() >= 8) continue;
                    return shapeLevel;
                }
                return (ShapeLevel)function0.apply();
            }
        };
    }

    private ShapeLevel level1(boolean bl) {
        Distribution<Fraction> distribution = new Distribution<Fraction>(List.list(Fraction.fraction(1, 1), Fraction.fraction(2, 2), Fraction.fraction(3, 3)));
        Distribution<Fraction> distribution2 = new Distribution<Fraction>(List.list(Fraction.fraction(1, 2), Fraction.fraction(1, 3), Fraction.fraction(2, 3)));
        Fraction fraction = distribution.draw();
        Fraction fraction2 = distribution2.drawAndRemove();
        Fraction fraction3 = distribution2.draw();
        return ShapeLevel.shapeLevel(List.list(1, 1, 2, 2, 3, 3, 3), NumberLevelList.shuffle(List.list(fraction, fraction2, fraction3)), LevelSelectionNode.colors[0], ShapeLevelList.booleanToShape(bl));
    }

    private ShapeLevel level2(boolean bl) {
        List<Fraction> list = Sampling.choose(3, List.list(Fraction.fraction(1, 2), Fraction.fraction(1, 3), Fraction.fraction(1, 4), Fraction.fraction(1, 5), Fraction.fraction(2, 3), Fraction.fraction(2, 4), Fraction.fraction(2, 5), Fraction.fraction(3, 4), Fraction.fraction(3, 5), Fraction.fraction(4, 5)));
        return ShapeLevel.shapeLevel(ShapeLevelList.straightforwardCards(list).append(ShapeLevelList.interestingShapesForOne(Sampling.chooseOne(list))), list, LevelSelectionNode.colors[1], ShapeLevelList.booleanToShape(bl));
    }

    private static List<Integer> straightforwardCards(List<Fraction> list) {
        List<Integer> list2 = List.nil();
        for (Fraction fraction : list) {
            for (int i = 0; i < fraction.numerator; ++i) {
                list2 = list2.snoc(fraction.denominator);
            }
        }
        return list2;
    }

    private static List<Integer> createCardsSameNumberEachType(List<Fraction> list) {
        Integer n = list.map(Fraction._numerator).maximum(Ord.intOrd);
        List<Integer> list2 = List.nil();
        for (Fraction fraction : list) {
            for (int i = 0; i < n; ++i) {
                list2 = list2.snoc(fraction.denominator);
            }
        }
        return list2;
    }

    private ShapeLevel level3(boolean bl) {
        List<Fraction> list = List.list(Fraction.fraction(1, 1), Fraction.fraction(1, 2), Fraction.fraction(1, 3), Fraction.fraction(1, 4), Fraction.fraction(1, 5), Fraction.fraction(1, 6), Fraction.fraction(2, 2), Fraction.fraction(2, 3), Fraction.fraction(2, 4), Fraction.fraction(2, 5), Fraction.fraction(2, 6), Fraction.fraction(3, 3), Fraction.fraction(3, 4), Fraction.fraction(3, 5), Fraction.fraction(3, 6), Fraction.fraction(4, 4), Fraction.fraction(4, 5), Fraction.fraction(4, 6), Fraction.fraction(5, 5), Fraction.fraction(5, 6), Fraction.fraction(6, 6));
        List<Fraction> list2 = Sampling.choose(3, list);
        return ShapeLevel.shapeLevel(ShapeLevelList.createCardsSameNumberEachType(list2), list2, LevelSelectionNode.colors[2], ShapeLevelList.booleanToShape(bl));
    }

    private ShapeLevel level4(boolean bl) {
        return random.nextBoolean() ? this.halfLevel4(bl) : this.wholesLevel4(bl);
    }

    private ShapeLevel wholesLevel4(boolean bl) {
        return ShapeLevel.shapeLevel(List.list(2, 2, 2, 3, 3, 3, 4, 4, 4, 6, 6, 6), List.replicate(3, Fraction.fraction(1, 1)), LevelSelectionNode.colors[3], ShapeLevelList.booleanToShape(bl));
    }

    private ShapeLevel halfLevel4(boolean bl) {
        return ShapeLevel.shapeLevel(List.list(2, 3, 3, 3, 4, 4, 4, 6, 6, 6), List.replicate(3, Fraction.fraction(1, 2)), LevelSelectionNode.colors[3], ShapeLevelList.booleanToShape(bl));
    }

    private ShapeLevel level5() {
        List<Integer> list = List.range(1, 9);
        List<Integer> list2 = Sampling.choose(3, list);
        List<Fraction> list3 = list2.map(new F<Integer, Fraction>(){

            @Override
            public Fraction f(Integer n) {
                return new Fraction(Sampling.chooseOne(List.range(1, n + 1)), n);
            }
        });
        return ShapeLevel.shapeLevel(ShapeLevelList.straightforwardCards(list3).append(ShapeLevelList.interestingShapesForOne(Sampling.chooseOne(list3))), list3, LevelSelectionNode.colors[4], ShapeType.PIE);
    }

    private ShapeLevel level6() {
        ShapeLevel shapeLevel = this.sampleLevel6();
        if (!shapeLevel.hasValuesGreaterThanOne()) {
            return shapeLevel;
        }
        return this.level6();
    }

    private ShapeLevel sampleLevel6() {
        final List list = Sampling.chooseOne(List.list(List.list(2, 3), List.list(2, 4), List.list(3, 4), List.list(2, 6), List.list(3, 6), List.list(4, 8), List.list(2, 8)));
        List<CoefficientPair> list2 = List.list(new CoefficientPair(0, 1), new CoefficientPair(1, 0), new CoefficientPair(1, 1), new CoefficientPair(1, 2), new CoefficientPair(2, 1), new CoefficientPair(2, 2), new CoefficientPair(3, 1), new CoefficientPair(1, 3));
        List<CoefficientPair> list3 = Sampling.choose(4, list2);
        List<Fraction> list4 = list3.map(new F<CoefficientPair, Fraction>(){

            @Override
            public Fraction f(CoefficientPair coefficientPair) {
                Fraction fraction = new Fraction(coefficientPair.n, (Integer)list.index(0));
                Fraction fraction2 = new Fraction(coefficientPair.m, (Integer)list.index(1));
                return fraction.plus(fraction2).reduce();
            }
        });
        List<Integer> list5 = List.nil();
        for (CoefficientPair coefficientPair : list3) {
            list5 = list5.append(List.replicate(coefficientPair.n, list.index(0)));
            list5 = list5.append(List.replicate(coefficientPair.m, list.index(1)));
        }
        return ShapeLevel.shapeLevel(list5, list4, LevelSelectionNode.colors[5], ShapeLevelList.choosePiesOrBars());
    }

    ShapeLevel level7() {
        List<Fraction> list = List.list(new Fraction(1, 2), new Fraction(1, 3), new Fraction(2, 3), new Fraction(1, 4), new Fraction(3, 4), new Fraction(5, 6), new Fraction(3, 8), new Fraction(5, 8));
        P2<Fraction, Fraction> p2 = Sampling.chooseTwo(list);
        List<Fraction> list2 = List.list(p2._1(), p2._1(), p2._2(), p2._2());
        ArrayList<List<Integer>> arrayList = ShapeLevelList.getCoefficientSets(p2._1());
        List<List<Integer>> list3 = Sampling.choose(2, List.iterableList(arrayList));
        ArrayList<List<Integer>> arrayList2 = ShapeLevelList.getCoefficientSets(p2._2());
        List<List<Integer>> list4 = Sampling.choose(2, List.iterableList(arrayList2));
        List<Integer> list5 = ShapeLevelList.coefficientsToShapes(list3.append(list4));
        return ShapeLevel.shapeLevel(list5, list2, LevelSelectionNode.colors[6], ShapeType.PIE);
    }

    private static List<Integer> coefficientsToShapes(List<List<Integer>> list) {
        List<Integer> list2 = List.nil();
        for (List<Integer> list3 : list) {
            for (int i = 0; i < list3.length(); ++i) {
                int n = i + 1;
                int n2 = list3.index(i);
                for (int j = 0; j < n2; ++j) {
                    list2 = list2.snoc(n);
                }
            }
        }
        return list2;
    }

    public static ArrayList<List<Integer>> getCoefficientSets(Fraction fraction) {
        List<Integer> list = List.range(0, 9);
        ArrayList<List<Integer>> arrayList = new ArrayList<List<Integer>>();
        for (int n : list) {
            Fraction fraction2 = new Fraction(n, 1);
            if (!fraction2.lessThanOrEqualTo(fraction)) continue;
            for (int n2 : list) {
                Fraction fraction3 = fraction2.plus(new Fraction(n2, 2));
                if (!fraction3.lessThanOrEqualTo(fraction)) continue;
                for (int n3 : list) {
                    Fraction fraction4 = fraction3.plus(new Fraction(n3, 3));
                    if (!fraction4.lessThanOrEqualTo(fraction)) continue;
                    for (int n4 : list) {
                        Fraction fraction5 = fraction4.plus(new Fraction(n4, 4));
                        if (!fraction5.lessThanOrEqualTo(fraction)) continue;
                        for (int n5 : list) {
                            Fraction fraction6 = fraction5.plus(new Fraction(n5, 5));
                            if (!fraction6.lessThanOrEqualTo(fraction)) continue;
                            for (int n6 : list) {
                                Fraction fraction7 = fraction6.plus(new Fraction(n6, 6));
                                if (!fraction7.lessThanOrEqualTo(fraction)) continue;
                                for (int n7 : list) {
                                    Fraction fraction8 = fraction7.plus(new Fraction(n7, 7));
                                    if (!fraction8.lessThanOrEqualTo(fraction)) continue;
                                    for (int n8 : list) {
                                        Fraction fraction9 = fraction8.plus(new Fraction(n8, 8));
                                        if (!fraction9.valueEquals(fraction)) continue;
                                        arrayList.add(List.list(n, n2, n3, n4, n5, n6, n7, n8));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return arrayList;
    }

    ShapeLevel level8() {
        List<Fraction> list = this.level8Targets();
        return ShapeLevel.shapeLevel(ShapeLevelList.interestingShapes(list, 5), NumberLevelList.shuffle(list), LevelSelectionNode.colors[7], ShapeLevelList.choosePiesOrBars());
    }

    private List<Fraction> level8Targets() {
        List<Fraction> list = Sampling.choose(2, List.list(new Fraction(3, 2), new Fraction(4, 2), new Fraction(5, 4), new Fraction(7, 4)));
        List<Fraction> list2 = Sampling.choose(2, List.list(new Fraction(2, 3), new Fraction(3, 4), new Fraction(2, 5), new Fraction(3, 5), new Fraction(4, 5)));
        return list.append(list2);
    }

    ShapeLevel level9() {
        List<Fraction> list = this.level8Targets();
        return ShapeLevel.shapeLevel(ShapeLevelList.interestingShapes(list, 5), NumberLevelList.shuffle(list), LevelSelectionNode.colors[8], ShapeLevelList.choosePiesOrBars());
    }

    private static ShapeLevel level10() {
        List<Fraction> list = List.list(new Fraction(3, 2), new Fraction(4, 3), new Fraction(5, 3), new Fraction(5, 4), new Fraction(7, 4), new Fraction(6, 5), new Fraction(7, 5), new Fraction(8, 5), new Fraction(9, 5), new Fraction(7, 6));
        P2<Fraction, Fraction> p2 = Sampling.chooseTwo(list);
        List<Fraction> list2 = List.list(p2._1(), p2._1(), p2._2(), p2._2());
        return ShapeLevel.shapeLevel(ShapeLevelList.interestingShapes(list2, 5), list2, LevelSelectionNode.colors[9], ShapeLevelList.choosePiesOrBars());
    }

    public static List<Integer> interestingShapes(List<Fraction> list, int n) {
        List<Integer> list2 = List.nil();
        for (Fraction fraction : list) {
            list2 = list2.append(ShapeLevelList.interestingShapesForOne(fraction, n));
        }
        return list2;
    }

    private static List<Integer> interestingShapesForOne(Fraction fraction) {
        return ShapeLevelList.interestingShapesForOne(fraction, 5);
    }

    private static List<Integer> interestingShapesForOne(Fraction fraction, int n) {
        List<List<Integer>> list = List.iterableList(ShapeLevelList.getCoefficientSets(fraction));
        List<List<Integer>> list2 = list.filter(new F<List<Integer>, Boolean>(){

            @Override
            public Boolean f(List<Integer> list) {
                return ShapeLevelList.numberOfNonzeroElements(list) > 1;
            }
        });
        List<List<Integer>> list3 = ShapeLevelList.selectSolutionsWithSmallNumberOfCards(list2.length() == 0 ? list : list2, n);
        List<Integer> list4 = Sampling.chooseOne(list3);
        return ShapeLevelList.coefficientsToShapes(List.single(list4));
    }

    private static List<List<Integer>> selectSolutionsWithSmallNumberOfCards(List<List<Integer>> list, int n) {
        List<List<Integer>> list2 = list.sort(FJUtils.ord(new F<List<Integer>, Double>(){

            @Override
            public Double f(List<Integer> list) {
                return (double)ShapeLevelList.coefficientsToShapes(List.single(list)).length() + 0.0;
            }
        }));
        return list2.take(n);
    }

    private static int numberOfNonzeroElements(List<Integer> list) {
        return list.filter(new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n) {
                return n != 0;
            }
        }).length();
    }

    public static ShapeType choosePiesOrBars() {
        return ShapeLevelList.booleanToShape(random.nextBoolean());
    }

    private static ShapeType booleanToShape(boolean bl) {
        return bl ? ShapeType.PIE : ShapeType.BAR;
    }

    public static class CoefficientPair {
        public final int n;
        public final int m;

        @ConstructorProperties(value={"n", "m"})
        public CoefficientPair(int n, int n2) {
            this.n = n;
            this.m = n2;
        }

        public int getN() {
            return this.n;
        }

        public int getM() {
            return this.m;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CoefficientPair)) {
                return false;
            }
            CoefficientPair coefficientPair = (CoefficientPair)object;
            if (!coefficientPair.canEqual(this)) {
                return false;
            }
            if (this.getN() != coefficientPair.getN()) {
                return false;
            }
            return this.getM() == coefficientPair.getM();
        }

        public boolean canEqual(Object object) {
            return object instanceof CoefficientPair;
        }

        public int hashCode() {
            int n = 1;
            n = n * 31 + this.getN();
            n = n * 31 + this.getM();
            return n;
        }

        public String toString() {
            return "ShapeLevelList.CoefficientPair(n=" + this.getN() + ", m=" + this.getM() + ")";
        }
    }
}

