/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.model.shapes;

import edu.colorado.phet.fractions.buildafraction.model.Level;
import edu.colorado.phet.fractions.buildafraction.model.MixedFraction;
import edu.colorado.phet.fractions.buildafraction.model.shapes.ShapeType;
import edu.colorado.phet.fractions.common.math.Fraction;
import fj.Equal;
import fj.F;
import fj.Ord;
import fj.data.List;
import fj.function.Doubles;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeLevel
extends Level {
    public final List<MixedFraction> targets;
    public final List<Integer> pieces;
    public final Color color;
    public final ShapeType shapeType;

    public static ShapeLevel shapeLevelMixed(List<Integer> list, List<MixedFraction> list2, Color color, ShapeType shapeType) {
        return new ShapeLevel(list, list2, color, shapeType, true);
    }

    public static ShapeLevel shapeLevel(List<Integer> list, List<Fraction> list2, Color color, ShapeType shapeType) {
        return new ShapeLevel(list, list2.map(MixedFraction._toMixedFraction), color, shapeType, true);
    }

    public ShapeLevel(List<Integer> list, List<MixedFraction> list2, Color color, ShapeType shapeType, boolean bl) {
        super(list2);
        this.targets = list2;
        this.pieces = list.sort(Ord.intOrd);
        this.color = color;
        this.shapeType = shapeType;
        if (bl) {
            double d = list2.map(MixedFraction._toDouble).foldLeft(Doubles.add, Double.valueOf(0.0));
            double d2 = list.map(new F<Integer, Double>(){

                @Override
                public Double f(Integer n) {
                    return 1.0 / (double)n.intValue();
                }
            }).foldLeft(Doubles.add, Double.valueOf(0.0));
            assert (d2 >= d - 1.0E-6);
        }
    }

    public MixedFraction getTarget(int n) {
        return this.targets.index(n);
    }

    public boolean hasValuesGreaterThanOne() {
        return this.targets.exists(MixedFraction._greaterThanOne);
    }

    public int getNumberOfStacks() {
        return this.getStacks().length();
    }

    private List<List<Integer>> getStacks() {
        return this.pieces.group(Equal.intEqual);
    }

    public int getNumberOfCardsInHighestStack() {
        return this.getStacks().map(List.length_()).maximum(Ord.intOrd);
    }

    public int getMaxNumberOfSingleContainers() {
        return (int)Math.ceil(this.targets.map(MixedFraction._toDouble).maximum(Ord.doubleOrd));
    }
}

