/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.model.shapes;

import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.fractions.buildafraction.model.MixedFraction;
import edu.colorado.phet.fractions.buildafraction.model.ShapeLevelFactory;
import edu.colorado.phet.fractions.buildafraction.model.numbers.MixedNumbersNumberLevelList;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberLevelList;
import edu.colorado.phet.fractions.buildafraction.model.shapes.ShapeLevel;
import edu.colorado.phet.fractions.buildafraction.model.shapes.ShapeLevelList;
import edu.colorado.phet.fractions.buildafraction.view.MixedNumbersLevelSelectionNode;
import edu.colorado.phet.fractions.common.math.Fraction;
import edu.colorado.phet.fractions.common.util.Sampling;
import fj.Equal;
import fj.F;
import fj.Unit;
import fj.data.List;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixedNumbersShapeLevelList
implements ShapeLevelFactory {
    private final ArrayList<Function0<ShapeLevel>> levels = new ArrayList();

    public MixedNumbersShapeLevelList() {
        this.add(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return MixedNumbersShapeLevelList.this.level1();
            }
        });
        this.add(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return MixedNumbersShapeLevelList.this.level2();
            }
        });
        this.add(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return MixedNumbersShapeLevelList.this.level3();
            }
        });
        this.add(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                for (int i = 0; i < 100; ++i) {
                    ShapeLevel shapeLevel = MixedNumbersShapeLevelList.this.level4();
                    if (shapeLevel.getNumberOfCardsInHighestStack() > 6) continue;
                    return shapeLevel;
                }
                return MixedNumbersShapeLevelList.this.level4();
            }
        });
        this.add(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return MixedNumbersShapeLevelList.this.level5();
            }
        });
        this.add(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return MixedNumbersShapeLevelList.this.level6();
            }
        });
        this.add(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return MixedNumbersShapeLevelList.this.level7();
            }
        });
        this.add(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return MixedNumbersShapeLevelList.this.level8();
            }
        });
        this.add(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return MixedNumbersShapeLevelList.this.level9();
            }
        });
        this.add(new Function0<ShapeLevel>(){

            @Override
            public ShapeLevel apply() {
                return MixedNumbersShapeLevelList.this.level10();
            }
        });
    }

    private void add(Function0<ShapeLevel> function0) {
        this.levels.add(function0);
    }

    @Override
    public ShapeLevel createLevel(int n) {
        return this.levels.get(n).apply();
    }

    private ShapeLevel level1() {
        List<MixedFraction> list = NumberLevelList.shuffle(List.list(new MixedFraction(1, 1, 2), new MixedFraction(2, 1, 2), new MixedFraction(2, 1, 4)));
        return ShapeLevel.shapeLevelMixed(this.addSubdividedCards(MixedNumbersShapeLevelList.straightforwardCards(list), 2), list, MixedNumbersLevelSelectionNode.colors[0], ShapeLevelList.choosePiesOrBars());
    }

    private ShapeLevel level2() {
        List<MixedFraction> list = Sampling.choose(3, MixedNumbersNumberLevelList.getMixedFractions(List.list(1, 2), List.list(Fraction.fraction(1, 2), Fraction.fraction(1, 3), Fraction.fraction(2, 3), Fraction.fraction(1, 4), Fraction.fraction(3, 4))));
        return ShapeLevel.shapeLevelMixed(this.addSubdividedCards(MixedNumbersShapeLevelList.straightforwardCards(list), 2), NumberLevelList.shuffle(list), MixedNumbersLevelSelectionNode.colors[1], ShapeLevelList.choosePiesOrBars());
    }

    private static List<MixedFraction> chooseRestricted(F<Unit, List<MixedFraction>> f) {
        List<MixedFraction> list;
        List<MixedFraction> list2;
        while ((list2 = (list = f.f(Unit.unit())).filter(new F<MixedFraction, Boolean>(){

            @Override
            public Boolean f(MixedFraction mixedFraction) {
                return mixedFraction.whole == 3;
            }
        })).length() > 1) {
        }
        return list;
    }

    private ShapeLevel level3() {
        List<MixedFraction> list = MixedNumbersShapeLevelList.chooseRestricted(new F<Unit, List<MixedFraction>>(){

            @Override
            public List<MixedFraction> f(Unit unit) {
                return Sampling.choose(3, MixedNumbersNumberLevelList.getMixedFractions(List.list(1, 2, 3), List.list(Fraction.fraction(1, 2), Fraction.fraction(1, 3), Fraction.fraction(2, 3), Fraction.fraction(1, 4), Fraction.fraction(3, 4), Fraction.fraction(1, 6), Fraction.fraction(5, 6))));
            }
        });
        return ShapeLevel.shapeLevelMixed(this.addSubdividedCards(this.addSubdividedCards(MixedNumbersShapeLevelList.straightforwardCards(list), 3), 3), NumberLevelList.shuffle(list), MixedNumbersLevelSelectionNode.colors[2], ShapeLevelList.choosePiesOrBars());
    }

    private ShapeLevel level4() {
        List<MixedFraction> list = List.replicate(3, Sampling.chooseOne(MixedNumbersNumberLevelList.getMixedFractions(List.list(1, 2), List.list(Fraction.fraction(1, 2), Fraction.fraction(1, 3), Fraction.fraction(2, 3), Fraction.fraction(1, 4), Fraction.fraction(3, 4)))));
        List<Integer> list2 = this.substituteSubdividedCards(this.substituteSubdividedCards3(MixedNumbersShapeLevelList.straightforwardCards(list), 1), 1);
        while (this.count(list2, 2) > 5) {
            list2 = this.substituteSubdividedCardsExact(list2, 2);
        }
        while (this.count(list2, 3) > 5) {
            list2 = this.substituteSubdividedCardsExact(list2, 3);
        }
        while (this.count(list2, 4) > 6) {
            list2 = this.substituteSubdividedCardsExact(list2, 4);
        }
        return ShapeLevel.shapeLevelMixed(list2, NumberLevelList.shuffle(list), MixedNumbersLevelSelectionNode.colors[3], ShapeLevelList.choosePiesOrBars());
    }

    private int count(List<Integer> list, final int n) {
        return list.filter(new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n2) {
                return n2 == n;
            }
        }).length();
    }

    private ShapeLevel level5() {
        List<MixedFraction> list = MixedNumbersShapeLevelList.chooseRestricted(new F<Unit, List<MixedFraction>>(){

            @Override
            public List<MixedFraction> f(Unit unit) {
                return Sampling.choose(3, MixedNumbersNumberLevelList.getMixedFractions(List.list(1, 2, 3), MixedNumbersNumberLevelList.parse("1/2, 1/3, 2/3, 1/4, 3/4, 1/5, 2/5, 3/5, 4/5, 1/6, 5/6, 1/7, 2/7, 3/7, 4/7, 5/7, 6/7, 1/8, 3/8, 5/8, 7/8")));
            }
        });
        return ShapeLevel.shapeLevelMixed(this.substituteSubdividedCards(this.addSubdividedCards(this.substituteSubdividedCards(MixedNumbersShapeLevelList.straightforwardCards(list), 4), 4), 4), NumberLevelList.shuffle(list), MixedNumbersLevelSelectionNode.colors[4], ShapeLevelList.choosePiesOrBars());
    }

    private ShapeLevel level6() {
        return MixedNumbersNumberLevelList.random.nextBoolean() ? this.level6A() : this.level6B();
    }

    private ShapeLevel level6A() {
        List<MixedFraction> list = MixedNumbersShapeLevelList.chooseRestricted(new F<Unit, List<MixedFraction>>(){

            @Override
            public List<MixedFraction> f(Unit unit) {
                return Sampling.choose(4, MixedNumbersNumberLevelList.getMixedFractions(List.list(1, 2, 3), MixedNumbersNumberLevelList.parse("1/2, 1/3, 2/3, 1/6, 5/6")));
            }
        });
        return ShapeLevel.shapeLevelMixed(ShapeLevelList.interestingShapes(list.map(MixedFraction._toFraction), 1), NumberLevelList.shuffle(list), MixedNumbersLevelSelectionNode.colors[5], ShapeLevelList.choosePiesOrBars());
    }

    private ShapeLevel level6B() {
        List<MixedFraction> list = MixedNumbersShapeLevelList.chooseRestricted(new F<Unit, List<MixedFraction>>(){

            @Override
            public List<MixedFraction> f(Unit unit) {
                return Sampling.choose(4, MixedNumbersNumberLevelList.getMixedFractions(List.list(1, 2, 3), MixedNumbersNumberLevelList.parse("1/2, 1/4, 3/4, 1/8, 3/8, 5/8, 7/8")));
            }
        });
        return ShapeLevel.shapeLevelMixed(ShapeLevelList.interestingShapes(list.map(MixedFraction._toFraction), 1), NumberLevelList.shuffle(list), MixedNumbersLevelSelectionNode.colors[5], ShapeLevelList.choosePiesOrBars());
    }

    private ShapeLevel level7() {
        List<MixedFraction> list = MixedNumbersShapeLevelList.chooseRestricted(new F<Unit, List<MixedFraction>>(){

            @Override
            public List<MixedFraction> f(Unit unit) {
                return Sampling.choose(2, MixedNumbersNumberLevelList.getMixedFractions(List.list(1, 2, 3), MixedNumbersNumberLevelList.parse("1/2, 1/3, 2/3, 1/4, 3/4, 1/6, 5/6, 1/8, 3/8, 5/8, 7/8")));
            }
        });
        MixedFraction mixedFraction = list.head();
        MixedFraction mixedFraction2 = list.last();
        List<MixedFraction> list2 = List.list(mixedFraction, mixedFraction, mixedFraction2, mixedFraction2);
        List<Integer> list3 = MixedNumbersShapeLevelList.straightforwardCards(List.single(mixedFraction));
        List<Integer> list4 = MixedNumbersShapeLevelList.straightforwardCards(List.single(mixedFraction2));
        List<Integer> list5 = ShapeLevelList.interestingShapes(List.single(mixedFraction.toFraction()), 5);
        List<Integer> list6 = ShapeLevelList.interestingShapes(List.single(mixedFraction2.toFraction()), 5);
        return ShapeLevel.shapeLevelMixed(list3.append(list4).append(list5).append(list6), list2, MixedNumbersLevelSelectionNode.colors[6], ShapeLevelList.choosePiesOrBars());
    }

    private ShapeLevel level8() {
        List<MixedFraction> list = MixedNumbersShapeLevelList.chooseRestricted(new F<Unit, List<MixedFraction>>(){

            @Override
            public List<MixedFraction> f(Unit unit) {
                return Sampling.choose(4, MixedNumbersNumberLevelList.getMixedFractions(List.list(1, 2, 3), MixedNumbersNumberLevelList.parse("1/2, 1/3, 2/3, 1/4, 3/4, 1/5, 2/5, 3/5, 4/5, 1/6, 5/6")));
            }
        });
        return ShapeLevel.shapeLevelMixed(ShapeLevelList.interestingShapes(list.take(2).map(MixedFraction._toFraction), 5).append(MixedNumbersShapeLevelList.straightforwardCards(list.reverse().take(2))), NumberLevelList.shuffle(list), MixedNumbersLevelSelectionNode.colors[7], ShapeLevelList.choosePiesOrBars());
    }

    private ShapeLevel level9() {
        List<MixedFraction> list = MixedNumbersShapeLevelList.chooseRestricted(new F<Unit, List<MixedFraction>>(){

            @Override
            public List<MixedFraction> f(Unit unit) {
                return Sampling.choose(4, MixedNumbersNumberLevelList.getMixedFractions(List.list(1, 2, 3), MixedNumbersNumberLevelList.parse("1/2, 1/3, 2/3, 1/4, 3/4, 1/5, 2/5, 3/5, 4/5, 1/6, 5/6")));
            }
        });
        return ShapeLevel.shapeLevelMixed(ShapeLevelList.interestingShapes(list.map(MixedFraction._toFraction), 5), NumberLevelList.shuffle(list), MixedNumbersLevelSelectionNode.colors[8], ShapeLevelList.choosePiesOrBars());
    }

    private ShapeLevel level10() {
        List<MixedFraction> list = MixedNumbersShapeLevelList.chooseRestricted(new F<Unit, List<MixedFraction>>(){

            @Override
            public List<MixedFraction> f(Unit unit) {
                return Sampling.choose(4, MixedNumbersNumberLevelList.getMixedFractions(List.list(1, 2, 3), MixedNumbersNumberLevelList.parse("1/2, 1/3, 2/3, 1/4, 3/4, 1/6, 5/6, 1/8, 3/8, 5/8, 7/8")));
            }
        });
        return ShapeLevel.shapeLevelMixed(ShapeLevelList.interestingShapes(list.map(MixedFraction._toFraction), 5), NumberLevelList.shuffle(list), MixedNumbersLevelSelectionNode.colors[9], ShapeLevelList.choosePiesOrBars());
    }

    private List<Integer> addSubdividedCards(List<Integer> list, final int n) {
        List<Integer> list2 = list.filter(new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n2) {
                return n2 <= n;
            }
        });
        Integer n2 = Sampling.chooseOne(list2);
        List<Integer> list3 = List.list(n2 * 2, n2 * 2);
        return list.append(list3);
    }

    private List<Integer> substituteSubdividedCards(List<Integer> list, final int n) {
        List<Integer> list2 = list.filter(new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n2) {
                return n2 <= n;
            }
        });
        Integer n2 = Sampling.chooseOne(list2);
        List<Integer> list3 = List.list(n2 * 2, n2 * 2);
        return list.delete(n2, Equal.intEqual).append(list3);
    }

    private List<Integer> substituteSubdividedCardsExact(List<Integer> list, final int n) {
        List<Integer> list2 = list.filter(new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n2) {
                return n2 <= n;
            }
        });
        Integer n2 = Sampling.chooseOne(list2);
        List<Integer> list3 = List.list(n2 * 2, n2 * 2);
        return list.delete(n2, Equal.intEqual).append(list3);
    }

    private List<Integer> substituteSubdividedCards3(List<Integer> list, final int n) {
        List<Integer> list2 = list.filter(new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n2) {
                return n2 <= n;
            }
        });
        Integer n2 = Sampling.chooseOne(list2);
        List<Integer> list3 = List.list(n2 * 3, n2 * 3, n2 * 3);
        return list.delete(n2, Equal.intEqual).append(list3);
    }

    private static List<Integer> straightforwardCards(List<MixedFraction> list) {
        List<Integer> list2 = List.nil();
        for (MixedFraction mixedFraction : list) {
            for (int i = 0; i < mixedFraction.whole; ++i) {
                list2 = list2.snoc(1);
            }
            Fraction fraction = mixedFraction.getFractionPart();
            for (int i = 0; i < fraction.numerator; ++i) {
                list2 = list2.snoc(fraction.denominator);
            }
        }
        return list2;
    }
}

