/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.model.numbers;

import edu.colorado.phet.fractions.buildafraction.model.MixedFraction;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberLevelList;
import edu.colorado.phet.fractions.buildafraction.model.shapes.ShapeLevelList;
import edu.colorado.phet.fractions.common.math.Fraction;
import edu.colorado.phet.fractions.common.util.Sampling;
import edu.colorado.phet.fractions.fractionmatcher.view.FilledPattern;
import fj.Equal;
import fj.F;
import fj.data.List;
import java.awt.Color;
import java.beans.ConstructorProperties;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberTarget {
    public final MixedFraction mixedFraction;
    public final Color color;
    public final List<FilledPattern> filledPattern;
    public final F<MixedFraction, FilledPattern> representation;
    public static final F<NumberTarget, MixedFraction> _mixedFraction = new F<NumberTarget, MixedFraction>(){

        @Override
        public MixedFraction f(NumberTarget numberTarget) {
            return numberTarget.mixedFraction;
        }
    };

    public static NumberTarget target(int n, int n2, int n3, Color color, F<MixedFraction, FilledPattern> f) {
        return NumberTarget.target(new MixedFraction(n, n2, n3), color, f);
    }

    public static NumberTarget target(MixedFraction mixedFraction, Color color, F<MixedFraction, FilledPattern> f) {
        return new NumberTarget(mixedFraction, color, NumberTarget.composite(f).f(mixedFraction), f);
    }

    public static NumberTarget scatteredTarget(MixedFraction mixedFraction, Color color, F<MixedFraction, FilledPattern> f) {
        return new NumberTarget(mixedFraction, color, NumberTarget.scatteredComposite(f).f(mixedFraction), f);
    }

    public static NumberTarget shuffledTarget(MixedFraction mixedFraction, Color color, F<MixedFraction, FilledPattern> f) {
        return new NumberTarget(mixedFraction, color, NumberLevelList.shuffle(NumberTarget.composite(f).f(mixedFraction)), f);
    }

    public static NumberTarget target(int n, int n2, Color color, F<MixedFraction, FilledPattern> f) {
        return NumberTarget.target(0, n, n2, color, f);
    }

    public static NumberTarget target(Fraction fraction, Color color, F<MixedFraction, FilledPattern> f) {
        return NumberTarget.target(fraction.numerator, fraction.denominator, color, f);
    }

    private static F<MixedFraction, List<FilledPattern>> composite(final F<MixedFraction, FilledPattern> f) {
        return new F<MixedFraction, List<FilledPattern>>(){

            @Override
            public List<FilledPattern> f(MixedFraction mixedFraction) {
                FilledPattern filledPattern;
                int n;
                MixedFraction mixedFraction2 = new MixedFraction(0, mixedFraction.toFraction().numerator, mixedFraction.toFraction().denominator);
                List<FilledPattern> list = List.nil();
                int n2 = mixedFraction2.denominator;
                for (n = mixedFraction2.numerator; n > n2; n -= n2) {
                    filledPattern = (FilledPattern)f.f(new MixedFraction(0, n2, n2));
                    assert (filledPattern != null);
                    list = list.snoc(filledPattern);
                }
                if (n > 0) {
                    filledPattern = (FilledPattern)f.f(new MixedFraction(0, n, n2));
                    assert (filledPattern != null);
                    list = list.snoc(filledPattern);
                }
                assert (list != null);
                return list;
            }
        };
    }

    public static F<MixedFraction, List<FilledPattern>> scatteredComposite(final F<MixedFraction, FilledPattern> f) {
        return new F<MixedFraction, List<FilledPattern>>(){

            @Override
            public List<FilledPattern> f(MixedFraction mixedFraction) {
                Fraction fraction = mixedFraction.toFraction();
                List<List<Integer>> list = List.iterableList(ShapeLevelList.getCoefficientSets(fraction)).filter(new F<List<Integer>, Boolean>(){

                    @Override
                    public Boolean f(List<Integer> list) {
                        return !NumberTarget.overflows(list) && NumberTarget.toFilledPatterns(list, f).length() <= 4 && NumberTarget.compatibleSizes(list);
                    }
                });
                if (list.length() == 0) {
                    System.out.println("Couldn't find any solutions for f=" + mixedFraction);
                    return (List)NumberTarget.composite(f).f(mixedFraction);
                }
                List<Integer> list2 = Sampling.chooseOne(list);
                return NumberTarget.toFilledPatterns(list2, f);
            }
        };
    }

    private static boolean compatibleSizes(List<Integer> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.length(); ++i) {
            int n = i + 1;
            int n2 = list.index(i);
            if (n2 <= 0) continue;
            arrayList.add(n);
        }
        List<Integer> list2 = List.iterableList(arrayList);
        return NumberTarget.containsOnly(list2, List.list(1, 2, 4, 8)) || NumberTarget.containsOnly(list2, List.list(1, 3, 6)) || NumberTarget.containsOnly(list2, List.list(1, 2, 6));
    }

    private static boolean containsOnly(List<Integer> list, final List<Integer> list2) {
        return list.filter(new F<Integer, Boolean>(){

            @Override
            public Boolean f(Integer n) {
                return list2.elementIndex(Equal.intEqual, n).isSome();
            }
        }).length() == list.length();
    }

    private static boolean overflows(List<Integer> list) {
        for (int i = 0; i < list.length(); ++i) {
            int n = i + 1;
            int n2 = list.index(i);
            if (n2 <= 0 || n2 <= n) continue;
            return true;
        }
        return false;
    }

    private static List<FilledPattern> toFilledPatterns(List<Integer> list, F<MixedFraction, FilledPattern> f) {
        ArrayList<FilledPattern> arrayList = new ArrayList<FilledPattern>();
        for (int i = 0; i < list.length(); ++i) {
            int n = i + 1;
            int n2 = list.index(i);
            if (n2 <= 0) continue;
            FilledPattern filledPattern = f.f(new MixedFraction(0, n2, n));
            if (n2 > n) {
                throw new RuntimeException("Not going to work, the representation has more pieces than it can hold.  Will need to be filtered out");
            }
            arrayList.add(filledPattern);
        }
        return List.iterableList(arrayList);
    }

    @ConstructorProperties(value={"mixedFraction", "color", "filledPattern", "representation"})
    public NumberTarget(MixedFraction mixedFraction, Color color, List<FilledPattern> list, F<MixedFraction, FilledPattern> f) {
        this.mixedFraction = mixedFraction;
        this.color = color;
        this.filledPattern = list;
        this.representation = f;
    }

    public MixedFraction getMixedFraction() {
        return this.mixedFraction;
    }

    public Color getColor() {
        return this.color;
    }

    public List<FilledPattern> getFilledPattern() {
        return this.filledPattern;
    }

    public F<MixedFraction, FilledPattern> getRepresentation() {
        return this.representation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NumberTarget)) {
            return false;
        }
        NumberTarget numberTarget = (NumberTarget)object;
        if (!numberTarget.canEqual(this)) {
            return false;
        }
        if (this.getMixedFraction() == null ? numberTarget.getMixedFraction() != null : !this.getMixedFraction().equals(numberTarget.getMixedFraction())) {
            return false;
        }
        if (this.getColor() == null ? numberTarget.getColor() != null : !this.getColor().equals(numberTarget.getColor())) {
            return false;
        }
        if (this.getFilledPattern() == null ? numberTarget.getFilledPattern() != null : !this.getFilledPattern().equals(numberTarget.getFilledPattern())) {
            return false;
        }
        return !(this.getRepresentation() == null ? numberTarget.getRepresentation() != null : !this.getRepresentation().equals(numberTarget.getRepresentation()));
    }

    public boolean canEqual(Object object) {
        return object instanceof NumberTarget;
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + (this.getMixedFraction() == null ? 0 : this.getMixedFraction().hashCode());
        n = n * 31 + (this.getColor() == null ? 0 : this.getColor().hashCode());
        n = n * 31 + (this.getFilledPattern() == null ? 0 : this.getFilledPattern().hashCode());
        n = n * 31 + (this.getRepresentation() == null ? 0 : this.getRepresentation().hashCode());
        return n;
    }

    public String toString() {
        return "NumberTarget(mixedFraction=" + this.getMixedFraction() + ", color=" + this.getColor() + ", filledPattern=" + this.getFilledPattern() + ", representation=" + this.getRepresentation() + ")";
    }
}

