/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fractions.buildafraction.model;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.integerproperty.IntegerProperty;
import edu.colorado.phet.fractions.buildafraction.model.Level;
import edu.colorado.phet.fractions.buildafraction.model.NumberLevelFactory;
import edu.colorado.phet.fractions.buildafraction.model.ShapeLevelFactory;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberLevel;
import edu.colorado.phet.fractions.buildafraction.model.numbers.NumberLevelList;
import edu.colorado.phet.fractions.buildafraction.model.shapes.ShapeLevel;
import edu.colorado.phet.fractions.buildafraction.model.shapes.ShapeLevelList;
import edu.colorado.phet.fractions.buildafraction.view.LevelIdentifier;
import edu.colorado.phet.fractions.buildafraction.view.LevelProgress;
import edu.colorado.phet.fractions.buildafraction.view.LevelType;
import fj.F;
import java.util.HashMap;

public class BuildAFractionModel {
    public final ConstantDtClock clock = new ConstantDtClock();
    public final BooleanProperty audioEnabled;
    public final IntegerProperty selectedPage = new IntegerProperty(0);
    private final HashMap<Integer, NumberLevel> numberLevels = new HashMap();
    private final HashMap<Integer, ShapeLevel> shapeLevels = new HashMap();
    public final F<LevelIdentifier, LevelProgress> gameProgress = new F<LevelIdentifier, LevelProgress>(){

        @Override
        public LevelProgress f(LevelIdentifier levelIdentifier) {
            if (levelIdentifier.levelType == LevelType.SHAPES && BuildAFractionModel.this.shapeLevels.containsKey(levelIdentifier.getLevelIndex())) {
                return new LevelProgress((Integer)((BuildAFractionModel)BuildAFractionModel.this).getLevel((LevelIdentifier)levelIdentifier).filledTargets.get(), ((BuildAFractionModel)BuildAFractionModel.this).getLevel((LevelIdentifier)levelIdentifier).numTargets);
            }
            if (levelIdentifier.levelType == LevelType.NUMBERS && BuildAFractionModel.this.numberLevels.containsKey(levelIdentifier.getLevelIndex())) {
                return new LevelProgress((Integer)((BuildAFractionModel)BuildAFractionModel.this).getLevel((LevelIdentifier)levelIdentifier).filledTargets.get(), ((BuildAFractionModel)BuildAFractionModel.this).getLevel((LevelIdentifier)levelIdentifier).numTargets);
            }
            return new LevelProgress(0, levelIdentifier.getLevelIndex() <= 4 ? 3 : 4);
        }
    };
    private final NumberLevelFactory numberLevelFactory;
    private final ShapeLevelFactory shapeLevelFactory;
    public final BooleanProperty collectedMatch;

    public BuildAFractionModel(BooleanProperty booleanProperty, BooleanProperty booleanProperty2) {
        this(booleanProperty, booleanProperty2, new ShapeLevelList(), new NumberLevelList());
    }

    public BuildAFractionModel(BooleanProperty booleanProperty, BooleanProperty booleanProperty2, ShapeLevelFactory shapeLevelFactory, NumberLevelFactory numberLevelFactory) {
        this.audioEnabled = booleanProperty2;
        this.collectedMatch = booleanProperty;
        this.numberLevelFactory = numberLevelFactory;
        this.shapeLevelFactory = shapeLevelFactory;
    }

    private Level getLevel(LevelIdentifier levelIdentifier) {
        return levelIdentifier.levelType == LevelType.SHAPES ? this.getShapeLevel(levelIdentifier.levelIndex) : this.getNumberLevel(levelIdentifier.levelIndex);
    }

    public NumberLevel getNumberLevel(Integer n) {
        if (!this.numberLevels.containsKey(n)) {
            NumberLevel numberLevel = this.numberLevelFactory.createLevel(n);
            numberLevel.addMatchListener(this.collectedMatch);
            this.numberLevels.put(n, numberLevel);
        }
        return this.numberLevels.get(n);
    }

    public ShapeLevel getShapeLevel(Integer n) {
        if (!this.shapeLevels.containsKey(n)) {
            ShapeLevel shapeLevel = this.shapeLevelFactory.createLevel(n);
            shapeLevel.addMatchListener(this.collectedMatch);
            this.shapeLevels.put(n, shapeLevel);
        }
        return this.shapeLevels.get(n);
    }

    public void resampleNumberLevel(int n) {
        this.numberLevels.remove(n).dispose();
        NumberLevel numberLevel = this.numberLevelFactory.createLevel(n);
        numberLevel.addMatchListener(this.collectedMatch);
        this.numberLevels.put(n, numberLevel);
    }

    public void resampleShapeLevel(int n) {
        this.shapeLevels.remove(n).dispose();
        ShapeLevel shapeLevel = this.shapeLevelFactory.createLevel(n);
        shapeLevel.addMatchListener(this.collectedMatch);
        this.shapeLevels.put(n, shapeLevel);
    }

    public void resetAll() {
        this.selectedPage.reset();
        this.clock.resetSimulationTime();
        for (NumberLevel level : this.numberLevels.values()) {
            level.resetAll();
        }
        this.numberLevels.clear();
        for (ShapeLevel shapeLevel : this.shapeLevels.values()) {
            shapeLevel.resetAll();
        }
        this.shapeLevels.clear();
        this.audioEnabled.reset();
        this.collectedMatch.reset();
    }

    public boolean isLastLevel(int n) {
        return n == 9;
    }

    public boolean isMixedNumbers() {
        return false;
    }
}

